/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.el;

import de.odysseus.el.context.WFElContext;
import de.odysseus.el.function.ArgsDescription;
import java.beans.FeatureDescriptor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELResolver;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.el.IBusinessModel;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputatorExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFObjectNotFoundException;

public class BusinessModelElResolver
extends ELResolver {
    protected static Log logger = LogFactory.getLog(BusinessModelElResolver.class);
    public static final String MODEL_KEY = "model";
    protected VariableScope variableScope;
    private boolean formatValue = true;

    public BusinessModelElResolver(VariableScope variableScope) {
        this.variableScope = variableScope;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (property.toString().startsWith("mc_")) {
            return null;
        }
        if (context instanceof WFElContext && ((WFElContext)context).getEntryUnionParams().containsKey(property.toString())) {
            context.setPropertyResolved(true);
            return ((WFElContext)context).getEntryUnionParams().get(property.toString());
        }
        String lang = (String)this.variableScope.getTransientVariable("lang");
        String string = lang = WfUtils.isEmpty(lang) ? RequestContext.get().getLang().toString() : lang;
        if (base == null && MODEL_KEY.equals(property)) {
            ExecutionEntity execution;
            CommandContext commandContext;
            DynamicObject model;
            context.setPropertyResolved(true);
            DynamicObject dynObj = (DynamicObject)this.variableScope.getTransientVariable(MODEL_KEY);
            if (dynObj != null) {
                logger.debug(String.format("\u8bb0\u5f55\u4f4d\u7f6e\u3010BusinessModelElResolver-getModelFromTransientVariable\u3011- \u8bb0\u5f55\u53d8\u91cf\u3010\u5355\u636e \u3011\u7684\u503c\u4e3a\u3010%s\u3011", dynObj.getPkValue()));
                return dynObj;
            }
            if (this.variableScope instanceof BusinessModelVariableScope && (model = ((BusinessModelVariableScope)this.variableScope).getModel()) != null) {
                logger.debug(String.format("\u8bb0\u5f55\u4f4d\u7f6e\u3010BusinessModelElResolver-getModelFromBusinessModel\u3011- \u8bb0\u5f55\u53d8\u91cf\u3010\u5355\u636e \u3011\u7684\u503c\u4e3a\uff1a\u3010%s\u3011", model.getPkValue()));
                return model;
            }
            if ((this.variableScope instanceof PreComputatorExecutionEntityImpl || this.variableScope instanceof TaskEntity && ((TaskEntity)this.variableScope).getExecution() instanceof PreComputatorExecutionEntityImpl) && (commandContext = Context.getCommandContext()) != null && commandContext.getParsedBusinessObject() != null) {
                return commandContext.getParsedBusinessObject();
            }
            if (this.variableScope instanceof TaskEntityImpl && ((TaskEntityImpl)this.variableScope).getExecution() instanceof PreComputatorExecutionEntityImpl && (execution = ((TaskEntityImpl)this.variableScope).getExecution()).getTransientBill() != null) {
                return execution.getTransientBill();
            }
            String businessKey = null;
            String entityNumber = null;
            if (this.variableScope instanceof IBusinessModel) {
                businessKey = ((IBusinessModel)((Object)this.variableScope)).getBusinessKey();
                entityNumber = ((IBusinessModel)((Object)this.variableScope)).getEntityNumber();
            }
            try {
                dynObj = this.getCacheDynamicObject(entityNumber, businessKey, null);
                if (dynObj == null) {
                    logger.debug(String.format("\u8bb0\u5f55\u53d8\u91cf\u3010%s\u3011\u7684\u503c\u4e3a", "BusinessModelElResolver-getModelFromDBBy\u3010businesskey=" + businessKey + ",entitynumber=" + entityNumber + "\u3011,dynObj is not exist."));
                } else {
                    logger.debug(String.format("\u8bb0\u5f55\u53d8\u91cf\u3010%s\u3011\u7684\u503c\u4e3a", "BusinessModelElResolver-getModelFromDBBy\u3010businesskey=" + businessKey + ",entitynumber=" + entityNumber + "\u3011,dynObj is exist"));
                }
                if (dynObj == null) {
                    String expression = "";
                    if (context instanceof WFElContext) {
                        expression = ((WFElContext)context).getCurrentExpression();
                    }
                    throw new WFObjectNotFoundException(String.format("it cannot find model object[%s] when evaluate [%s],maybe it is not exist.[%s][%s]", property, expression, entityNumber, businessKey));
                }
                return dynObj;
            }
            catch (Exception e) {
                logger.info(WfUtils.getExceptionStacktrace(e), (Object)e);
                throw e;
            }
        }
        if (base instanceof DynamicObject) {
            context.setPropertyResolved(true);
            Object value = null;
            DynamicObject tmp = (DynamicObject)base;
            String prop = property.toString();
            tmp = this.getFullDynamicObj(prop, tmp, context);
            if (tmp == null) {
                return null;
            }
            Object id = tmp.getPkValue();
            String entitynumber = "";
            boolean isMultiCombo = false;
            if (tmp.getDataEntityType() != null) {
                entitynumber = tmp.getDataEntityType().getName();
                DataEntityPropertyCollection col = tmp.getDataEntityType().getProperties();
                if (col != null) {
                    isMultiCombo = col.get((Object)prop) instanceof MulComboProp;
                }
            }
            if ((value = tmp.get(prop)) != null && isMultiCombo) {
                String stringVal = String.valueOf(value);
                if (stringVal.length() > 2) {
                    value = stringVal.substring(1, stringVal.length() - 1);
                } else if (stringVal.length() == 2 && ",,".equals(stringVal)) {
                    value = "";
                }
            }
            value = this.formatReturnValue(lang, value);
            try {
                if (context instanceof WFElContext && value instanceof DynamicObject) {
                    IDataEntityProperty propertyType = (IDataEntityProperty)tmp.getDataEntityType().getProperties().get((Object)prop);
                    ((WFElContext)context).setExpLeftLastDynObjPropType(propertyType);
                }
            }
            catch (Exception e) {
                logger.info(String.format("the property[%s] cannot be fetched,error msg is[%s]", property, WfUtils.getExceptionStacktrace(e)));
            }
            if (value instanceof DynamicObjectCollection) {
                logger.debug(String.format("the property\u3010%s\u3011 size is [%s] is DynamicObjectCollection,src is [%s][%s]", property, ((DynamicObjectCollection)value).size(), id, entitynumber));
            } else if (value instanceof DynamicObject) {
                logger.debug(String.format("the property\u3010%s\u3011 value is [%s] a DaynamicObject,src is [%s][%s]", property, ((DynamicObject)value).getPkValue(), id, entitynumber));
            }
            return value;
        }
        if (base instanceof DynamicObjectCollection) {
            context.setPropertyResolved(true);
            DynamicObjectCollection coll = (DynamicObjectCollection)base;
            if (coll.isEmpty()) {
                return null;
            }
            return this.getDynCollectVal((DynamicObjectCollection)base, property, lang, context);
        }
        if (base instanceof List) {
            context.setPropertyResolved(true);
            List tmp = (List)base;
            boolean isResolved = false;
            if (tmp.isEmpty()) {
                return tmp;
            }
            ArrayList<Object> values = new ArrayList<Object>();
            if (tmp.get(0) instanceof DynamicObject) {
                isResolved = true;
                Object value = null;
                String prop = String.valueOf(property);
                for (DynamicObject obj : (List)base) {
                    if (obj == null || (value = this.formatReturnValue(lang, (obj = this.getFullDynamicObj(prop, obj, context)).get(String.valueOf(property)))) == null) continue;
                    values.add(value);
                }
            } else if (tmp.get(0) instanceof DynamicObjectCollection) {
                isResolved = true;
                for (DynamicObjectCollection i : tmp) {
                    values.addAll(this.getDynCollectVal(i, property, lang, context));
                }
            } else if (tmp.get(0) instanceof String) {
                Object extPropParam = this.getMarcoExtPropParams((WFElContext)context, base);
                if (extPropParam != null) {
                    isResolved = true;
                    ArrayList<Object> pks = new ArrayList<Object>();
                    for (String s : tmp) {
                        if (s.contains(",")) {
                            String[] pkTmp = s.split("\\,");
                            for (int j = 0; j < pkTmp.length; ++j) {
                                if (!WfUtils.isNotEmpty(pkTmp[j]) || pks.contains(pkTmp[j])) continue;
                                pks.add(pkTmp[j]);
                            }
                            pks.addAll(Arrays.asList(s.split("\\,")));
                            continue;
                        }
                        if (pks.contains(s)) continue;
                        pks.add(s);
                    }
                    values.addAll(this.getMarcoExtPropValue(property, lang, extPropParam, pks, context));
                } else {
                    isResolved = false;
                }
            }
            context.setPropertyResolved(isResolved);
            return values;
        }
        Object extPropParam = this.getMarcoExtPropParams((WFElContext)context, base);
        if (extPropParam != null && base != null) {
            context.setPropertyResolved(true);
            String s = base.toString();
            ArrayList<Object> pks = new ArrayList<Object>();
            if (s.contains(",")) {
                String[] pkTmp = s.split("\\,");
                for (int j = 0; j < pkTmp.length; ++j) {
                    if (!WfUtils.isNotEmpty(pkTmp[j])) continue;
                    pks.add(pkTmp[j]);
                }
            } else if (WfUtils.isNotEmpty(s)) {
                pks.add(s);
            }
            if (pks.isEmpty()) {
                return null;
            }
            return this.getMarcoExtPropValue(property, lang, extPropParam, pks, context);
        }
        logger.debug(String.format("the property\u3010%s\u3011 value is [%s]", property, "null"));
        return null;
    }

    private List<Object> getMarcoExtPropValue(Object property, String lang, Object extPropParam, List<Object> pks, ELContext context) {
        Object[] users;
        IDataEntityType type = ORM.create().getDataEntityType(String.valueOf(extPropParam));
        ArrayList<Object> bpks = new ArrayList<Object>(pks.size());
        ISimpleProperty fieldProp = type.getPrimaryKey();
        if (fieldProp instanceof LongProp) {
            for (Object itm : pks) {
                if (itm == null || "".equals(String.valueOf(itm).trim())) continue;
                bpks.add(Long.valueOf(String.valueOf(itm)));
            }
        } else {
            for (Object itm : pks) {
                if (itm == null) continue;
                bpks.add(String.valueOf(itm));
            }
        }
        if ((users = BusinessDataServiceHelper.load((Object[])bpks.toArray(), (IDataEntityType)type)) == null || users.length == 0 || !(users[0] instanceof DynamicObject)) {
            throw new KDException(WFErrorCode.conditionParseError(), new Object[]{"can not find user -- pk:" + WfUtils.listToString(pks, ",")});
        }
        ArrayList<Object> values = new ArrayList<Object>();
        String prop = String.valueOf(property);
        for (int i = 0; i < users.length; ++i) {
            Object value;
            DynamicObject u = (DynamicObject)users[i];
            if (i == 0 || this.needBuildFuctionArgs(context)) {
                this.buildFuctionArgs(prop, u, (WFElContext)context);
            }
            if ((value = this.formatReturnValue(lang, u.get(prop))) == null) continue;
            values.add(value);
        }
        return values;
    }

    private Object getMarcoExtPropParams(WFElContext wfElContext, Object base) {
        if (base == null) {
            return null;
        }
        String key = String.format("%s.%s", "procUser", String.valueOf(base.hashCode()));
        Object extPropParam = wfElContext.getMarcoExtPropParam(key);
        if (extPropParam != null) {
            wfElContext.removeMarcoExtPropParam(key);
        }
        return extPropParam;
    }

    private DynamicObject getFullDynamicObj(String prop, DynamicObject obj, ELContext context) {
        String pk = String.valueOf(obj.getPkValue());
        String entityNumber = obj.getDataEntityType().getName();
        if (WfUtils.isNotEmpty(pk) && !"0".equals(pk)) {
            if (obj.getDataEntityType().getProperties().get((Object)prop) == null) {
                obj = this.getCacheDynamicObject(entityNumber, pk, obj);
            }
            DynamicObjectType dynObjType = null;
            Object value = obj.get(prop);
            if (value instanceof DynamicObjectCollection && (dynObjType = ((DynamicObjectCollection)value).getDynamicObjectType()) instanceof EntryType && !(dynObjType instanceof SubEntryType)) {
                obj = this.getCacheDynamicObject(entityNumber, pk, obj);
            }
        }
        this.buildFuctionArgs(prop, obj, (WFElContext)context);
        return obj;
    }

    private DynamicObject getCacheDynamicObject(String entityNumber, String pk, DynamicObject sourceObj) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null && commandContext.isGetNextNodeCmd()) {
            String cacheKey = String.format("rule_%s.%s", entityNumber, pk);
            DynamicObject obj = commandContext.getCachedDynamicObj().get(cacheKey);
            if (obj == null) {
                obj = WfUtils.findBusinessObject(pk, entityNumber);
                if (obj == null) {
                    obj = sourceObj;
                }
                commandContext.getCachedDynamicObj().put(cacheKey, obj);
            }
            return obj;
        }
        if (commandContext != null && this.fromContext(entityNumber, pk, commandContext)) {
            return commandContext.getParsedBusinessObject();
        }
        DynamicObject tmp = WfUtils.findBusinessObject(pk, entityNumber);
        if (tmp == null) {
            tmp = sourceObj;
        }
        return tmp;
    }

    private boolean fromContext(String entityNumber, String pk, CommandContext commandContext) {
        return ExpressionCalculatorUtil.fromContext(entityNumber, pk, commandContext);
    }

    private void buildFuctionArgs(String prop, DynamicObject obj, WFElContext wfElContext) {
        ArgsDescription argsDescription = wfElContext.peekArgsDescription();
        if (argsDescription == null || !argsDescription.isCanCalculator()) {
            return;
        }
        IDataEntityProperty property = (IDataEntityProperty)obj.getDataEntityType().getProperties().get((Object)prop);
        if (argsDescription.getDynamicObj() == null) {
            argsDescription.setDynamicObj(obj);
            argsDescription.setProperty(prop);
        }
        if ("formatAmountDate".equalsIgnoreCase(argsDescription.getMethodName()) || "formatStandardAmountDate".equalsIgnoreCase(argsDescription.getMethodName())) {
            ArrayList<DynamicObject> entryist;
            if (argsDescription.getExtraAttributes() != null) {
                entryist = (ArrayList<DynamicObject>)argsDescription.getExtraAttributes();
            } else {
                entryist = new ArrayList<DynamicObject>();
                argsDescription.setExtraAttributes(entryist);
            }
            entryist.add(obj);
            this.formatValue = false;
        }
        if (property instanceof ComboProp) {
            argsDescription.setSpecialVal((Object)((ComboProp)property).getComboItems());
        }
    }

    private List getDynCollectVal(DynamicObjectCollection col, Object property, String lang, ELContext context) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (col != null && !col.isEmpty()) {
            if (col.getDynamicObjectType() instanceof SubEntryType) {
                DynamicObject entryItem = (DynamicObject)col.getParent();
                DynamicObject bill = (DynamicObject)entryItem.getParent();
                bill = this.getCacheDynamicObject(bill.getDataEntityType().getName(), bill.getPkValue().toString(), bill);
                DynamicObjectCollection entry = bill.getDynamicObjectCollection(entryItem.getDataEntityType().getName());
                for (DynamicObject i : entry) {
                    if (!i.getPkValue().equals(entryItem.getPkValue())) continue;
                    col = (DynamicObjectCollection)i.get(col.getDynamicObjectType().getName());
                    break;
                }
            } else if (col.getDynamicObjectType() instanceof EntryType) {
                String fieldName = col.getDynamicObjectType().getName();
                DynamicObject parent = (DynamicObject)col.getParent();
                parent = this.getCacheDynamicObject(parent.getDataEntityType().getName(), parent.getPkValue().toString(), parent);
                col = (DynamicObjectCollection)parent.get(fieldName);
            }
            Object value = null;
            for (DynamicObject obj : col) {
                if (obj.getDataEntityType().getProperties().get((Object)property.toString()) == null) {
                    obj = this.getAllPropertysObject(obj);
                }
                if (obj == null) continue;
                obj = this.getFullDynamicObj(String.valueOf(property), obj, context);
                value = obj.get(String.valueOf(property));
                if ((value = this.formatReturnValue(lang, value)) == null) continue;
                values.add(value);
            }
        }
        return values;
    }

    private DynamicObject getAllPropertysObject(DynamicObject dynObj) {
        if (dynObj == null) {
            return null;
        }
        String entityNumber = "";
        Object pkValue = null;
        if (this.isMulBasedata(dynObj)) {
            DynamicObject realObj = (DynamicObject)dynObj.get("fbasedataid");
            if (realObj == null) {
                return null;
            }
            dynObj = realObj;
        }
        entityNumber = dynObj.getDataEntityType().getName();
        pkValue = dynObj.getPkValue();
        if (WfUtils.isNotEmpty(entityNumber) && pkValue != null) {
            return this.getCacheDynamicObject(entityNumber, String.valueOf(pkValue), dynObj);
        }
        throw new KDException(WFErrorCode.conditionParseError(), new Object[]{"Oh, I am dreaming ???"});
    }

    private boolean isMulBasedata(DynamicObject dynObj) {
        IDataEntityType dataParentEntityType;
        String fieldName = dynObj.getDynamicObjectType().getName();
        return dynObj.getParent() instanceof DynamicObject && (dataParentEntityType = ((DynamicObject)dynObj.getParent()).getDataEntityType()).getProperties().get((Object)fieldName) instanceof MulBasedataProp;
    }

    private Object formatReturnValue(String lang, Object value) {
        if (this.formatValue) {
            if (WfUtils.isEmptyString(value)) {
                value = null;
            }
            if (value instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                value = sdf.format(value);
            } else if (value instanceof ILocaleString) {
                value = WfMultiLangUtils.getCurrentLang((ILocaleString)value, lang);
            }
        }
        return value;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return true;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        logger.debug("\u3010sonar\u5ba1\u8ba1\u3011\u4e0d\u80fd\u4e3a\u7a7a\u65b9\u6cd5");
    }

    public Class<?> getCommonPropertyType(ELContext arg0, Object arg1) {
        return Object.class;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext arg0, Object arg1) {
        return null;
    }

    public Class<?> getType(ELContext arg0, Object arg1, Object arg2) {
        return Object.class;
    }

    private boolean needBuildFuctionArgs(ELContext context) {
        if (context instanceof WFElContext && ((WFElContext)context).peekArgsDescription() != null) {
            String method = ((WFElContext)context).peekArgsDescription().getMethodName();
            return "formatStandardAmountDate".equalsIgnoreCase(method) || "formatAmountDate".equalsIgnoreCase(method);
        }
        return false;
    }
}

