/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.el;

import de.odysseus.el.context.WFElContext;
import de.odysseus.el.misc.ExpBooleanOperation;
import de.odysseus.el.misc.TypeConverter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.el.ELContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.OrgProp;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.el.comparetype.CompareTypeParser;
import kd.bos.workflow.engine.impl.el.comparetype.ExtCompareTypeParserFactory;
import kd.bos.workflow.engine.impl.persistence.entity.management.OrgTypeEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.RoleEntityManager;
import kd.bos.workflow.engine.impl.util.ReflectUtil;
import kd.bos.workflow.exception.WFErrorCode;
import org.apache.commons.beanutils.MethodUtils;

public class ExpBooleanOperationImpl
implements ExpBooleanOperation {
    private Log logger = LogFactory.getLog(this.getClass());
    protected Map<String, Class<CompareTypeParser>> extOperationParsers = new HashMap<String, Class<CompareTypeParser>>();
    protected Map<String, CompareTypeParser> extOperationParserInstances = new HashMap<String, CompareTypeParser>();
    private ELContext context = null;

    public boolean parserExtCompareType(String compareType, Object left, Object right) {
        boolean result;
        block5: {
            this.dispatchLog("parserExtCompareType", compareType, left, right);
            result = false;
            try {
                Class<CompareTypeParser> clazz;
                CompareTypeParser parser = this.extOperationParserInstances.get(compareType);
                if (parser == null && (clazz = this.extOperationParsers.get(compareType)) != null) {
                    Class<?> cls = ReflectUtil.loadClass(clazz.getName());
                    Constructor<?> cst = cls.getDeclaredConstructor(new Class[0]);
                    parser = (CompareTypeParser)cst.newInstance(new Object[0]);
                }
                if (parser != null) {
                    Object o = MethodUtils.invokeMethod((Object)parser, (String)"parseExpression", (Object[])new Object[]{left, right});
                    if (o != null) {
                        result = (Boolean)o;
                    }
                    break block5;
                }
                throw new KDException(WFErrorCode.conditionParseError(), new Object[]{String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a\u627e\u4e0d\u5230\u6bd4\u8f83\u7b26\u201c%s\u201d\u7684\u89e3\u6790\u7c7b\u3002", (String)"ExpBooleanOperationImpl_1", (String)"bos-wf-engine", (Object[])new Object[0]), compareType)});
            }
            catch (Exception e) {
                this.logger.info("parserExtCompareType\u5f02\u5e38\uff1a" + e.getMessage());
                throw new KDException(WFErrorCode.conditionParseError(), new Object[]{String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a\u6bd4\u8f83\u7b26\u201c%1$s\u201d\u89e3\u6790\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%2$s\u3002", (String)"ExpBooleanOperationImpl_3", (String)"bos-wf-engine", (Object[])new Object[0]), compareType, e.getMessage())});
            }
        }
        return result;
    }

    public boolean operation(String symbol, TypeConverter converter, Object o1, Object o2) {
        this.dispatchLog("operation", symbol, o1, o2);
        boolean result = false;
        if (o1 instanceof String) {
            boolean split;
            boolean bl = split = ((String)o1).indexOf(44) > -1;
            if (split) {
                o1 = Arrays.asList(((String)o1).split(","));
            } else if (!((String)o1).startsWith("0") && ((String)o1).matches("^\\d+$")) {
                o1 = Long.valueOf(o1.toString());
            }
        }
        if (o2 instanceof String && !((String)o2).startsWith("0") && ((String)o2).matches("^\\d+$")) {
            o2 = Long.valueOf(o2.toString());
        }
        this.logger.debug("ExpBooleanOperationImpl operation symbol:" + symbol);
        switch (symbol) {
            case "BS": {
                Long id;
                if (o1 instanceof Long && o2 instanceof Long) {
                    if (o1.equals(o2)) {
                        result = true;
                        break;
                    }
                    result = OrgViewServiceHelper.isOrgBelongTo((String)"01", (Long)((Long)o1), (Long)((Long)o2));
                    break;
                }
                if (!(o1 instanceof List)) break;
                List r = (List)o1;
                Iterator iterator = r.iterator();
                while (iterator.hasNext() && !(result = (id = (Long)iterator.next()).equals(o2) ? true : OrgViewServiceHelper.isOrgBelongTo((String)"01", (Long)id, (Long)((Long)o2)))) {
                }
                break;
            }
            case "CS": {
                Long id;
                if (o1 instanceof Long && o2 instanceof Long) {
                    if (o1.equals(o2)) {
                        result = true;
                        break;
                    }
                    result = OrgViewServiceHelper.isOrgInclude((String)"01", (Long)((Long)o1), (Long)((Long)o2));
                    break;
                }
                if (!(o1 instanceof List)) break;
                List r = (List)o1;
                Iterator iterator = r.iterator();
                while (iterator.hasNext() && !(result = (id = (Long)iterator.next()).equals(o2) ? true : OrgViewServiceHelper.isOrgInclude((String)"01", (Long)id, (Long)((Long)o2)))) {
                }
                break;
            }
            case "BO": {
                Long id;
                if (o1 instanceof Long && o2 instanceof Long) {
                    result = UserServiceHelper.isUserBelongTo((Long)((Long)o1), (Long)((Long)o2));
                    break;
                }
                if (!(o1 instanceof List)) break;
                List r = (List)o1;
                Iterator iterator = r.iterator();
                while (iterator.hasNext() && !(result = UserServiceHelper.isUserBelongTo((Long)(id = (Long)iterator.next()), (Long)((Long)o2)))) {
                }
                break;
            }
            case "BR": {
                result = this.isUserBelongToRole(o1, o2);
                break;
            }
            case "NR": {
                result = !this.isUserBelongToRole(o1, o2);
                break;
            }
            case "BL": {
                if (o1 == null || o2 == null) {
                    return false;
                }
                return o2.toString().contains(o1.toString());
            }
            case "NB": {
                if (o1 == null || o2 == null) {
                    return false;
                }
                return !o2.toString().contains(o1.toString());
            }
            case "IN": {
                if (o1 == null || o2 == null) {
                    return false;
                }
                List<String> inv1 = this.transforStrList(o1);
                List<String> inv2 = this.transforStrList(o2);
                for (String v : inv1) {
                    if (!inv2.contains(v)) {
                        return false;
                    }
                    result = true;
                }
                break;
            }
            case "NI": {
                if (o1 == null || o2 == null) {
                    return true;
                }
                List<String> niv1 = this.transforStrList(o1);
                List<String> niv2 = this.transforStrList(o2);
                for (String v : niv1) {
                    if (!niv2.contains(v)) {
                        return true;
                    }
                    result = false;
                }
                break;
            }
            case "CL": {
                if (o1 == null || o2 == null) {
                    return false;
                }
                List<String> clv1 = this.transforStrList(o1);
                List<String> clv2 = this.transforStrList(o2);
                for (String v : clv2) {
                    if (!clv1.contains(v)) {
                        return false;
                    }
                    result = true;
                }
                break;
            }
            case "NC": {
                if (o1 == null || o2 == null) {
                    return true;
                }
                List<String> ncv1 = this.transforStrList(o1);
                List<String> ncv2 = this.transforStrList(o2);
                for (String v : ncv2) {
                    if (!ncv1.contains(v)) {
                        return true;
                    }
                    result = false;
                }
                break;
            }
            case "BT": {
                result = this.isOrgBelongToOrgType(o1, o2);
                break;
            }
            case "NBT": {
                result = !this.isOrgBelongToOrgType(o1, o2);
                break;
            }
            case "BTU": {
                result = this.isUserBelongToOrgType(o1, o2);
                break;
            }
            case "NBTU": {
                result = !this.isUserBelongToOrgType(o1, o2);
                break;
            }
            default: {
                result = ExtCompareTypeParserFactory.newInstance().parserExtCompareType(symbol, o1, o2, converter);
            }
        }
        return result;
    }

    private boolean isOrgBelongToOrgType(Object o1, Object o2) {
        Boolean result;
        block7: {
            OrgTypeEntityManager orgTypeEntityManager;
            block8: {
                block9: {
                    result = Boolean.FALSE;
                    orgTypeEntityManager = Context.getCommandContext().getOrgTypeEntityManager();
                    if (!(o1 instanceof Long) && !(o1 instanceof String)) break block8;
                    if (!(o1 instanceof Long)) break block9;
                    String orgViewType = this.getOrgViewType(Long.valueOf(String.valueOf(o1)));
                    result = orgTypeEntityManager.isOrgBelongToOrgType(Long.valueOf(String.valueOf(o1)), Long.valueOf(String.valueOf(o2)), orgViewType);
                    break block7;
                }
                if (!(o1 instanceof String)) break block7;
                String orgs = String.valueOf(o1);
                if (orgs.contains(",")) {
                    String[] allOrg;
                    for (String oid : allOrg = orgs.split(",")) {
                        if (!WfUtils.isNotEmpty(oid)) continue;
                        String orgViewType = this.getOrgViewType(Long.valueOf(String.valueOf(oid)));
                        result = orgTypeEntityManager.isOrgBelongToOrgType(Long.valueOf(String.valueOf(oid)), Long.valueOf(String.valueOf(o2)), orgViewType);
                        if (result.booleanValue()) {
                            continue;
                        }
                        break block7;
                    }
                } else {
                    if (WfUtils.isEmpty(orgs)) {
                        return false;
                    }
                    String orgViewType = this.getOrgViewType(Long.valueOf(String.valueOf(orgs)));
                    result = orgTypeEntityManager.isOrgBelongToOrgType(Long.valueOf(orgs), Long.valueOf(String.valueOf(o2)), orgViewType);
                }
                break block7;
            }
            if (o1 instanceof List) {
                List r = (List)o1;
                for (Object id : r) {
                    String orgViewType = this.getOrgViewType(Long.valueOf(String.valueOf(id)));
                    result = orgTypeEntityManager.isOrgBelongToOrgType(Long.valueOf(String.valueOf(id)), Long.valueOf(String.valueOf(o2)), orgViewType);
                    if (result.booleanValue()) continue;
                    break;
                }
            }
        }
        return result;
    }

    private boolean isUserBelongToOrgType(Object o1, Object o2) {
        Boolean result;
        block8: {
            OrgTypeEntityManager orgTypeEntityManager;
            block6: {
                block7: {
                    result = Boolean.FALSE;
                    orgTypeEntityManager = Context.getCommandContext().getOrgTypeEntityManager();
                    if (!(o1 instanceof Long) && !(o1 instanceof String)) break block6;
                    if (!(o1 instanceof Long)) break block7;
                    result = orgTypeEntityManager.isUserBelongToOrgType(Long.valueOf(String.valueOf(o1)), Long.valueOf(String.valueOf(o2)));
                    break block8;
                }
                if (!(o1 instanceof String)) break block8;
                String users = String.valueOf(o1);
                if (users.contains(",")) {
                    String[] allUser;
                    for (String uid : allUser = users.split(",")) {
                        if (WfUtils.isNotEmpty(uid) && !(result = orgTypeEntityManager.isUserBelongToOrgType(Long.valueOf(String.valueOf(uid)), Long.valueOf(String.valueOf(o2)))).booleanValue()) break;
                    }
                } else {
                    if (WfUtils.isEmpty(users)) {
                        return false;
                    }
                    result = orgTypeEntityManager.isUserBelongToOrgType(Long.valueOf(users), Long.valueOf(String.valueOf(o2)));
                }
                break block8;
            }
            if (o1 instanceof List) {
                Object id;
                List r = (List)o1;
                Iterator iterator = r.iterator();
                while (iterator.hasNext() && (result = orgTypeEntityManager.isUserBelongToOrgType(Long.valueOf(String.valueOf(id = iterator.next())), Long.valueOf(String.valueOf(o2)))).booleanValue()) {
                }
            }
        }
        return result;
    }

    private void dispatchLog(Object ... args) {
        List<Object> params;
        if (args != null && (params = Arrays.asList(args)) != null && params.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Boolean-Method:[%s]", params.get(0))).append("Params:[");
            for (int i = 1; i < params.size(); ++i) {
                sb.append(params.get(i)).append(",");
                if (params.get(i) == null) continue;
                sb.append(params.get(i).getClass()).append(",");
            }
            sb.append("]");
            this.logger.debug(sb.toString());
        }
    }

    private List<String> transforStrList(Object o) {
        List<String> resultList = new ArrayList<String>();
        if (o instanceof List) {
            for (Object i : (List)o) {
                resultList.add(i.toString());
            }
        } else if (o instanceof String) {
            String os = o.toString();
            if (os.contains(",")) {
                resultList = Arrays.asList(os.split(","));
            } else {
                resultList.add(o.toString());
            }
        } else {
            resultList.add(o.toString());
        }
        return resultList;
    }

    public ELContext getContext() {
        return this.context;
    }

    public void setContext(ELContext context) {
        this.context = context;
    }

    private String getOrgViewType(Long orgId) {
        IDataEntityProperty propertyType;
        String orgViewType = "01";
        if (this.getContext() != null && this.getContext() instanceof WFElContext && (propertyType = ((WFElContext)this.getContext()).getExpLeftLastDynObjPropType()) instanceof OrgProp) {
            OrgProp orgProp = (OrgProp)propertyType;
            String orgFunc = orgProp.getOrgFunc();
            if (WfUtils.isEmpty(orgFunc) && !OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"01")) {
                orgFunc = "15";
            }
            if (WfUtils.isNotEmpty(orgFunc)) {
                orgViewType = orgFunc;
            }
        }
        return orgViewType;
    }

    private boolean isUserBelongToRole(Object o1, Object o2) {
        boolean result = Boolean.FALSE;
        RoleEntityManager roleEntityManager = Context.getCommandContext().getRoleEntityManager();
        if (o1 instanceof Long || o1 instanceof String) {
            result = roleEntityManager.isUserBelongToRole(WfUtils.getLongValueFromObj(o1), WfUtils.getLongValueFromObj(o2));
        } else if (o1 instanceof List) {
            List r = (List)o1;
            List<Long> collect = r.stream().mapToLong(WfUtils::getLongValueFromObj).boxed().collect(Collectors.toList());
            result = roleEntityManager.isUsersBelongToRole(collect, WfUtils.getLongValueFromObj(o2));
        }
        return result;
    }
}

