/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.el;

import de.odysseus.el.ExpressionFactoryImpl;
import de.odysseus.el.TreeValueExpression;
import de.odysseus.el.context.WFElContext;
import de.odysseus.el.tree.ExpressionNode;
import java.util.HashMap;
import java.util.Map;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import kd.bos.bec.engine.el.EventModelElResolver;
import kd.bos.workflow.engine.delegate.Expression;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.el.BusinessModelElResolver;
import kd.bos.workflow.engine.impl.el.ExtExpressionELResolver;
import kd.bos.workflow.engine.impl.el.JsonNodeELResolver;
import kd.bos.workflow.engine.impl.el.JuelExpression;
import kd.bos.workflow.engine.impl.el.MethodMapELResolver;
import kd.bos.workflow.engine.impl.el.ParsingElContext;
import kd.bos.workflow.engine.impl.el.ProcessMarcoElResolver;
import kd.bos.workflow.engine.impl.el.ProcessTaskElResolver;
import kd.bos.workflow.engine.impl.el.VariableScopeElResolver;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableScopeImpl;

public class ExpressionManager {
    protected ExpressionFactory expressionFactory;
    protected ELContext parsingElContext = new ParsingElContext();
    protected Map<Object, Object> beans;
    protected Map<String, String> tmp = new HashMap<String, String>();

    public ExpressionManager() {
        this(null);
    }

    public ExpressionManager(boolean initFactory) {
        this(null, false);
    }

    public ExpressionManager(Map<Object, Object> beans) {
        this(beans, true);
    }

    public ExpressionManager(Map<Object, Object> beans, boolean initFactory) {
        this.expressionFactory = new ExpressionFactoryImpl();
        this.beans = beans;
    }

    public Expression createExpression(String expression) {
        ValueExpression valueExpression = this.expressionFactory.createValueExpression(this.parsingElContext, expression.trim(), Object.class);
        return new JuelExpression(valueExpression, expression);
    }

    public ExpressionNode createExpressionNode(String expression) {
        TreeValueExpression tree = (TreeValueExpression)this.expressionFactory.createValueExpression(this.parsingElContext, expression.trim(), Object.class);
        return tree.getNode();
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    public ELContext getElContext(VariableScope variableScope) {
        ELContext elContext = null;
        if (variableScope instanceof VariableScopeImpl) {
            VariableScopeImpl variableScopeImpl = (VariableScopeImpl)variableScope;
            elContext = variableScopeImpl.getCachedElContext();
        }
        if (elContext == null) {
            elContext = this.createElContext(variableScope);
            if (variableScope instanceof VariableScopeImpl) {
                ((VariableScopeImpl)variableScope).setCachedElContext(elContext);
            }
        }
        return elContext;
    }

    protected WFElContext createElContext(VariableScope variableScope) {
        ELResolver elResolver = this.createElResolver(variableScope);
        return new WFElContext(elResolver);
    }

    protected ELResolver createElResolver(VariableScope variableScope) {
        CompositeELResolver elResolver = new CompositeELResolver();
        elResolver.add((ELResolver)new EventModelElResolver(variableScope));
        elResolver.add((ELResolver)new VariableScopeElResolver(variableScope));
        elResolver.add((ELResolver)new BusinessModelElResolver(variableScope));
        elResolver.add((ELResolver)new ProcessMarcoElResolver(variableScope));
        elResolver.add((ELResolver)new ProcessTaskElResolver(variableScope));
        elResolver.add((ELResolver)new ExtExpressionELResolver(variableScope));
        elResolver.add((ELResolver)new JsonNodeELResolver());
        if (this.beans != null) {
            elResolver.add((ELResolver)new MethodMapELResolver(this.beans, variableScope));
        }
        return elResolver;
    }

    public Map<Object, Object> getBeans() {
        return this.beans;
    }

    public void setBeans(Map<Object, Object> beans) {
        this.beans = beans;
    }
}

