/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.el;

import de.odysseus.el.context.WFElContext;
import de.odysseus.el.util.ELResolverUtil;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.Expression;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.delegate.invocation.ExpressionGetInvocation;
import kd.bos.workflow.engine.impl.delegate.invocation.ExpressionSetInvocation;
import kd.bos.workflow.engine.impl.el.IBusinessModel;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputatorExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.exception.WFEngineException;

public class JuelExpression
implements Expression {
    private static Log logger = LogFactory.getLog((String)JuelExpression.class.getName());
    protected String expressionText;
    protected ValueExpression valueExpression;
    private static final String ERRORDESCRIPTION = "Error while evaluating expression: ";

    public JuelExpression(ValueExpression valueExpression, String expressionText) {
        this.valueExpression = valueExpression;
        this.expressionText = expressionText;
    }

    @Override
    public Object getValue(VariableScope variableScope) {
        ELContext elContext = Context.getProcessEngineConfiguration().getExpressionManager().getElContext(variableScope);
        try {
            String ruleKeyEntry = (String)variableScope.getTransientVariable("conditionRule_keyEntry");
            logger.debug("ruleKeyEntry : " + ruleKeyEntry);
            if (WfUtils.isNotEmpty(ruleKeyEntry)) {
                String unionRule = (String)variableScope.getTransientVariable("conditionRule_unionrule");
                DynamicObject model = this.getModel(variableScope);
                DynamicObjectCollection targetEntry = null;
                if (model != null) {
                    targetEntry = model.getDynamicObjectCollection(ruleKeyEntry);
                }
                ELResolverUtil.setCurrentExpression((ELContext)elContext, (String)this.valueExpression.getExpressionString());
                ELResolverUtil.clearAll((ELContext)elContext);
                boolean isAnyOne = "entryAnyOne".equals(unionRule);
                if (targetEntry != null && !targetEntry.isEmpty()) {
                    for (DynamicObject entryItem : targetEntry) {
                        ((WFElContext)elContext).getEntryUnionParams().put(ruleKeyEntry, entryItem);
                        ExpressionGetInvocation invocation = new ExpressionGetInvocation(this.valueExpression, elContext);
                        Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
                        Object ret = invocation.getInvocationResult();
                        logger.debug("entryItem : " + entryItem + ":ret" + ret);
                        if (!(ret instanceof Boolean)) {
                            throw new WFEngineException("condition expression returns non-Boolean: " + ret + " (" + ret.getClass().getName() + ")");
                        }
                        if ((!isAnyOne || !((Boolean)ret).booleanValue()) && (isAnyOne || ((Boolean)ret).booleanValue())) continue;
                        return ret;
                    }
                } else {
                    logger.info("targetEntry is null or empty.");
                    return false;
                }
                return !isAnyOne;
            }
            ELResolverUtil.clearAll((ELContext)elContext);
            ELResolverUtil.setCurrentExpression((ELContext)elContext, (String)this.valueExpression.getExpressionString());
            ExpressionGetInvocation invocation = new ExpressionGetInvocation(this.valueExpression, elContext);
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
            return invocation.getInvocationResult();
        }
        catch (PropertyNotFoundException pnfe) {
            throw new WFEngineException("Unknown property used in expression: " + this.expressionText, pnfe);
        }
        catch (MethodNotFoundException mnfe) {
            throw new WFEngineException("Unknown method used in expression: " + this.expressionText, mnfe);
        }
        catch (ELException ele) {
            throw new WFEngineException(ERRORDESCRIPTION + this.expressionText, ele);
        }
        catch (WFEngineException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WFEngineException(ERRORDESCRIPTION + this.expressionText, e);
        }
    }

    @Override
    public void setValue(Object value, VariableScope variableScope) {
        ELContext elContext = Context.getProcessEngineConfiguration().getExpressionManager().getElContext(variableScope);
        try {
            ExpressionSetInvocation invocation = new ExpressionSetInvocation(this.valueExpression, elContext, value);
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
        }
        catch (Exception e) {
            throw new WFEngineException(ERRORDESCRIPTION + this.expressionText, e);
        }
    }

    public String toString() {
        if (this.valueExpression != null) {
            return this.valueExpression.getExpressionString();
        }
        return super.toString();
    }

    private DynamicObject getModel(VariableScope variableScope) {
        CommandContext commandContext;
        DynamicObject model;
        DynamicObject dynObj = (DynamicObject)variableScope.getTransientVariable("model");
        if (dynObj != null) {
            return dynObj;
        }
        if (variableScope instanceof BusinessModelVariableScope && (model = ((BusinessModelVariableScope)variableScope).getModel()) != null) {
            return model;
        }
        if ((variableScope instanceof PreComputatorExecutionEntityImpl || variableScope instanceof TaskEntity && ((TaskEntity)variableScope).getExecution() instanceof PreComputatorExecutionEntityImpl) && (commandContext = Context.getCommandContext()) != null && commandContext.getParsedBusinessObject() != null) {
            return commandContext.getParsedBusinessObject();
        }
        String businessKey = null;
        String entityNumber = null;
        if (variableScope instanceof IBusinessModel) {
            businessKey = ((IBusinessModel)((Object)variableScope)).getBusinessKey();
            entityNumber = ((IBusinessModel)((Object)variableScope)).getEntityNumber();
        }
        return this.getCacheDynamicObject(entityNumber, businessKey, null);
    }

    private DynamicObject getCacheDynamicObject(String entityNumber, String pk, DynamicObject sourceObj) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null && commandContext.isGetNextNodeCmd()) {
            String cacheKey = String.format("rule_%s.%s", entityNumber, pk);
            DynamicObject obj = commandContext.getCachedDynamicObj().get(cacheKey);
            if (obj == null) {
                obj = WfUtils.findBusinessObject(pk, entityNumber);
                if (obj == null) {
                    obj = sourceObj;
                }
                commandContext.getCachedDynamicObj().put(cacheKey, obj);
            }
            return obj;
        }
        if (commandContext != null && ExpressionCalculatorUtil.fromContext(entityNumber, pk, commandContext)) {
            return commandContext.getParsedBusinessObject();
        }
        DynamicObject tmp = WfUtils.findBusinessObject(pk, entityNumber);
        if (tmp == null) {
            tmp = sourceObj;
        }
        return tmp;
    }

    @Override
    public String getExpressionText() {
        return this.expressionText;
    }
}

