/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.el;

import de.odysseus.el.context.WFElContext;
import de.odysseus.el.function.ArgsDescription;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELResolver;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.Macro;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.calculator.ProcessMacroParserImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputatorExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableScopeImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.ReflectUtil;
import kd.bos.workflow.exception.ExceptionUtil;
import org.apache.commons.beanutils.MethodUtils;

public class ProcessMarcoElResolver
extends ELResolver {
    protected static Log logger = LogFactory.getLog(ProcessMarcoElResolver.class);
    public static final String PROCESS_KEY = "proc";
    public static final String ENTRABILL = "entrabill";
    public static final String STARTTIME = "startTime";
    public static final String PROCNAME = "procName";
    protected VariableScope variableScope;

    public ProcessMarcoElResolver(VariableScope variableScope) {
        this.variableScope = variableScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getValue(ELContext context, Object base, Object property) {
        if (base == null && PROCESS_KEY.equals(property)) {
            context.setPropertyResolved(true);
            Process process = null;
            if (this.variableScope instanceof TaskEntityImpl) {
                return ProcessDefinitionUtil.getProcess(((TaskEntityImpl)this.variableScope).getProcessDefinitionId(), ((TaskEntityImpl)this.variableScope).getProcessInstanceId());
            }
            if (this.variableScope instanceof ExecutionEntityImpl) {
                return ProcessDefinitionUtil.getProcess(((ExecutionEntityImpl)this.variableScope).getProcessDefinitionId(), ((ExecutionEntityImpl)this.variableScope).getProcessInstanceId());
            }
            if (!(this.variableScope instanceof PreComputatorExecutionEntityImpl)) return process;
            return ProcessDefinitionUtil.getProcess(((PreComputatorExecutionEntityImpl)this.variableScope).getProcessDefinitionId(), ((PreComputatorExecutionEntityImpl)this.variableScope).getProcessInstanceId());
        }
        if (!(base instanceof Process)) return null;
        if (property.toString().startsWith("mc_")) return null;
        context.setPropertyResolved(true);
        VariableScopeImpl execution = null;
        Set<Object> taskLocaLVariables = new HashSet();
        if (this.variableScope instanceof TaskEntityImpl) {
            if (((TaskEntityImpl)this.variableScope).getExecution() instanceof ExecutionEntityImpl) {
                execution = (ExecutionEntityImpl)((TaskEntityImpl)this.variableScope).getExecution();
            } else if (((TaskEntityImpl)this.variableScope).getExecution() instanceof PreComputatorExecutionEntityImpl) {
                execution = (PreComputatorExecutionEntityImpl)((TaskEntityImpl)this.variableScope).getExecution();
            }
            taskLocaLVariables = this.variableScope.getTransientVariablesLocal().keySet();
            if (!taskLocaLVariables.isEmpty() && execution != null) {
                for (String string : taskLocaLVariables) {
                    execution.setTransientVariableLocal(string, this.variableScope.getVariable(string));
                }
            }
        } else if (this.variableScope instanceof ExecutionEntityImpl) {
            execution = (ExecutionEntityImpl)this.variableScope;
        } else if (this.variableScope instanceof PreComputatorExecutionEntityImpl) {
            execution = (PreComputatorExecutionEntityImpl)this.variableScope;
        }
        List<Macro> marcos = ((Process)base).getMacros();
        if (PROCNAME.equals(property)) {
            String string = ((Process)base).getName();
            return string;
        }
        if (ENTRABILL.equals(property)) {
            String string = ((Process)base).getEntraBillId();
            return string;
        }
        if (STARTTIME.equals(property) && execution != null) {
            Date date = execution.getProcessInstance().getCreateDate();
            if (date != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String string = sdf.format(date);
                return string;
            }
            Object sdf = null;
            return sdf;
        }
        if ("currentParticipant".equals(property)) {
            Object object = this.variableScope.getTransientVariableLocal("currentParticipant");
            return object;
        }
        boolean bl = false;
        for (Macro macro : marcos) {
            if (macro == null || execution == null || !macro.getName().equals(property)) continue;
            boolean bl2 = true;
            try {
                ArgsDescription argsDes = ((WFElContext)context).peekArgsDescription();
                if (argsDes != null && argsDes.isCanCalculator()) {
                    execution.setTransientVariable("buildEnumMarcoMark", argsDes);
                }
                Class<?> cls = ReflectUtil.loadClass(macro.getParseClass());
                Constructor<?> cst = cls.getDeclaredConstructor(String.class);
                Object returnVal = MethodUtils.invokeMethod(cst.newInstance(property), (String)"parseMacro", (Object[])new Object[]{execution});
                this.buildFunctionArgs((ExecutionEntity)((Object)execution), (WFElContext)context, property);
                ProcessMarcoElResolver.buildMarcoExtPropParams(context, property, returnVal);
                Object object = returnVal;
                return object;
            }
            catch (Exception e) {
                throw ExceptionUtil.createWFConditionParseException(macro.getName(), this.variableScope, e);
            }
        }
        if (bl) return null;
        if (execution == null) return null;
        try {
            ArgsDescription argsDes = ((WFElContext)context).peekArgsDescription();
            if (argsDes != null && argsDes.isCanCalculator()) {
                execution.setTransientVariable("buildEnumMarcoMark", argsDes);
            }
            ProcessMacroParserImpl processMacroParserImpl = new ProcessMacroParserImpl((String)property);
            Object returnVal = processMacroParserImpl.parseMacro((ExecutionEntity)((Object)execution));
            this.buildFunctionArgs((ExecutionEntity)((Object)execution), (WFElContext)context, property);
            ProcessMarcoElResolver.buildMarcoExtPropParams(context, property, returnVal);
            return returnVal;
        }
        catch (Exception e) {
            throw ExceptionUtil.createWFConditionParseException((String)property, this.variableScope, e);
        }
        finally {
            if (taskLocaLVariables != null && !taskLocaLVariables.isEmpty() && execution != null) {
                for (String string : taskLocaLVariables) {
                    execution.removeTransientVariableLocal(string);
                }
            }
        }
    }

    private void buildFunctionArgs(ExecutionEntity execution, WFElContext wfElContext, Object property) {
        Object combos = execution.getTransientVariable("enumMarcoCombos");
        ArgsDescription argsDescription = wfElContext.peekArgsDescription();
        if (combos == null || argsDescription == null || !argsDescription.isCanCalculator()) {
            return;
        }
        execution.removeTransientVariable("enumMarcoCombos");
        argsDescription.setProperty(String.valueOf(property));
        wfElContext.peekArgsDescription().setSpecialVal(combos);
    }

    public static void buildMarcoExtPropParams(ELContext context, Object property, Object returnVal) {
        String ptmp = String.valueOf(property);
        if ("initiator".equalsIgnoreCase(ptmp) || "lastAssignee".equalsIgnoreCase(ptmp) || ptmp.endsWith("Assignee") || "currentParticipant".equalsIgnoreCase(String.valueOf(property))) {
            WFElContext wfElContext = (WFElContext)context;
            if (returnVal == null) {
                returnVal = "";
            }
            String key = String.format("%s.%s", "procUser", String.valueOf(returnVal.hashCode()));
            wfElContext.setMarcoExtPropParam(key, (Object)"bos_user");
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return true;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        logger.debug("\u3010sonar\u5ba1\u8ba1\u3011\u4e0d\u80fd\u4e3a\u7a7a\u65b9\u6cd5");
    }

    public Class<?> getCommonPropertyType(ELContext arg0, Object arg1) {
        return Object.class;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext arg0, Object arg1) {
        return null;
    }

    public Class<?> getType(ELContext arg0, Object arg1, Object arg2) {
        return Object.class;
    }
}

