/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.el.comparetype;

import de.odysseus.el.misc.TypeConverter;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.comparetype.WfCompareTypeDto;
import kd.bos.workflow.engine.impl.el.comparetype.CompareTypeParser;
import kd.bos.workflow.engine.impl.util.ReflectUtil;
import kd.bos.workflow.exception.WFErrorCode;
import org.apache.commons.beanutils.MethodUtils;

public class ExtCompareTypeParserFactory {
    private Log logger = LogFactory.getLog(this.getClass());
    protected Map<String, Class<? extends CompareTypeParser>> extOperationParsers = new HashMap<String, Class<? extends CompareTypeParser>>();
    protected Map<String, CompareTypeParser> extOperationParserInstances = new HashMap<String, CompareTypeParser>();
    private static ExtCompareTypeParserFactory instance;

    private ExtCompareTypeParserFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExtCompareTypeParserFactory newInstance() {
        if (instance != null) {
            return instance;
        }
        Class<ExtCompareTypeParserFactory> clazz = ExtCompareTypeParserFactory.class;
        synchronized (ExtCompareTypeParserFactory.class) {
            if (instance == null) {
                instance = new ExtCompareTypeParserFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean parserExtCompareType(String compareType, Object left, Object right, TypeConverter converter) {
        boolean result;
        block6: {
            this.logger.debug("\u5f00\u59cb\u89e3\u6790\uff1acompareType\uff1a" + compareType + "\uff0cleft\uff1a" + left + "\uff0cright\uff1a" + right);
            result = false;
            try {
                Class<? extends CompareTypeParser> clazz;
                if (left == null || right == null) {
                    return this.getNullResult(compareType);
                }
                CompareTypeParser parser = this.extOperationParserInstances.get(compareType);
                if (parser == null && (clazz = this.extOperationParsers.get(compareType)) != null) {
                    Class<?> cls = ReflectUtil.loadClass(clazz.getName());
                    Constructor<?> cst = cls.getDeclaredConstructor(new Class[0]);
                    parser = (CompareTypeParser)cst.newInstance(new Object[0]);
                }
                if (parser != null) {
                    Object o = MethodUtils.invokeMethod((Object)parser, (String)"parser", (Object[])new Object[]{left, right, converter});
                    this.extOperationParserInstances.put(compareType, parser);
                    this.logger.debug("\u89e3\u6790\u7ed3\u675f\uff1acompareType\uff1a" + compareType + "\uff0cleft\uff1a" + left + "\uff0cright\uff1a" + right + "\uff0c\u7ed3\u679c\uff1a" + o);
                    if (o != null) {
                        result = (Boolean)o;
                    }
                    break block6;
                }
                throw new KDException(WFErrorCode.conditionParseError(), new Object[]{String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u89e3\u6790\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u6bd4\u8f83\u7b26\u4e3a\uff1a%s\u7684\u89e3\u6790\u89e3\u6790\u7c7b\u3002", (String)"ExtCompareTypeParserFactory_1", (String)"bos-wf-engine", (Object[])new Object[0]), compareType)});
            }
            catch (Exception e) {
                this.logger.debug("parserExtCompareType\u5f02\u5e38\uff1a" + e.getMessage());
                throw new KDException(WFErrorCode.conditionParseError(), new Object[]{String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a\u6bd4\u8f83\u7b26\u201c%1$s\u201d\u89e3\u6790\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%2$s\u3002", (String)"ExtCompareTypeParserFactory_3", (String)"bos-wf-engine", (Object[])new Object[0]), compareType, WfUtils.getExceptionStacktrace(e))});
            }
        }
        return result;
    }

    public void registExtCompareTypeParser(WfCompareTypeDto dto) {
        String className = dto.getClassName();
        this.logger.debug(dto.getId() + ":[registExtCompareTypeParser]\u6ce8\u518c\u6bd4\u8f83\u7b26\u89e3\u6790\u7c7b\uff1a" + className);
        if (WfUtils.isNotEmpty(className)) {
            this.extOperationParsers.computeIfAbsent(dto.getId(), k -> TypesContainer.getOrRegister((String)className));
        }
    }

    public boolean getNullResult(String compareType) {
        boolean result = false;
        if ("NOTC".equals(compareType) || "NBWF".equals(compareType)) {
            result = true;
        }
        return result;
    }
}

