/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.el.comparetype;

import de.odysseus.el.misc.TypeConverter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.el.comparetype.CompareTypeParser;
import kd.bos.workflow.engine.impl.persistence.entity.management.RoleEntityManager;

public class WfRoleCompareTypeParserImpl
implements CompareTypeParser {
    private static Log logger = LogFactory.getLog(WfRoleCompareTypeParserImpl.class);
    private static final String RIGHT = "\uff0cright\uff1a";

    @Override
    public boolean parser(Object left, Object right, TypeConverter converter) {
        logger.debug("\u5c5e\u4e8e\u5de5\u4f5c\u6d41\u89d2\u8272\u6bd4\u8f83\u7b26\u89e3\u6790\u5f00\u59cb\uff1a\u53c2\u6570left\uff1a" + left + RIGHT + right);
        boolean result = false;
        RoleEntityManager roleEntityManager = Context.getCommandContext().getRoleEntityManager();
        if (left instanceof Long) {
            logger.debug("\u5c5e\u4e8e\u5de5\u4f5c\u6d41\u89d2\u8272\u6bd4\u8f83\u7b26\u89e3\u6790\u5f00\u59cb\uff1a\u53c2\u6570left[Long]\uff1a" + left + RIGHT + right);
            result = roleEntityManager.isUserBelongToRole(Long.valueOf(String.valueOf(left)), Long.valueOf(String.valueOf(right)));
        } else if (left instanceof String) {
            logger.debug("\u5c5e\u4e8e\u5de5\u4f5c\u6d41\u89d2\u8272\u6bd4\u8f83\u7b26\u89e3\u6790\u5f00\u59cb\uff1a\u53c2\u6570left[String]\uff1a" + left + RIGHT + right);
            String users = String.valueOf(left);
            if (users.contains(",")) {
                String[] allUser = users.split(",");
                List<Long> collect = Arrays.stream(allUser).mapToLong(WfUtils::getLongValueFromObj).boxed().collect(Collectors.toList());
                result = roleEntityManager.isUsersBelongToRole(collect, WfUtils.getLongValueFromObj(right));
            } else {
                if (WfUtils.isEmpty(users)) {
                    return false;
                }
                result = roleEntityManager.isUserBelongToRole(Long.valueOf(users), Long.valueOf(String.valueOf(right)));
            }
        } else if (left instanceof List) {
            List r = (List)left;
            logger.debug("\u5c5e\u4e8e\u5de5\u4f5c\u6d41\u89d2\u8272\u6bd4\u8f83\u7b26\u89e3\u6790\u5f00\u59cb\uff1a\u53c2\u6570left[List]\uff1a" + WfUtils.listToString(r, ",") + RIGHT + right);
            List<Long> collect = r.stream().mapToLong(WfUtils::getLongValueFromObj).boxed().collect(Collectors.toList());
            result = roleEntityManager.isUsersBelongToRole(collect, WfUtils.getLongValueFromObj(right));
        }
        return result;
    }
}

