/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.el.functions;

import de.odysseus.el.function.ArgsDescription;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;

public class FunctionParser {
    public static String getEnumText(List<ArgsDescription> argsDescriptions, Object enumValue) {
        if (argsDescriptions == null || argsDescriptions.size() != 1 || enumValue == null) {
            return "";
        }
        List combos = (List)argsDescriptions.get(0).getSpecialVal();
        if (enumValue instanceof List) {
            List tmp = (List)enumValue;
            if (tmp.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            if (tmp.get(0) instanceof String) {
                for (Object i : tmp) {
                    sb.append(',').append(FunctionParser.getEnumText(argsDescriptions, String.valueOf(i)));
                }
                String returnVal = sb.toString();
                if (returnVal.startsWith(",")) {
                    returnVal = returnVal.substring(1);
                }
                return FunctionParser.removeRepetition(returnVal);
            }
            throw new RuntimeException("Why, I can not understand, type is " + tmp.get(0).getClass().getName());
        }
        if (enumValue instanceof String) {
            String enumValueStr = (String)enumValue;
            if (enumValueStr.startsWith(",")) {
                enumValueStr = enumValueStr.substring(1);
            }
            StringBuilder result = new StringBuilder();
            if (enumValueStr.contains(",")) {
                String[] evs;
                for (String i : evs = enumValueStr.split("\\,")) {
                    result.append(',').append(FunctionParser.getShowText(combos, i));
                }
            } else {
                result.append(FunctionParser.getShowText(combos, enumValueStr));
            }
            String returnVal = result.toString();
            if (returnVal.startsWith(",")) {
                returnVal = returnVal.substring(1);
            }
            return FunctionParser.removeRepetition(returnVal);
        }
        throw new RuntimeException("Why, I can not understand, type is " + enumValue.getClass().getName());
    }

    private static String getShowText(List<ValueMapItem> combos, String v) {
        for (ValueMapItem i : combos) {
            if (!v.equals(i.getValue())) continue;
            return i.getName().getLocaleValue();
        }
        return v;
    }

    private static String removeRepetition(String value) {
        if (value.contains(",")) {
            LinkedHashSet<String> tmp = new LinkedHashSet<String>();
            StringBuilder sb = new StringBuilder();
            for (String item : value.split("\\,")) {
                if (!WfUtils.isNotEmpty(item) || tmp.contains(item)) continue;
                tmp.add(item);
                sb.append(item).append(',');
            }
            if (sb.length() > 0) {
                return sb.substring(0, sb.length() - 1);
            }
            return sb.toString();
        }
        return value;
    }

    public static Object formatAmountDate(List<ArgsDescription> argsDescriptions, Object realValue) {
        if (argsDescriptions == null || argsDescriptions.size() != 1 || realValue == null) {
            return realValue;
        }
        Object fmtVal = null;
        ArgsDescription argsDescription = argsDescriptions.get(0);
        DynamicObject obj = argsDescription.getDynamicObj();
        if (obj == null) {
            return realValue;
        }
        String prop = argsDescription.getProperty();
        IDataEntityProperty property = (IDataEntityProperty)obj.getDataEntityType().getProperties().get((Object)prop);
        if (realValue instanceof List) {
            List tmp = (List)realValue;
            if (tmp.isEmpty()) {
                return null;
            }
            ArrayList<Object> amountDateObj = new ArrayList<Object>(tmp.size());
            List entryList = (List)argsDescription.getExtraAttributes();
            int len = tmp.size();
            for (int i = 0; i < len; ++i) {
                DynamicObject entryDynamicObject = null;
                if (WfUtils.isNotEmptyForCollection(entryList)) {
                    entryDynamicObject = (DynamicObject)entryList.get(i);
                }
                argsDescription.setDynamicObj(entryDynamicObject);
                argsDescriptions.set(0, argsDescription);
                amountDateObj.add(FunctionParser.formatAmountDate(argsDescriptions, tmp.get(i)));
            }
            fmtVal = amountDateObj;
        } else {
            fmtVal = property instanceof DateTimeProp ? ExpressionCalculatorUtil.formatSubDate(realValue) : (property instanceof DecimalProp ? ExpressionCalculatorUtil.numberOrCurrencyFormatIncludeEntryType(obj, prop, realValue, true) : realValue);
        }
        return fmtVal;
    }

    public static Object formatStandardAmountDate(List<ArgsDescription> argsDescriptions, Object realValue) {
        if (argsDescriptions == null || argsDescriptions.size() != 1 || realValue == null) {
            return realValue;
        }
        Object fmtVal = null;
        ArgsDescription argsDescription = argsDescriptions.get(0);
        DynamicObject obj = argsDescriptions.get(0).getDynamicObj();
        if (obj == null) {
            return realValue;
        }
        String prop = argsDescriptions.get(0).getProperty();
        IDataEntityProperty property = (IDataEntityProperty)obj.getDataEntityType().getProperties().get((Object)prop);
        if (realValue instanceof List) {
            List tmp = (List)realValue;
            if (tmp.isEmpty()) {
                return null;
            }
            ArrayList<Object> amountDateObj = new ArrayList<Object>(tmp.size());
            List entryList = (List)argsDescription.getExtraAttributes();
            int len = tmp.size();
            for (int i = 0; i < len; ++i) {
                DynamicObject entryDynamicObject = null;
                if (WfUtils.isNotEmptyForCollection(entryList)) {
                    entryDynamicObject = (DynamicObject)entryList.get(i);
                }
                argsDescription.setDynamicObj(entryDynamicObject);
                argsDescriptions.set(0, argsDescription);
                amountDateObj.add(FunctionParser.formatStandardAmountDate(argsDescriptions, tmp.get(i)));
            }
            fmtVal = amountDateObj;
        } else {
            fmtVal = property instanceof DateTimeProp ? ExpressionCalculatorUtil.formatSubDate(realValue) : (property instanceof DecimalProp ? ExpressionCalculatorUtil.numberOrCurrencyFormatIncludeEntryType(obj, prop, realValue, false) : realValue);
        }
        return fmtVal;
    }
}

