/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.el.functions.collection;

import de.odysseus.el.function.ArgsDescription;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.KDNumber;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;

public class CollectionFunctionParser {
    private static Log log = LogFactory.getLog(CollectionFunctionParser.class);

    public static Object getSumFuncParseVal(List<ArgsDescription> argsDescriptions, List<?> entryValues) {
        log.debug("Start parsing function, function number: Sum");
        return CollectionFunctionParser.isValidValue(argsDescriptions, entryValues, true) && WfUtils.isNotEmptyForCollection(entryValues) ? (Number)KDNumber.sum((Object[])entryValues.toArray()) : (Number)null;
    }

    public static Object getAvgFuncParseVal(List<ArgsDescription> argsDescriptions, List<?> entryValues) {
        log.debug("Start parsing function, function number: Avg");
        return CollectionFunctionParser.isValidValue(argsDescriptions, entryValues, true) && WfUtils.isNotEmptyForCollection(entryValues) ? (Number)KDNumber.avg((Object[])entryValues.toArray()) : (Number)null;
    }

    public static Object getMaxFuncParseVal(List<ArgsDescription> argsDescriptions, List<?> entryValues) {
        log.debug("Start parsing function, function number: Max");
        return CollectionFunctionParser.isValidValue(argsDescriptions, entryValues, true) && WfUtils.isNotEmptyForCollection(entryValues) ? (Number)KDNumber.max((Object[])entryValues.toArray()) : (Number)null;
    }

    public static Object getMinFuncParseVal(List<ArgsDescription> argsDescriptions, List<?> entryValues) {
        log.debug("Start parsing function, function number: Min");
        return CollectionFunctionParser.isValidValue(argsDescriptions, entryValues, true) && WfUtils.isNotEmptyForCollection(entryValues) ? (Number)KDNumber.min((Object[])entryValues.toArray()) : (Number)null;
    }

    public static Object getFirstFuncParseVal(List<ArgsDescription> argsDescriptions, List<?> entryValues) {
        log.debug("Start parsing function, function number: First");
        if (CollectionFunctionParser.isValidValue(argsDescriptions, entryValues, false)) {
            String prop;
            DynamicObject obj = argsDescriptions.get(0).getDynamicObj();
            Object value = obj.get(prop = argsDescriptions.get(0).getProperty());
            if (WfUtils.isEmptyString(value)) {
                return null;
            }
            if (value instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                return sdf.format(value);
            }
            if (value instanceof ILocaleString) {
                String lang = RequestContext.get().getLang().toString();
                return ((ILocaleString)value).get((Object)lang);
            }
            IDataEntityProperty property = (IDataEntityProperty)obj.getDataEntityType().getProperties().get((Object)prop);
            if (property instanceof MulBasedataProp) {
                DynamicObjectCollection mulCollection = obj.getDynamicObjectCollection(prop);
                return mulCollection.size() > 0 && WfUtils.isNotEmptyForCollection(entryValues) ? entryValues.stream().limit(mulCollection.size()).collect(Collectors.toList()) : null;
            }
            return entryValues.get(0);
        }
        return null;
    }

    public static Object getCountFuncParseVal(List<ArgsDescription> argsDescriptions, List<?> entryValues) {
        log.debug("Start parsing function, function number: Count");
        if (CollectionFunctionParser.isValidValue(argsDescriptions, entryValues, false)) {
            DynamicObject obj = argsDescriptions.get(0).getDynamicObj();
            DynamicObjectCollection entry = ((DynamicObject)obj.getParent()).getDynamicObjectCollection(obj.getDynamicObjectType().getName());
            return entry.size();
        }
        return null;
    }

    private static boolean isValidValue(List<ArgsDescription> argsDescriptions, List<?> entryValues, boolean isNumericType) {
        DynamicObjectCollection entry;
        if (argsDescriptions == null || argsDescriptions.size() != 1) {
            log.debug(String.format("Entry Parameter error.DescList:[%s];EntryValuesList[%s]", argsDescriptions, entryValues));
            return false;
        }
        ArgsDescription argsDescription = argsDescriptions.get(0);
        DynamicObject obj = argsDescription.getDynamicObj();
        if (obj == null) {
            log.debug("Current dynamicObject is null!");
            return false;
        }
        if (obj.getParent() instanceof DynamicObject && obj.getDynamicObjectType() != null && ((entry = ((DynamicObject)obj.getParent()).getDynamicObjectCollection(obj.getDynamicObjectType().getName())) == null || entry.size() <= 0)) {
            log.debug("Current entry dynamicObjectCollection is null or size = 0!");
            return false;
        }
        String prop = argsDescription.getProperty();
        IDataEntityProperty property = (IDataEntityProperty)obj.getDataEntityType().getProperties().get((Object)prop);
        if (property == null) {
            log.debug("Current IDataEntityProperty is null!");
            return false;
        }
        if (isNumericType && !(property instanceof DecimalProp)) {
            log.debug("Current property data type is not suitable for numeric!");
            return false;
        }
        return true;
    }
}

