/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.event;

import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.EventSubProcess;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.SubProcess;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.event.EventHandler;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.WFEngineException;

public abstract class AbstractEventHandler
implements EventHandler {
    protected Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        ExecutionEntity execution = eventSubscription.getExecution();
        FlowNode currentFlowElement = (FlowNode)execution.getCurrentFlowElement();
        if (currentFlowElement == null) {
            throw new WFEngineException("Error while sending signal for event subscription '" + eventSubscription.getId() + "': no activity associated with event subscription");
        }
        if (payload instanceof Map) {
            Map processVariables = (Map)payload;
            execution.setVariables(processVariables);
        }
        if (currentFlowElement instanceof BoundaryEvent || currentFlowElement instanceof EventSubProcess) {
            try {
                this.dispatchActivitiesCanceledIfNeeded(eventSubscription, execution, currentFlowElement, commandContext);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WFEngineException("exception while sending signal for event subscription '" + eventSubscription + "':" + e.getMessage(), e);
            }
        }
        Context.getAgenda().planTriggerExecutionOperation(execution);
    }

    protected void dispatchActivitiesCanceledIfNeeded(EventSubscriptionEntity eventSubscription, ExecutionEntity execution, FlowElement currentFlowElement, CommandContext commandContext) {
        BoundaryEvent boundaryEvent;
        if (currentFlowElement instanceof BoundaryEvent && (boundaryEvent = (BoundaryEvent)currentFlowElement).isCancelActivity()) {
            this.dispatchExecutionCancelled(eventSubscription, execution, commandContext);
        }
    }

    protected void dispatchExecutionCancelled(EventSubscriptionEntity eventSubscription, ExecutionEntity execution, CommandContext commandContext) {
        BoundaryEvent boundaryEvent;
        FlowElement flowElement;
        for (ExecutionEntity executionEntity : execution.getExecutions()) {
            this.dispatchExecutionCancelled(eventSubscription, executionEntity, commandContext);
        }
        ExecutionEntity subProcessInstance = commandContext.getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(execution.getId());
        if (subProcessInstance != null) {
            this.dispatchExecutionCancelled(eventSubscription, subProcessInstance, commandContext);
        }
        if ((flowElement = execution.getCurrentFlowElement()) instanceof BoundaryEvent && (boundaryEvent = (BoundaryEvent)flowElement).getAttachedToRef() != null) {
            this.dispatchActivityCancelled(eventSubscription, execution, boundaryEvent.getAttachedToRef(), commandContext);
        }
    }

    protected void dispatchActivityCancelled(EventSubscriptionEntity eventSubscription, ExecutionEntity boundaryEventExecution, FlowNode flowNode, CommandContext commandContext) {
        ExecutionEntity parentExecutionEntity;
        commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityCancelledEvent(flowNode.getId(), flowNode.getName(), boundaryEventExecution.getId(), boundaryEventExecution.getProcessInstanceId(), boundaryEventExecution.getProcessDefinitionId(), this.parseActivityType(flowNode), eventSubscription));
        if (flowNode instanceof SubProcess && (parentExecutionEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(boundaryEventExecution.getParentId())) != null) {
            this.dispatchActivityCancelledForChildExecution(eventSubscription, parentExecutionEntity, boundaryEventExecution, commandContext);
        }
    }

    protected void dispatchActivityCancelledForChildExecution(EventSubscriptionEntity eventSubscription, ExecutionEntity parentExecutionEntity, ExecutionEntity boundaryEventExecution, CommandContext commandContext) {
        List<ExecutionEntity> executionEntities = commandContext.getExecutionEntityManager().findChildExecutionsByParentExecutionId(parentExecutionEntity.getId());
        for (ExecutionEntity childExecution : executionEntities) {
            if (boundaryEventExecution.getId().equals(childExecution.getId()) || childExecution.getCurrentFlowElement() == null || !(childExecution.getCurrentFlowElement() instanceof FlowNode)) continue;
            FlowNode flowNode = (FlowNode)childExecution.getCurrentFlowElement();
            commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityCancelledEvent(flowNode.getId(), flowNode.getName(), childExecution.getId(), childExecution.getProcessInstanceId(), childExecution.getProcessDefinitionId(), this.parseActivityType(flowNode), eventSubscription));
            if (!childExecution.isScope()) continue;
            this.dispatchActivityCancelledForChildExecution(eventSubscription, childExecution, boundaryEventExecution, commandContext);
        }
    }

    protected String parseActivityType(FlowNode flowNode) {
        String elementType = flowNode.getClass().getSimpleName();
        elementType = elementType.substring(0, 1).toLowerCase() + elementType.substring(1);
        return elementType;
    }
}

