/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.event;

import java.util.HashMap;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.SubProcess;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.bpmn.helper.ScopeUtil;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.event.EventHandler;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.CompensateEventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFEngineException;

public class CompensationEventHandler
implements EventHandler {
    protected static Log logger = LogFactory.getLog(CompensationEventHandler.class);

    @Override
    public String getEventHandlerType() {
        return "compensate";
    }

    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        String configuration = eventSubscription.getConfiguration();
        if (configuration == null) {
            throw new WFEngineException("Compensating execution not set for compensate event subscription with id " + eventSubscription.getId());
        }
        logger.debug("configuration : " + configuration);
        ExecutionEntity compensatingExecution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(Long.valueOf(configuration));
        Long processDefinitionId = compensatingExecution.getProcessDefinitionId();
        logger.debug("VAR_BATCHCOMPENSATEBUSINESSKEY:" + compensatingExecution.getVariableLocal("batchCompensateBusinesskey"));
        Process process = ProcessDefinitionUtil.getProcess(processDefinitionId, null);
        if (process == null) {
            throw new WFEngineException("Cannot start process instance. Process model (id = " + processDefinitionId + ") could not be found");
        }
        FlowElement flowElement = process.getFlowElement(eventSubscription.getActivityId(), true);
        this.recordActivity(compensatingExecution, (FlowNode)flowElement, process, commandContext);
        if (flowElement instanceof SubProcess && !((SubProcess)flowElement).isForCompensation()) {
            compensatingExecution.setScope(true);
            List<CompensateEventSubscriptionEntity> eventsForThisScope = commandContext.getEventSubscriptionEntityManager().findCompensateEventSubscriptionsByExecutionId(compensatingExecution.getId());
            ScopeUtil.throwCompensationEvent(eventsForThisScope, compensatingExecution, false, new HashMap<String, Object>());
        } else {
            try {
                if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                    commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityEvent(ActivitiEventType.ACTIVITY_COMPENSATE, flowElement.getId(), flowElement.getName(), compensatingExecution.getId(), compensatingExecution.getProcessInstanceId(), compensatingExecution.getProcessDefinitionId(), compensatingExecution.getBusinessKey(), flowElement));
                }
                compensatingExecution.setCurrentFlowElement(flowElement);
                Context.getAgenda().planContinueProcessInCompensation(compensatingExecution);
            }
            catch (Exception e) {
                throw new WFEngineException("Error while handling compensation event " + eventSubscription, e);
            }
        }
    }

    private void recordActivity(ExecutionEntity compensatingExecution, FlowNode flowNode, Process process, CommandContext commandContext) {
        SequenceFlow inFlow = flowNode.getIncomingFlows().get(0);
        BoundaryEvent compensateEventNode = (BoundaryEvent)inFlow.getSourceFlowElement();
        HistoricActivityInstanceEntity boundaryActInst = this.recordActivity(compensatingExecution, compensateEventNode, commandContext);
        Activity attachedNode = compensateEventNode.getAttachedToRef();
        QFilter procInstFilter = new QFilter("processInstanceId", "=", (Object)compensatingExecution.getProcessInstanceId());
        QFilter pkFiler = new QFilter("businessKey", "=", (Object)compensatingExecution.getParent().getBusinessKey());
        QFilter actIdFiler = new QFilter("activityId", "=", (Object)attachedNode.getId());
        List attachedEntitys = commandContext.getHistoricActivityInstanceEntityManager().findByQueryFilters(new QFilter[]{procInstFilter, pkFiler, actIdFiler});
        if (attachedEntitys != null && !attachedEntitys.isEmpty()) {
            boundaryActInst.setSourceElementId(((HistoricActivityInstanceEntity)attachedEntitys.get(0)).getId());
        }
        HistoricActivityInstanceEntity inFlowActInst = this.recordActivity(compensatingExecution, inFlow, commandContext);
        inFlowActInst.setSourceElementId(boundaryActInst.getId());
        boundaryActInst.setTargetElementId(inFlowActInst.getId());
        compensatingExecution.setCurrentActInstId(inFlowActInst.getId());
    }

    public HistoricActivityInstanceEntity recordActivity(ExecutionEntity execution, FlowElement ele, CommandContext commandContext) {
        HistoricActivityInstanceEntity historicActivityInstance = (HistoricActivityInstanceEntity)commandContext.getHistoricActivityInstanceEntityManager().create();
        historicActivityInstance.setProcessDefinitionId(execution.getProcessDefinitionId());
        historicActivityInstance.setProcessInstanceId(execution.getProcessInstanceId());
        historicActivityInstance.setExecutionId(execution.getId());
        historicActivityInstance.setActivityId(ele.getId());
        historicActivityInstance.setBusinessKey(execution.getBusinessKey());
        String multiKey = BpmnModelUtil.getActivityNameMultiKey(ele.getId());
        historicActivityInstance.setActivityName(BpmnModelUtil.getMultiLangFieldValue(execution.getProcessDefinitionId(), multiKey, ele.getName()));
        historicActivityInstance.setActivityType(ele.getType());
        Object bizTraceNo = execution.getVariable("biztraceno");
        if (bizTraceNo != null) {
            historicActivityInstance.setBizTraceNo(String.valueOf(bizTraceNo));
        }
        ProcessEngineConfigurationImpl processEngineConfigurationImpl = Context.getProcessEngineConfiguration();
        historicActivityInstance.setEndTime(processEngineConfigurationImpl.getClock().getCurrentTime());
        historicActivityInstance.setDurationInMillis(0L);
        commandContext.getHistoricActivityInstanceEntityManager().insert(historicActivityInstance);
        return historicActivityInstance;
    }
}

