/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.event;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.WfTracerHelper;
import kd.bos.workflow.engine.impl.event.AbstractEventHandler;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.ProcessInstanceHelper;
import kd.bos.workflow.engine.repository.ProcessDefinition;
import kd.bos.workflow.exception.WFEngineException;

public class SignalEventHandler
extends AbstractEventHandler {
    public static final String EVENT_HANDLER_TYPE = "signal";

    @Override
    public String getEventHandlerType() {
        return EVENT_HANDLER_TYPE;
    }

    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        block19: {
            Map variables = null;
            String busKey = null;
            if (payload instanceof Map) {
                variables = (Map)payload;
                busKey = (String)WfUtils.pop(variables, "_businessKey_");
            }
            try (TraceSpan tracer = Tracer.create((String)"WF_START", (String)WfTracerHelper.wrapTagValue("startEventReceivedHandler", busKey, String.valueOf(eventSubscription.getProcessDefinitionId())));){
                if (!WfUtils.isEmpty(eventSubscription.getExecutionId())) {
                    super.handleEvent(eventSubscription, payload, commandContext);
                    break block19;
                }
                if (WfUtils.isNotEmpty(eventSubscription.getProcessDefinitionId()) && variables != null) {
                    this.logger.debug("execution is null, start process by processdefinition [" + eventSubscription.getProcessDefinitionId() + "]");
                    Long processDefinitionId = eventSubscription.getProcessDefinitionId();
                    Long schemId = (Long)variables.get("SCHEMEID");
                    BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId, schemId, null);
                    Process process = bpmnModel.getMainProcess();
                    ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition(processDefinitionId);
                    FlowElement flowElement = process.getFlowElement(eventSubscription.getActivityId(), true);
                    if (flowElement == null) {
                        throw new WFEngineException("Could not find matching FlowElement for activityId " + eventSubscription.getActivityId());
                    }
                    if (!(flowElement instanceof StartEvent)) {
                        Set<String> prevNodeIds = bpmnModel.getPreviousNodeIds(flowElement.getId());
                        variables.put("bootNodeId", flowElement.getId());
                        variables.put("bootNodePrevNodeIds", prevNodeIds.toString());
                        List<StartEvent> events = process.findFlowElementsOfType(StartEvent.class);
                        if (!events.isEmpty()) {
                            flowElement = events.get(0);
                        } else {
                            this.logger.error("no startEvents! " + processDefinitionId);
                        }
                    }
                    ProcessInstanceHelper processInstanceHelper = commandContext.getProcessEngineConfiguration().getProcessInstanceHelper();
                    processInstanceHelper.createAndStartProcessInstanceWithInitialFlowElement(processDefinition, busKey, null, flowElement, process, variables, null, true);
                    break block19;
                }
                throw new WFEngineException("Invalid signal handling: no execution nor process definition set");
            }
        }
    }
}

