/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.event;

import com.google.common.collect.Sets;
import java.util.Set;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.impl.event.AbstractEventHandler;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class WaitActionsEventHandler
extends AbstractEventHandler {
    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        this.logger.debug(String.format("WaitActionsEventHandler handleEvent... %s %s", eventSubscription.getId(), payload));
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(eventSubscription.getExecutionId());
        ExecutionEntity billExecution = execution.getParent();
        String executionActId = execution.getActivityId();
        String billExecutionActId = billExecution.getActivityId();
        execution.setTransientVariable("satisfiesWaitActionsCondition", true);
        this.logger.debug(String.format("WaitActionsEventHandler handleEvent... executionActId: %s billExecutionActId: %s", executionActId, billExecutionActId));
        if (executionActId.equals(billExecutionActId)) {
            commandContext.getAgenda().planTriggerExecutionOperation(execution);
        } else {
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId(), execution.getSchemeId(), execution.getProcessInstanceId());
            FlowElement childExecutionElement = bpmnModel.getFlowElement(execution.getActivityId());
            FlowElement billExecutionElement = bpmnModel.getFlowElement(billExecution.getActivityId());
            Set<String> childExecutionEntities = BpmnModelUtil.getTargetEntityNumber(childExecutionElement);
            Set<String> billExecutionEntities = BpmnModelUtil.getTargetEntityNumber(billExecutionElement);
            this.logger.debug(String.format("WaitActionsEventHandler handleEvent... childExecEntities: %s billExecEntities: %s", childExecutionEntities, billExecutionEntities));
            if (Sets.difference(childExecutionEntities, billExecutionEntities).isEmpty()) {
                if (eventSubscription.getActivityId().equals(executionActId)) {
                    this.logger.debug(String.format("trigger. executionActId: %s, billExecActId: %s, executionId: %s, businessKey: %s, event: %s", executionActId, billExecutionActId, execution.getId(), execution.getBusinessKey(), eventSubscription.getEventName()));
                    commandContext.getAgenda().planTriggerExecutionOperation(execution);
                } else {
                    this.logger.debug(String.format("Entity consistency, discard.  evtSubScrId: %s", eventSubscription.getId()));
                }
            } else {
                HistoricActivityInstanceEntityManager actInstManager = commandContext.getHistoricActivityInstanceEntityManager();
                HistoricActivityInstanceEntity actInst = (HistoricActivityInstanceEntity)actInstManager.findById(execution.getCurrentActInstId());
                String sequenceFlowId = actInst.getActivityId();
                if (!"SequenceFlow".equals(actInst.getActivityType())) {
                    HistoricActivityInstanceEntity sequenceActInst = (HistoricActivityInstanceEntity)actInstManager.findById(actInst.getSourceElementId(), "activityId");
                    sequenceFlowId = sequenceActInst.getActivityId();
                }
                commandContext.getAgenda().planExecutionConvertOperation(execution, sequenceFlowId);
            }
        }
    }

    @Override
    public String getEventHandlerType() {
        return "waitactions";
    }
}

