/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.event;

import java.util.Map;
import kd.bos.workflow.bpmn.model.WaitTask;
import kd.bos.workflow.engine.event.util.WaitEventUtil;
import kd.bos.workflow.engine.impl.event.AbstractEventHandler;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.TaskHelper;

public class WaitEventHandler
extends AbstractEventHandler {
    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        this.logger.debug(String.format("WaitEventHandler handleEvent... %s %s", eventSubscription.getId(), payload));
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(eventSubscription.getExecutionId());
        if (!eventSubscription.getActivityId().equals(execution.getCurrentActivityId())) {
            this.logger.debug(String.format("\u5f53\u524d\u8282\u70b9\u4e3a %s\uff0c\u4e0e EventSubscriptionEntity\u4e2d\u8282\u70b9 %s \u4e0d\u4e00\u81f4\uff0c\u53ef\u80fd\u88ab\u8df3\u8f6c\uff0c\u4e0d\u505a\u4efb\u4f55\u5904\u7406\uff01", execution.getCurrentActivityId(), eventSubscription.getActivityId()));
            return;
        }
        WaitTask waitTask = (WaitTask)execution.getCurrentFlowElement();
        Object params = null;
        Map data = null;
        String variableKey = WaitEventUtil.getEventParamsVariableKey(waitTask);
        if (payload instanceof Map && (data = (Map)payload) != null) {
            Object v = data.remove("params");
            params = v;
            if (v != null) {
                execution.getProcessInstance().setTransientVariable(variableKey, params);
            }
        }
        String evtNumber = (String)execution.getVariable("eventNumber");
        if (!waitTask.getTimingModel().getEvent().equalsIgnoreCase(evtNumber) && !WaitEventUtil.hasTrueEventCondition(waitTask, execution, data)) {
            this.logger.debug(String.format("\u6761\u4ef6\u4e0d\u6ee1\u8db3\uff01 Execution: %s  WaitTask: %s", execution.getId(), waitTask.getId()));
            return;
        }
        TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
        taskHelper.planExecutionOperationAsync(commandContext, execution);
        this.logger.debug("WaitEventHandler delete handled EventSubscription...");
        commandContext.getEventSubscriptionEntityManager().delete(eventSubscription.getId());
    }

    @Override
    public String getEventHandlerType() {
        return "waitevent";
    }
}

