/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.event.logger;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.impl.event.logger.AbstractEventFlusher;
import kd.bos.workflow.engine.impl.event.logger.handler.EventLoggerEventHandler;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventLogEntryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventLogEntryEntityManager;

public class DatabaseEventFlusher
extends AbstractEventFlusher {
    protected static Log logger = LogFactory.getLog(DatabaseEventFlusher.class);

    @Override
    public void closing(CommandContext commandContext) {
        if (commandContext.getException() != null) {
            return;
        }
        EventLogEntryEntityManager eventLogEntryEntityManager = commandContext.getEventLogEntryEntityManager();
        for (EventLoggerEventHandler eventHandler : this.eventHandlers) {
            try {
                EventLogEntryEntity entity = eventHandler.generateEventLogEntry(commandContext);
                if (entity == null) continue;
                eventLogEntryEntityManager.insert(entity, false);
            }
            catch (Exception e) {
                logger.warn("Could not create event log", (Throwable)e);
            }
        }
    }

    @Override
    public void afterSessionsFlush(CommandContext commandContext) {
        logger.debug("\u3010sonar\u5ba1\u8ba1\u3011\u4e0d\u80fd\u4e3a\u7a7a\u65b9\u6cd5");
    }

    @Override
    public void closeFailure(CommandContext commandContext) {
        logger.debug("\u3010sonar\u5ba1\u8ba1\u3011\u4e0d\u80fd\u4e3a\u7a7a\u65b9\u6cd5");
    }
}

