/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.event.logger;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.delegate.event.ActivitiEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEventListener;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.event.logger.DatabaseEventFlusher;
import kd.bos.workflow.engine.impl.event.logger.EventFlusher;
import kd.bos.workflow.engine.impl.event.logger.EventLoggerListener;
import kd.bos.workflow.engine.impl.event.logger.handler.ActivityCompensatedEventHandler;
import kd.bos.workflow.engine.impl.event.logger.handler.ActivityCompletedEventHandler;
import kd.bos.workflow.engine.impl.event.logger.handler.ActivityErrorReceivedEventHandler;
import kd.bos.workflow.engine.impl.event.logger.handler.ActivityMessageEventHandler;
import kd.bos.workflow.engine.impl.event.logger.handler.ActivitySignaledEventHandler;
import kd.bos.workflow.engine.impl.event.logger.handler.ActivityStartedEventHandler;
import kd.bos.workflow.engine.impl.event.logger.handler.AsyncMessageEventHandler;
import kd.bos.workflow.engine.impl.event.logger.handler.BusinessExecuteEventHandler;
import kd.bos.workflow.engine.impl.event.logger.handler.EventLoggerEventHandler;
import kd.bos.workflow.engine.impl.event.logger.handler.ProcessInstanceEndedEventHandler;
import kd.bos.workflow.engine.impl.event.logger.handler.ProcessInstanceStartedEventHandler;
import kd.bos.workflow.engine.impl.event.logger.handler.TaskCompletedEventHandler;
import kd.bos.workflow.engine.impl.event.logger.handler.TaskCreatedEventHandler;
import kd.bos.workflow.engine.impl.event.logger.handler.TaskTransferEventHandler;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandContextCloseListener;
import kd.bos.workflow.engine.runtime.Clock;

public class EventLogger
implements ActivitiEventListener {
    protected static Log logger = LogFactory.getLog(EventLogger.class);
    private static final String EVENT_FLUSHER_KEY = "eventFlusher";
    protected Clock clock;
    protected ObjectMapper objectMapper;
    protected Map<ActivitiEventType, Class<? extends EventLoggerEventHandler>> eventHandlers = new HashMap<ActivitiEventType, Class<? extends EventLoggerEventHandler>>();
    protected List<EventLoggerListener> listeners;

    public EventLogger() {
        this.initializeDefaultHandlers();
    }

    public EventLogger(Clock clock, ObjectMapper objectMapper) {
        this();
        this.clock = clock;
        this.objectMapper = objectMapper;
    }

    private void initializeDefaultHandlers() {
        this.addEventHandler(ActivitiEventType.TASK_CREATED, TaskCreatedEventHandler.class);
        this.addEventHandler(ActivitiEventType.TASK_COMPLETED, TaskCompletedEventHandler.class);
        this.addEventHandler(ActivitiEventType.TASK_TRANSFER, TaskTransferEventHandler.class);
        this.addEventHandler(ActivitiEventType.ACTIVITY_STARTED, ActivityStartedEventHandler.class);
        this.addEventHandler(ActivitiEventType.ACTIVITY_COMPLETED, ActivityCompletedEventHandler.class);
        this.addEventHandler(ActivitiEventType.ACTIVITY_SIGNALED, ActivitySignaledEventHandler.class);
        this.addEventHandler(ActivitiEventType.ACTIVITY_MESSAGE_RECEIVED, ActivityMessageEventHandler.class);
        this.addEventHandler(ActivitiEventType.ACTIVITY_COMPENSATE, ActivityCompensatedEventHandler.class);
        this.addEventHandler(ActivitiEventType.ACTIVITY_ERROR_RECEIVED, ActivityErrorReceivedEventHandler.class);
        this.addEventHandler(ActivitiEventType.PROCESS_STARTED, ProcessInstanceStartedEventHandler.class);
        this.addEventHandler(ActivitiEventType.PROCESS_COMPLETED, ProcessInstanceEndedEventHandler.class);
        this.addEventHandler(ActivitiEventType.PROCESS_COMPLETED_WITH_ERROR_END_EVENT, ProcessInstanceEndedEventHandler.class);
        this.addEventHandler(ActivitiEventType.PROCESS_CANCELLED, ProcessInstanceEndedEventHandler.class);
        this.addEventHandler(ActivitiEventType.BUSINESS_EXECUTE_SUCCESS, BusinessExecuteEventHandler.class);
        this.addEventHandler(ActivitiEventType.BUSINESS_EXECUTE_FAIL, BusinessExecuteEventHandler.class);
        this.addEventHandler(ActivitiEventType.JOB_CREATE, AsyncMessageEventHandler.class);
        this.addEventHandler(ActivitiEventType.JOB_EXECUTION_SUCCESS, AsyncMessageEventHandler.class);
        this.addEventHandler(ActivitiEventType.JOB_EXECUTION_FAILURE, AsyncMessageEventHandler.class);
    }

    @Override
    public void onEvent(ActivitiEvent event) {
        EventLoggerEventHandler eventHandler = this.getEventHandler(event);
        if (eventHandler != null) {
            CommandContext currentCommandContext = Context.getCommandContext();
            EventFlusher eventFlusher = (EventFlusher)currentCommandContext.getAttribute(EVENT_FLUSHER_KEY);
            if (eventFlusher == null) {
                eventFlusher = this.createEventFlusher();
                if (eventFlusher == null) {
                    eventFlusher = new DatabaseEventFlusher();
                }
                currentCommandContext.addAttribute(EVENT_FLUSHER_KEY, eventFlusher);
                currentCommandContext.addCloseListener(eventFlusher);
                currentCommandContext.addCloseListener(new CommandContextCloseListener(){

                    @Override
                    public void closing(CommandContext commandContext) {
                    }

                    @Override
                    public void closed(CommandContext commandContext) {
                        if (EventLogger.this.listeners != null) {
                            for (EventLoggerListener listener : EventLogger.this.listeners) {
                                listener.eventsAdded(EventLogger.this);
                            }
                        }
                    }

                    @Override
                    public void afterSessionsFlush(CommandContext commandContext) {
                    }

                    @Override
                    public void closeFailure(CommandContext commandContext) {
                    }
                });
            }
            eventFlusher.addEventHandler(eventHandler);
        }
    }

    protected EventLoggerEventHandler getEventHandler(ActivitiEvent event) {
        Class<? extends EventLoggerEventHandler> eventHandlerClass = this.eventHandlers.get((Object)event.getType());
        if (eventHandlerClass != null) {
            return this.instantiateEventHandler(event, eventHandlerClass);
        }
        return null;
    }

    protected EventLoggerEventHandler instantiateEventHandler(ActivitiEvent event, Class<? extends EventLoggerEventHandler> eventHandlerClass) {
        try {
            EventLoggerEventHandler eventHandler = eventHandlerClass.newInstance();
            eventHandler.setTimeStamp(this.clock.getCurrentTime());
            eventHandler.setEvent(event);
            eventHandler.setObjectMapper(this.objectMapper);
            return eventHandler;
        }
        catch (Exception e) {
            logger.warn("Could not instantiate " + eventHandlerClass + ", this is most likely a programmatic error");
            return null;
        }
    }

    @Override
    public boolean isFailOnException() {
        return false;
    }

    public void addEventHandler(ActivitiEventType eventType, Class<? extends EventLoggerEventHandler> eventHandlerClass) {
        this.eventHandlers.put(eventType, eventHandlerClass);
    }

    public void addEventLoggerListener(EventLoggerListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<EventLoggerListener>(1);
        }
        this.listeners.add(listener);
    }

    protected EventFlusher createEventFlusher() {
        return null;
    }

    public Clock getClock() {
        return this.clock;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public List<EventLoggerListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<EventLoggerListener> listeners) {
        this.listeners = listeners;
    }
}

