/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.event.logger.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEntityEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEvent;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.event.logger.handler.EventLoggerEventHandler;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventLogEntryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.bos.workflow.service.WfTraceType;

public abstract class AbstractDatabaseEventLoggerEventHandler
implements EventLoggerEventHandler {
    protected static Log logger = LogFactory.getLog(AbstractDatabaseEventLoggerEventHandler.class);
    protected ActivitiEvent event;
    protected Date timeStamp;
    protected ObjectMapper objectMapper;

    protected EventLogEntryEntity createEventLogEntry(Long processDefinitionId, Long processInstanceId, Long executionId, Long taskId, String businessKey, Map<String, Object> data) {
        return this.createEventLogEntry(this.event.getType().name(), processDefinitionId, processInstanceId, executionId, taskId, businessKey, data);
    }

    protected EventLogEntryEntity createEventLogEntry(String type, Long processDefinitionId, Long processInstanceId, Long executionId, Long taskId, String businessKey, Map<String, Object> data) {
        QFilter[] filters;
        DynamicObject procDef;
        EventLogEntryEntity eventLogEntry = (EventLogEntryEntity)Context.getCommandContext().getEventLogEntryEntityManager().create();
        eventLogEntry.setProcessDefinitionId(processDefinitionId);
        eventLogEntry.setProcessInstanceId(processInstanceId);
        eventLogEntry.setExecutionId(executionId);
        eventLogEntry.setTaskId(taskId);
        eventLogEntry.setType(type);
        eventLogEntry.setTimeStamp(this.timeStamp);
        eventLogEntry.setTraceNo(RequestContext.get().getTraceId());
        if (WfTraceType.getOrCreate().getJobInfo() != null) {
            eventLogEntry.setJobId(WfTraceType.get().getJobInfo().getCurrentJobId());
            eventLogEntry.setSrcJobId(WfTraceType.get().getJobInfo().getSrcJobId());
            eventLogEntry.setJobType(WfTraceType.get().getJobInfo().getJobType());
            eventLogEntry.setBillNo(WfTraceType.get().getJobInfo().getBillNo());
        }
        if (WfUtils.isNotEmpty(processDefinitionId) && (procDef = QueryServiceHelper.queryOne((String)"wf_processdefinition", (String)"type", (QFilter[])(filters = new QFilter[]{new QFilter("id", "=", (Object)processDefinitionId)}))) != null && WfUtils.isNotEmpty(procDef.getString("type"))) {
            eventLogEntry.setProcessType(procDef.getString("type"));
        }
        if (WfUtils.isNotEmpty(businessKey)) {
            eventLogEntry.setBusinessKey(businessKey);
        } else if (WfTraceType.get().getJobInfo() != null) {
            eventLogEntry.setBusinessKey(WfTraceType.get().getJobInfo().getBusinessKey());
        } else {
            eventLogEntry.setBusinessKey(this.findBusinessKey(processInstanceId));
        }
        long userId = WfUtils.isEmpty(RequestContext.get().getUserId()) ? -1L : Long.parseLong(RequestContext.get().getUserId());
        eventLogEntry.setUserId(userId);
        String userName = WfUtils.isEmpty(RequestContext.get().getUserName()) ? "" : RequestContext.get().getUserName();
        eventLogEntry.setUserName(userName);
        try {
            eventLogEntry.setData(SerializationUtils.toJsonString(data));
        }
        catch (Exception e) {
            logger.error("Could not serialize event data. Data will not be written to the database", (Throwable)e);
        }
        return eventLogEntry;
    }

    @Override
    public void setEvent(ActivitiEvent event) {
        this.event = event;
    }

    @Override
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T> T getEntityFromEvent() {
        return (T)((ActivitiEntityEvent)this.event).getEntity();
    }

    public void putInMapIfNotNull(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    protected String findBusinessKey(Long processInstanceId) {
        ExecutionEntityImpl entity = (ExecutionEntityImpl)Context.getCommandContext().getExecutionEntityManager().findById(processInstanceId);
        if (entity != null) {
            return entity.getBusinessKey();
        }
        return null;
    }
}

