/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.event.logger.handler;

import java.util.HashMap;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiAsyncMessageEvent;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.event.logger.handler.AbstractDatabaseEventLoggerEventHandler;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventLogEntryEntity;

public class AsyncMessageEventHandler
extends AbstractDatabaseEventLoggerEventHandler {
    @Override
    public EventLogEntryEntity generateEventLogEntry(CommandContext commandContext) {
        if (this.event instanceof ActivitiAsyncMessageEvent) {
            ActivitiAsyncMessageEvent messageEvent = (ActivitiAsyncMessageEvent)this.event;
            try {
                if (Context.getProcessEngineConfiguration().getEvtJobHandlers().containsKey(messageEvent.getMessageName())) {
                    return null;
                }
            }
            catch (Exception e) {
                logger.info("generateEventLogEntry error:" + WfUtils.getExceptionStacktrace(e));
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            if (messageEvent.getCause() != null) {
                this.putInMapIfNotNull(data, "exception", WfUtils.getExceptionStacktrace(messageEvent.getCause()));
            }
            this.putInMapIfNotNull(data, "messageData", messageEvent.getMessageData());
            EventLogEntryEntity tmp = this.createEventLogEntry(messageEvent.getProcessDefinitionId(), messageEvent.getProcessInstanceId(), messageEvent.getExecutionId(), null, messageEvent.getBusinessKey(), data);
            tmp.setElementId(messageEvent.getActivityId());
            String massageStr = messageEvent.getMessageName() + "#" + messageEvent.getType().getCode();
            String primaryInfo = messageEvent.getPrimaryInfo();
            if (WfUtils.isNotEmpty(primaryInfo)) {
                massageStr = massageStr + primaryInfo;
            }
            String type = String.format(messageEvent.getType().getName(), massageStr, messageEvent.getJobId());
            tmp.setType(type);
            if (WfUtils.isEmpty(tmp.getJobId())) {
                tmp.setJobId(messageEvent.getJobId());
            }
            if (WfUtils.isEmpty(tmp.getJobType())) {
                tmp.setJobType(messageEvent.getMessageName());
            }
            if (WfUtils.isEmpty(tmp.getElementId())) {
                tmp.setElementId(messageEvent.getActivityId());
            }
            return tmp;
        }
        return null;
    }
}

