/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.event.logger.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEntityEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEntityWithVariablesEvent;
import kd.bos.workflow.engine.impl.event.logger.handler.AbstractTaskEventHandler;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventLogEntryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;

public class TaskCompletedEventHandler
extends AbstractTaskEventHandler {
    @Override
    public EventLogEntryEntity generateEventLogEntry(CommandContext commandContext) {
        ActivitiEntityWithVariablesEvent activitiEntityWithVariablesEvent;
        Long assigneeId;
        ActivitiEntityEvent activitiEntityEvent = (ActivitiEntityEvent)this.event;
        TaskEntity task = (TaskEntity)activitiEntityEvent.getEntity();
        List<IdentityLinkEntity> participants = commandContext.getIdentityLinkEntityManager().findIdentityLinksByTaskId(task.getId());
        if (participants != null && !participants.isEmpty() && WfUtils.isNotEmpty(assigneeId = task.getAssigneeId())) {
            ArrayList<Long> others = new ArrayList<Long>();
            for (IdentityLinkEntity i : participants) {
                Long uid = i.getUserId();
                if (!WfUtils.isNotEmpty(uid) || uid.equals(assigneeId)) continue;
                others.add(uid);
            }
            if (!others.isEmpty()) {
                commandContext.getRuleTaskRelationEntityManager().deleteEntitiesByTaskIdAndUid(task.getId(), others);
            }
        }
        Map<String, Object> data = this.handleCommonTaskFields(task);
        long duration = this.timeStamp.getTime() - task.getCreateDate().getTime();
        this.putInMapIfNotNull(data, "duration", duration);
        if (this.event instanceof ActivitiEntityWithVariablesEvent && (activitiEntityWithVariablesEvent = (ActivitiEntityWithVariablesEvent)this.event).getVariables() != null && !activitiEntityWithVariablesEvent.getVariables().isEmpty()) {
            HashMap<String, Object> variableMap = new HashMap<String, Object>();
            for (Object variableName : activitiEntityWithVariablesEvent.getVariables().keySet()) {
                this.putInMapIfNotNull(variableMap, (String)variableName, activitiEntityWithVariablesEvent.getVariables().get(variableName));
            }
            if (activitiEntityWithVariablesEvent.isLocalScope()) {
                this.putInMapIfNotNull(data, "localVariables", variableMap);
            } else {
                this.putInMapIfNotNull(data, "variables", variableMap);
            }
        }
        EventLogEntryEntity ret = this.createEventLogEntry(task.getProcessDefinitionId(), task.getProcessInstanceId(), task.getExecutionId(), task.getId(), task.getBusinessKey(), data);
        String type = String.format(((ActivitiEntityEvent)this.event).getType().getName(), ((ActivitiEntityEvent)this.event).getType().getCode(), task.getId());
        ret.setType(type);
        ret.setElementId(task.getTaskDefinitionKey());
        return ret;
    }
}

