/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.event.logger.handler;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.delegate.event.ActivitiVariableEvent;
import kd.bos.workflow.engine.impl.event.logger.handler.AbstractDatabaseEventLoggerEventHandler;
import kd.bos.workflow.engine.impl.variable.BooleanType;
import kd.bos.workflow.engine.impl.variable.DateType;
import kd.bos.workflow.engine.impl.variable.DoubleType;
import kd.bos.workflow.engine.impl.variable.IntegerType;
import kd.bos.workflow.engine.impl.variable.LongType;
import kd.bos.workflow.engine.impl.variable.ShortType;
import kd.bos.workflow.engine.impl.variable.StringType;
import kd.bos.workflow.engine.impl.variable.UUIDType;
import kd.bos.workflow.engine.impl.variable.VariableType;

public abstract class VariableEventHandler
extends AbstractDatabaseEventLoggerEventHandler {
    protected static Log logger = LogFactory.getLog(VariableEventHandler.class);
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_SHORT = "short";
    public static final String TYPE_INTEGER = "integer";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_UUID = "uuid";
    public static final String TYPE_JSON = "json";

    protected Map<String, Object> createData(ActivitiVariableEvent variableEvent) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        this.putInMapIfNotNull(data, "name", variableEvent.getVariableName());
        this.putInMapIfNotNull(data, "processDefinitionId", variableEvent.getProcessDefinitionId());
        this.putInMapIfNotNull(data, "processInstanceId", variableEvent.getProcessInstanceId());
        this.putInMapIfNotNull(data, "executionId", variableEvent.getExecutionId());
        this.putInMapIfNotNull(data, "value", variableEvent.getVariableValue());
        VariableType variableType = variableEvent.getVariableType();
        if (variableType instanceof BooleanType) {
            this.putInMapIfNotNull(data, "booleanValue", (Boolean)variableEvent.getVariableValue());
            this.putInMapIfNotNull(data, "value", variableEvent.getVariableValue());
            this.putInMapIfNotNull(data, "variableType", TYPE_BOOLEAN);
        } else if (variableType instanceof StringType) {
            this.putInMapIfNotNull(data, "stringValue", (String)variableEvent.getVariableValue());
            this.putInMapIfNotNull(data, "variableType", TYPE_STRING);
        } else if (variableType instanceof ShortType) {
            Short value = (Short)variableEvent.getVariableValue();
            this.putInMapIfNotNull(data, "shortValue", value);
            this.putInMapIfNotNull(data, "variableType", TYPE_SHORT);
            if (value != null) {
                this.putInMapIfNotNull(data, "integerValue", value.intValue());
                this.putInMapIfNotNull(data, "longValue", value.longValue());
                this.putInMapIfNotNull(data, "doubleValue", value.doubleValue());
            }
        } else if (variableType instanceof IntegerType) {
            Integer value = (Integer)variableEvent.getVariableValue();
            this.putInMapIfNotNull(data, "integerValue", value);
            this.putInMapIfNotNull(data, "variableType", TYPE_INTEGER);
            if (value != null) {
                this.putInMapIfNotNull(data, "longValue", value.longValue());
                this.putInMapIfNotNull(data, "doubleValue", value.doubleValue());
            }
        } else if (variableType instanceof LongType) {
            Long value = (Long)variableEvent.getVariableValue();
            this.putInMapIfNotNull(data, "longValue", value);
            this.putInMapIfNotNull(data, "variableType", TYPE_LONG);
            if (value != null) {
                this.putInMapIfNotNull(data, "doubleValue", value.doubleValue());
            }
        } else if (variableType instanceof DoubleType) {
            Double value = (Double)variableEvent.getVariableValue();
            this.putInMapIfNotNull(data, "doubleValue", value);
            this.putInMapIfNotNull(data, "variableType", TYPE_DOUBLE);
            if (value != null) {
                this.putInMapIfNotNull(data, "integerValue", value.intValue());
                this.putInMapIfNotNull(data, "longValue", value.longValue());
            }
        } else if (variableType instanceof DateType) {
            Date value = (Date)variableEvent.getVariableValue();
            this.putInMapIfNotNull(data, "dateValue", value != null ? Long.valueOf(value.getTime()) : null);
            this.putInMapIfNotNull(data, "variableType", TYPE_DATE);
        } else if (variableType instanceof UUIDType) {
            String value = null;
            value = variableEvent.getVariableValue() instanceof UUID ? ((UUID)variableEvent.getVariableValue()).toString() : (String)variableEvent.getVariableValue();
            this.putInMapIfNotNull(data, "uuidValue", value);
            this.putInMapIfNotNull(data, "stringValue", value);
            this.putInMapIfNotNull(data, "variableType", TYPE_UUID);
        }
        return data;
    }
}

