/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.flowchart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.ApprovalHistoryRecord;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.flowchart.ApproverInfo;
import kd.bos.workflow.engine.impl.flowchart.IApprovalRecordsProcessor;
import kd.bos.workflow.engine.impl.flowchart.SharedParameters;
import kd.bos.workflow.engine.impl.flowchart.TransferRecordProcessor;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.engine.impl.util.FlowRecordUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public abstract class AbstractNodeApprovalRecordsProcessor
implements IApprovalRecordsProcessor {
    protected Log log = LogFactory.getLog(this.getClass());
    protected String currentUserId = RequestContext.get().getUserId();
    protected Long procInstId;
    protected String activityId;
    protected SharedParameters parameters;
    protected BpmnModel bpmnModel;
    protected CommandContext commandContext;
    protected TransferRecordProcessor transferProcessor;
    protected static final char DELIMITER = '\u3001';

    public AbstractNodeApprovalRecordsProcessor(SharedParameters parameters) {
        this.parameters = parameters;
        this.procInstId = parameters.getProcInstId();
        this.activityId = parameters.getActivityId();
        this.commandContext = Context.getCommandContext();
        this.bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(this.procInstId);
        this.transferProcessor = new TransferRecordProcessor(parameters);
    }

    private void processApprovalRecord(IApprovalRecordItem item) {
        Long userId = item.getUserId();
        if (WfUtils.isEmpty(userId)) {
            return;
        }
        String taskId = item.getTaskId();
        if (WfUtils.isNotEmpty(userId)) {
            item.setUserStr(String.valueOf(userId));
            item.setCoordinate(CoordinateRecordUtil.isShowCoordinate(Long.valueOf(taskId), Long.valueOf(this.currentUserId)));
        } else {
            item.setCoordinate(false);
        }
        this.fillUserInfo(item);
        this.transferProcessor.processApprovalRecords(item);
    }

    protected IApprovalRecordItem fillUserInfo(IApprovalRecordItem item) {
        Long uid = item.getUserId();
        if (uid == null || uid < 1L) {
            item.setAvatar("");
            return item;
        }
        ApproverInfo user = this.parameters.getUserInfo(uid);
        if (user == null) {
            this.log.debug(String.format("ApproverInfo is null! UserId: %s TaskId: %s ActivityId: %s", uid, item.getTaskId(), item.getActivityId()));
            return item;
        }
        if (!this.currentUserId.equals(String.valueOf(user.getId()))) {
            item.setOpenId(user.getOpenId());
        }
        if (WfUtils.isEmpty(item.getAssignee()) && user.getName() != null) {
            item.setAssignee(user.getName());
        }
        if (StringUtils.isBlank((CharSequence)item.getAvatar())) {
            item.setAvatar(WfUtils.getAbsAvatarPath(user.getAvatar()));
        }
        return item;
    }

    protected List<TaskEntity> getCurrentTasks() {
        QFilter[] filters = new QFilter[]{new QFilter("processInstanceId", "=", (Object)this.procInstId), new QFilter("taskDefinitionKey", "=", (Object)this.activityId)};
        TaskEntityManager manager = this.commandContext.getTaskEntityManager();
        return manager.findByQueryFilters(filters, manager.getSelectFields(), "id asc");
    }

    protected List<HistoricTaskInstanceEntity> getHistoryCurrentTasks() {
        QFilter[] filters = new QFilter[]{new QFilter("processInstanceId", "=", (Object)this.procInstId), new QFilter("taskDefinitionKey", "=", (Object)this.activityId)};
        HistoricTaskInstanceEntityManager manager = this.commandContext.getHistoricTaskInstanceEntityManager();
        return manager.findByQueryFilters(filters, manager.getSelectFields(), "id asc");
    }

    protected List<IdentityLinkEntity> getTaskParticipants(Long taskId) {
        return this.commandContext.getIdentityLinkEntityManager().findUnDelegateIdentityLinkByTaskUserAndType(taskId, 0L, "participant");
    }

    protected List<ApprovalHistoryRecord> getFormattedRecords(List<IApprovalRecordItem> items) {
        ArrayList<ApprovalHistoryRecord> records = new ArrayList<ApprovalHistoryRecord>();
        if (items.isEmpty()) {
            return records;
        }
        for (IApprovalRecordItem item : items) {
            this.processApprovalRecord(item);
            this.setAddSignMsg(item, items.size());
            this.log.debug(item.toString());
            if (!"thirdComment".equals(item.getSource()) || !WfUtils.isNotEmpty(item.getSubactivityname())) continue;
            item.setActivityName(item.getSubactivityname());
        }
        try {
            items = FlowRecordUtil.executeFormatPlugin(this.bpmnModel.getMainProcess(), items);
        }
        catch (Exception e) {
            this.log.error("format records error! " + WfUtils.getExceptionStacktrace(e));
        }
        for (IApprovalRecordItem item : items) {
            if (item instanceof ApprovalHistoryRecord) {
                records.add((ApprovalHistoryRecord)item);
                continue;
            }
            if (item instanceof ApprovalRecordItem) {
                records.add(this.getApprovalHistoryRecordFromItem((ApprovalRecordItem)item));
                continue;
            }
            this.log.error("Type Error!!! Type: " + item.getClass().getName());
        }
        return records;
    }

    private ApprovalHistoryRecord getApprovalHistoryRecordFromItem(ApprovalRecordItem item) {
        ApprovalHistoryRecord record = new ApprovalHistoryRecord();
        record.setTaskId(item.getTaskId());
        record.setUserId(item.getUserId());
        record.setUserStr(item.getUserStr());
        record.setOpenId(item.getOpenId());
        record.setAvatar(item.getAvatar());
        record.setActivityId(item.getActivityId());
        record.setActivityName(item.getActivityName());
        record.setMessage(item.getMessage());
        record.setAttachments(item.getAttachments());
        record.setDecisionType(item.getDecisionType());
        record.setResult(item.getResult());
        record.setGroupId(item.getGroupId());
        record.setTime(item.getTime());
        record.setAssignee(item.getAssignee());
        record.setCoordinate(item.isCoordinate());
        record.setShowTransferRecord(item.isShowTransferRecord());
        record.setLinks(item.getLinks());
        record.setType(item.getType());
        record.setProcInstId(item.getProcInstId());
        record.setCommentId(item.getCommentId());
        record.setEntityNumber(item.getEntityNumber());
        record.setBusinessKey(item.getBusinessKey());
        return record;
    }

    private void setAddSignMsg(IApprovalRecordItem item, int size) {
        FlowElement flowElement = this.bpmnModel.getFlowElement(item.getActivityId());
        if (WfUtils.isNotEmpty(item.getUserId()) && (flowElement instanceof YunzhijiaTask || flowElement instanceof AuditTask && size > 1)) {
            return;
        }
        Map<Object, Object> addSignMsg = new HashMap();
        if (flowElement instanceof AuditTask) {
            AuditTask auditTask = (AuditTask)flowElement;
            addSignMsg = auditTask.getAddSignMsg();
        } else if (flowElement instanceof CallActivity) {
            CallActivity callActity = (CallActivity)flowElement;
            addSignMsg = callActity.getAddSignMsg();
        }
        if (addSignMsg != null && !addSignMsg.isEmpty()) {
            LocaleString addSignMsgValue = LocaleString.fromMap(addSignMsg);
            String message = item.getMessage();
            if (WfUtils.isEmpty(message)) {
                message = addSignMsgValue.toString();
            } else {
                StringBuilder msg = new StringBuilder();
                msg.append(message).append("<br/>").append(addSignMsgValue);
                message = msg.toString();
            }
            item.setMessage(message);
        }
    }

    protected List<ApprovalHistoryRecord> getApprovalHistoryRecords(List<IApprovalRecordItem> items) {
        ArrayList<ApprovalHistoryRecord> records = new ArrayList<ApprovalHistoryRecord>();
        for (IApprovalRecordItem item : items) {
            if (item instanceof ApprovalHistoryRecord) {
                records.add((ApprovalHistoryRecord)item);
                continue;
            }
            this.log.error("Type Error!!! Type: " + item.getClass().getName());
        }
        return records;
    }

    protected List<ApprovalHistoryRecord> currentUserToFirst(List<ApprovalHistoryRecord> items) {
        if (items == null || items.size() < 3) {
            return items;
        }
        int current = -1;
        ApprovalHistoryRecord item = null;
        for (int i = 0; i < items.size(); ++i) {
            item = items.get(i);
            if (!this.currentUserId.equals(String.valueOf(item.getUserId()))) continue;
            current = i;
            break;
        }
        int topmost = this.getTopmostIndex();
        if (current > -1 && current != topmost) {
            items.remove(current);
            items.add(topmost, item);
        }
        return items;
    }

    protected int getTopmostIndex() {
        return 1;
    }

    private String getProcessedSplicedNames(StringBuilder names) {
        String REGEX = "(.+)\u3001+";
        return names.toString().replaceFirst("(.+)\u3001+", "$1");
    }

    protected String getSummaryMessage(String rule, StringBuilder names) {
        return this.getSummaryMessage(rule, this.getProcessedSplicedNames(names));
    }

    protected String getSummaryMessage(String rule, String names) {
        if (names.length() > 1) {
            return String.format("%s<br/>%s%s", rule, WFMultiLangConstants.getParticipantsNameLabel(), names);
        }
        return rule;
    }

    protected <T extends FlowElement> T getCurrentNode() {
        return (T)this.bpmnModel.getFlowElement(this.activityId);
    }

    @Override
    public boolean filter(List<IApprovalRecordItem> items, ApprovalHistoryRecord current) {
        return false;
    }
}

