/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.flowchart;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.ApprovalHistoryRecord;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.flowchart.ApprovalRecordsStatus;
import kd.bos.workflow.engine.impl.flowchart.ApproverInfo;
import kd.bos.workflow.engine.impl.flowchart.CallActivityNodeProcessor;
import kd.bos.workflow.engine.impl.flowchart.CommonNodeProcessor;
import kd.bos.workflow.engine.impl.flowchart.IApprovalRecordsProcessor;
import kd.bos.workflow.engine.impl.flowchart.RPANodeProcessor;
import kd.bos.workflow.engine.impl.flowchart.SSCApproveNodeProcessor;
import kd.bos.workflow.engine.impl.flowchart.SharedParameters;
import kd.bos.workflow.engine.impl.flowchart.YunzhijiaNodeProcessor;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.util.FlowRecordUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.task.Comment;
import kd.bos.workflow.engine.task.TaskDelegateUtil;

public class ApprovalRecordsProcessHelper {
    private static final String FTRUENAME = "FTRUENAME";
    private static final String FUSERNAMEFORMATTER = "fusernameformatter";
    private static final String ASSIGNORNAME = "assignorname";
    public static final String HICOMMENT = "T_WF_HICOMMENT";
    public static final String HICOMMENTMULTI = "T_WF_HICOMMENT_L";
    public static final String TRDHICOMMENT = "T_WF_TRDHICOMMENT";
    public static final String TRDHICOMMENTMULTI = "T_WF_TRDHICOMMENT_L";
    public static final String THIRDSOURCE = "thirdComment";
    public static final String COMMENT = "comment";
    public static final String APPROVE = "approve";
    public static final String REJECT = "reject";
    public static final String TERMINATE = "terminate";
    public static final String HANDLED = "handled";
    public static final String DISMISSED = "dismissed";
    public static final String FREEZE = "freeze";
    public static final String MANUALSUSPENDED = "manualSuspended";
    public static final String CONVERTED = "converted";
    private Log log = LogFactory.getLog(this.getClass());
    private ApprovalRecordsStatus status;
    private Long procInstId;
    private String activityId;
    private List<HistoricActivityInstanceEntity> actInstEntities;
    private IApprovalRecordsProcessor nodeProcessor;
    private List<IApprovalRecordItem> approvalRecords = new ArrayList<IApprovalRecordItem>();
    private Map<Long, ApproverInfo> userMap = new HashMap<Long, ApproverInfo>();
    private Map<String, TaskHandleLogEntity> latestTransferLogMap = new HashMap<String, TaskHandleLogEntity>();

    public ApprovalRecordsProcessHelper(ApprovalRecordsStatus status, Long procInstId, String activityId, List<HistoricActivityInstanceEntity> actInstEntities) {
        this.status = status;
        this.procInstId = procInstId;
        this.activityId = activityId;
        this.actInstEntities = actInstEntities;
        boolean needInitData = this.initNodeProcessor();
        if (needInitData) {
            this.initData();
        }
    }

    public List<ApprovalHistoryRecord> getApprovalRecords() {
        List<ApprovalHistoryRecord> result = null;
        switch (this.status) {
            case CURRENT: {
                result = this.nodeProcessor.getCurrentLatestRecords(this.approvalRecords);
                break;
            }
            case LATEST: {
                result = this.nodeProcessor.getLatestRecords(this.approvalRecords);
                break;
            }
            case HISTORY: {
                result = this.nodeProcessor.getHistoryRecords(this.approvalRecords);
                break;
            }
            case CURRENTHISTORY: {
                result = this.nodeProcessor.getCurrentHistoryRecords(this.approvalRecords);
                break;
            }
            default: {
                return result;
            }
        }
        return result;
    }

    @Deprecated
    private StringBuilder getRecordsInfoSql(String entityNumber, String table, String tableMulti) {
        StringBuilder sql = new StringBuilder("SELECT ");
        String masterTableAlias = "COM";
        String multiLangTableAlias = "COML";
        String activityNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "FACTIVITYNAME", "FACTIVITYNAME", "activityname");
        String subActivityNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "fsubactivityname", "fsubactivityname", "subactivityname");
        String assigneeSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "FASSIGNEE", "FASSIGNEE", "assignee");
        String messageSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "FMESSAGE", "FMESSAGE", "message");
        String resultNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "FRESULTNAME", "FRESULTNAME", "resultname");
        String usernNameFormatterSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, FUSERNAMEFORMATTER, FUSERNAMEFORMATTER, "usernameformatter");
        String assignorNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "ftrustname", ASSIGNORNAME, ASSIGNORNAME);
        sql.append("COM.FRICHTEXTMESSAGE,COM.FID,COM.FTYPE,COM.FTASKID,COM.FOWNERID,COM.FUSERID,COM.FACTIVITYID,COM.FDECISIONTYPE,COM.FTIME,COM.FGROUPID,COM.FBACKTOBACK,COM.FBIZIDENTIFYKEY,COM.FBUSINESSKEY,COM.FENTITYNUMBER,");
        sql.append(activityNameSQL).append(',').append(subActivityNameSQL).append(',').append(assigneeSQL).append(',').append(messageSQL).append(',').append(usernNameFormatterSQL).append(',').append(assignorNameSQL).append(",").append(resultNameSQL);
        sql.append(" FROM ");
        sql.append(table);
        sql.append(" COM ");
        sql.append("LEFT JOIN ");
        sql.append(tableMulti);
        sql.append(" COML ON COM.FID = COML.FID AND COML.FLOCALEID = ?");
        sql.append("WHERE COM.FPROCINSTID = ? AND COM.FACTIVITYID = ? ");
        sql.append("AND (COM.FTYPE = ? OR COM.FTYPE = ? OR COM.FTYPE = ' ') ");
        sql.append("ORDER BY COM.FTIME DESC,COM.FUSERID;");
        return sql;
    }

    private List<IApprovalRecordItem> getRecordsInfo(Set<Long> userIds, Map<Long, Long> idMap, String entityNumber, String table, String tableMulti, String source) {
        ArrayList<IApprovalRecordItem> resultInfo = new ArrayList<IApprovalRecordItem>();
        QFilter qfs = new QFilter("processInstanceId", "=", (Object)this.procInstId).and(new QFilter("activityId", "=", (Object)this.activityId)).and(new QFilter("type", "=", (Object)COMMENT).or("type", "=", (Object)"suggestion").or("type", "=", (Object)" "));
        String orderBy = "time desc,userId";
        List<CommentEntity> result = "wf_trdhicomment".equals(entityNumber) ? Context.getCommandContext().getTrdCommentEntityManager().findApprovalRecordByAuth(qfs.toArray(), orderBy) : Context.getCommandContext().getCommentEntityManager().findApprovalRecordByAuth(qfs.toArray(), orderBy);
        List commentEntities = Optional.ofNullable(result).orElseGet(ArrayList::new);
        ApprovalHistoryRecord record = null;
        for (CommentEntity comment : commentEntities) {
            Map<String, Object> attachmentInfo;
            Optional<CommentEntity> commentGetter = Optional.of(comment);
            Long taskId = commentGetter.map(Comment::getTaskId).orElseGet(() -> 0L);
            Long userId = commentGetter.map(Comment::getUserId).orElseGet(() -> 0L);
            String billId = commentGetter.map(CommentEntity::getBusinessKey).orElseGet(() -> "");
            Long businesskey = 0L;
            if (billId.matches("^\\d+$")) {
                businesskey = Long.valueOf(billId);
            }
            String entitynumber = comment.getEntityNumber();
            record = new ApprovalHistoryRecord();
            record.setCommentId(String.valueOf(commentGetter.map(Comment::getId).orElseGet(() -> 0L)));
            record.setTaskId(String.valueOf(commentGetter.map(Comment::getTaskId).orElseGet(() -> 0L)));
            record.setUserId(userId);
            if (comment instanceof CommentEntityImpl) {
                record.setAvatar(((CommentEntityImpl)comment).getAvatar());
            }
            record.setBusinessKey(String.valueOf(businesskey));
            record.setEntityNumber(entitynumber);
            if (WfUtils.isNotEmpty(userId)) {
                record.setUserStr(String.valueOf(userId));
            }
            record.setActivityId(comment.getActivityId());
            record.setActivityName(comment.getActivityName());
            record.setSubactivityname(comment.getSubactivityname());
            String richTextMessage = comment.getRichTextMessage();
            if (WfUtils.isNotEmpty(richTextMessage)) {
                record.setMessage(richTextMessage);
            } else {
                record.setMessage(comment.getMessage());
            }
            String signature = comment.getSignature();
            if (WfUtils.isNotEmpty(signature)) {
                record.setSignature(signature);
            }
            if ((attachmentInfo = FlowRecordUtil.getProcessAttachmentInfo(this.procInstId, taskId, record.getCommentId())) != null && !attachmentInfo.isEmpty()) {
                record.setState((String)attachmentInfo.get("attachmentIds"));
                record.setAttachments((List)attachmentInfo.get("attachments"));
            }
            record.setDecisionType(comment.getDecisionType());
            record.setResult(comment.getResultName());
            record.setType(comment.getType());
            record.setSource(source);
            record.setScene("workflow");
            Date recordTime = comment.getTime();
            if (recordTime != null) {
                record.setTime(WfUtils.parseToUserZoneDateString(recordTime));
            }
            record.setGroupId(comment.getGroupId());
            if (WfUtils.isEmpty(record.getGroupId())) {
                record.setGroupId(String.valueOf(taskId));
            }
            record.setBackToBack(commentGetter.map(CommentEntity::getBackToBack).orElseGet(() -> Boolean.FALSE));
            String userNameFormatter = commentGetter.map(CommentEntity::getUserNameFormatter).orElseGet(LocaleString::new).toString();
            String assignee = ParticipantHelper.getUserName(comment.getAssignee(), userNameFormatter);
            Long ownerId = comment.getOwnerId();
            DynamicObject hiparticipant = null;
            List<HistoricIdentityLinkEntity> entitys = Context.getCommandContext().getHistoricIdentityLinkEntityManager().findParticipantsByTaskIdAndUserId(taskId, ownerId, null, "usernameformatter");
            if (WfUtils.isNotEmptyForCollection(entitys)) {
                hiparticipant = entitys.get(0).getDynamicObject();
            }
            LocaleString assignorNameFormat = new LocaleString();
            if (hiparticipant != null) {
                assignorNameFormat = hiparticipant.getLocaleString("usernameformatter");
            }
            String assignorName = ParticipantHelper.getUserName(commentGetter.map(CommentEntity::getAssignorName).orElseGet(LocaleString::new).toString(), (ILocaleString)assignorNameFormat);
            if (!(WfUtils.isEmpty(ownerId) || WfUtils.isEmpty(assignorName) || WfUtils.isEmpty(assignee))) {
                assignee = TaskDelegateUtil.getDelegateAssigneeName(assignorName, assignee, "replace");
            }
            record.setAssignee(assignee);
            record.setBizIdentifyKey(comment.getBizIdentifyKey());
            userIds.add(record.getUserId());
            userIds.add(record.getOwnerId());
            if (WfUtils.isNotEmpty(taskId)) {
                idMap.put(taskId, record.getUserId());
            }
            this.log.debug("ApprovalRecordsProcessHelper.getRecordsInfo:" + record.toString());
            if (this.nodeProcessor.filter(resultInfo, record)) continue;
            resultInfo.add(record);
        }
        return resultInfo;
    }

    private void sortApprovalRecords() {
        final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.approvalRecords.sort(new Comparator<IApprovalRecordItem>(){

            @Override
            public int compare(IApprovalRecordItem iApprovalRecordItemBefore, IApprovalRecordItem iApprovalRecordItemAfter) {
                String beforeRecord = iApprovalRecordItemBefore.getTime();
                String afterRecord = iApprovalRecordItemAfter.getTime();
                try {
                    long beforeRecordTime = sdf.parse(beforeRecord).getTime();
                    long afterRecordTime = sdf.parse(afterRecord).getTime();
                    if (beforeRecordTime > afterRecordTime) {
                        return 1;
                    }
                    if (beforeRecordTime < afterRecordTime) {
                        return -1;
                    }
                }
                catch (ParseException e) {
                    ApprovalRecordsProcessHelper.this.log.error(WfUtils.getExceptionStacktrace(e));
                }
                return 0;
            }
        });
    }

    private void initData() {
        List<IApprovalRecordItem> trdResultInfo;
        HashSet<Long> userIds = new HashSet<Long>();
        HashMap<Long, Long> idMap = new HashMap<Long, Long>();
        List<IApprovalRecordItem> resultInfo = this.getRecordsInfo(userIds, idMap, "wf_hicomment", HICOMMENT, HICOMMENTMULTI, COMMENT);
        this.approvalRecords.addAll(resultInfo);
        Boolean showTrdApprovalRecord = WfConfigurationUtil.showTrdApprovalRecord();
        if (showTrdApprovalRecord.booleanValue() && CollectionUtils.isNotEmpty(trdResultInfo = this.getRecordsInfo(userIds, idMap, "wf_trdhicomment", TRDHICOMMENT, TRDHICOMMENTMULTI, THIRDSOURCE))) {
            this.approvalRecords.addAll(trdResultInfo);
            this.sortApprovalRecords();
        }
        this.initUserMap(userIds);
        this.initLatestTransferLog(Context.getCommandContext(), idMap, this.latestTransferLogMap);
    }

    private void initUserMap(Set<Long> userIds) {
        if (userIds.isEmpty()) {
            return;
        }
        StringBuffer ids = new StringBuffer("(");
        for (Long id : userIds) {
            if (WfUtils.isEmpty(id)) continue;
            ids.append(id).append(',');
        }
        int size = ids.length() - 1;
        if (ids.lastIndexOf(",") == size) {
            ids.deleteCharAt(size);
        }
        ids.append(')');
        if (ids.length() < 3) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        String trueNameSQL = WfMultiLangUtils.getGeneralLangSQL("bos_user", "U", "UL", FTRUENAME, FTRUENAME, "name");
        sql.append("SELECT U.FID,U.FNUMBER,U.FOPENID,U.FAVATAR,U.FTRUENAME NAME,").append(trueNameSQL).append(" FROM T_SEC_USER U ");
        sql.append("LEFT JOIN T_SEC_USER_L UL ON U.FID = UL.FID AND UL.FLOCALEID = ? ");
        sql.append("WHERE U.FID IN ").append(ids);
        String lang = RequestContext.get().getLang().toString();
        try (DataSet ds = DB.queryDataSet((String)"wf.engine.getUserInformation", (DBRoute)DBRoute.main, (String)sql.toString(), (Object[])new Object[]{lang});){
            for (Row row : ds) {
                Long userId = row.getLong("FID");
                String name = row.getString(FTRUENAME);
                if (WfUtils.isEmpty(name)) {
                    name = row.getString("NAME");
                }
                String number = row.getString("FNUMBER");
                name = WfUtils.getUserNameForFinal(userId, name, number);
                this.userMap.put(row.getLong("FID"), new ApproverInfo(userId, row.getString("FAVATAR"), name, row.getString("FOPENID")));
            }
        }
    }

    private boolean initNodeProcessor() {
        boolean needInitData = true;
        HistoricActivityInstanceEntity entity = this.actInstEntities.get(0);
        SharedParameters parameters = new SharedParameters(this.procInstId, this.activityId, this.userMap, this.latestTransferLogMap);
        switch (entity.getActivityType()) {
            case "YunzhijiaTask": {
                Boolean isCancel = Boolean.TRUE;
                for (HistoricActivityInstanceEntity act : this.actInstEntities) {
                    if (!WfUtils.isNotEmpty(act.getParentTaskId()) || !act.getParentTaskId().equals(entity.getParentTaskId()) || "cancel".equals(act.getExecutionType())) continue;
                    isCancel = Boolean.FALSE;
                }
                parameters.setIsCancel(isCancel);
                this.nodeProcessor = new YunzhijiaNodeProcessor(parameters);
                break;
            }
            case "SSCApprove": {
                this.nodeProcessor = new SSCApproveNodeProcessor(parameters);
                break;
            }
            case "CallActivity": {
                needInitData = false;
                this.nodeProcessor = new CallActivityNodeProcessor(parameters);
                break;
            }
            case "RPATask": {
                this.nodeProcessor = new RPANodeProcessor(parameters);
                break;
            }
            default: {
                this.nodeProcessor = new CommonNodeProcessor(parameters);
            }
        }
        return needInitData;
    }

    private void initLatestTransferLog(CommandContext commandContext, Map<Long, Long> idMap, Map<String, TaskHandleLogEntity> latestTransferLogMap) {
        if (idMap == null || idMap.isEmpty()) {
            this.log.debug("TaskIds is empty!");
            return;
        }
        Map<String, TaskHandleLogEntity> ret = Context.getCommandContext().getTaskHandleLogEntityManager().getTasksLatestTransferLogs(idMap);
        latestTransferLogMap.putAll(ret);
    }

    public static String getTaskHandleState(String state) {
        String handleState = null;
        if (APPROVE.equalsIgnoreCase(state)) {
            handleState = ResManager.loadKDString((String)"\u5df2\u540c\u610f", (String)"ApprovalRecordsProcessHelper_1", (String)"bos-wf-engine", (Object[])new Object[0]);
        } else if (REJECT.equalsIgnoreCase(state)) {
            handleState = ResManager.loadKDString((String)"\u5df2\u9a73\u56de", (String)"ApprovalRecordsProcessHelper_2", (String)"bos-wf-engine", (Object[])new Object[0]);
        } else if (TERMINATE.equalsIgnoreCase(state)) {
            handleState = ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"ApprovalRecordsProcessHelper_3", (String)"bos-wf-engine", (Object[])new Object[0]);
        } else if (HANDLED.equalsIgnoreCase(state)) {
            handleState = ResManager.loadKDString((String)"\u5df2\u5904\u7406", (String)"ApprovalRecordsProcessHelper_4", (String)"bos-wf-engine", (Object[])new Object[0]);
        } else if (DISMISSED.equalsIgnoreCase(state)) {
            handleState = ResManager.loadKDString((String)"\u88ab\u9a73\u56de", (String)"ApprovalRecordsProcessHelper_5", (String)"bos-wf-engine", (Object[])new Object[0]);
        } else if (FREEZE.equals(state)) {
            handleState = ResManager.loadKDString((String)"\u5df2\u51bb\u7ed3", (String)"ApprovalRecordsProcessHelper_6", (String)"bos-wf-engine", (Object[])new Object[0]);
        } else if (MANUALSUSPENDED.equals(state)) {
            handleState = ResManager.loadKDString((String)"\u5df2\u6302\u8d77", (String)"ApprovalRecordsProcessHelper_7", (String)"bos-wf-engine", (Object[])new Object[0]);
        } else if (CONVERTED.equals(state)) {
            handleState = ResManager.loadKDString((String)"\u5df2\u8f6c\u6362", (String)"ApprovalRecordsProcessHelper_8", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        return handleState;
    }
}

