/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.flowchart;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.ApprovalHistoryRecord;
import kd.bos.workflow.engine.impl.flowchart.AbstractNodeApprovalRecordsProcessor;
import kd.bos.workflow.engine.impl.flowchart.SharedParameters;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class CallActivityNodeProcessor
extends AbstractNodeApprovalRecordsProcessor {
    public CallActivityNodeProcessor(SharedParameters parameters) {
        super(parameters);
    }

    @Override
    public List<ApprovalHistoryRecord> getLatestRecords(List<IApprovalRecordItem> items) {
        return this.getCurrentLatestRecords(items);
    }

    @Override
    public List<ApprovalHistoryRecord> getCurrentLatestRecords(List<IApprovalRecordItem> items) {
        List<IApprovalRecordItem> result = this.getApprovalRecords();
        if (result.isEmpty()) {
            return this.getFormattedRecords(result);
        }
        return this.getFormattedRecords(result.subList(0, 1));
    }

    private List<IApprovalRecordItem> getApprovalRecords() {
        ArrayList<IApprovalRecordItem> result = new ArrayList<IApprovalRecordItem>();
        FlowElement flowElement = this.bpmnModel.getFlowElement(this.activityId);
        String nodeName = flowElement.getName();
        List<HistoricActivityInstanceEntity> historicActivityInstanceEntities = this.commandContext.getHistoricActivityInstanceEntityManager().findByActivityId(this.procInstId, this.activityId);
        if (CollectionUtil.isNotEmpty(historicActivityInstanceEntities)) {
            for (HistoricActivityInstanceEntity historicActivityInstanceEntity : historicActivityInstanceEntities) {
                Long calledProcessInstanceId = historicActivityInstanceEntity.getCalledProcessInstanceId();
                if (!WfUtils.isNotEmpty(calledProcessInstanceId)) continue;
                ApprovalHistoryRecord callActivityRecord = this.initApprovalHistoryRecordInfo(calledProcessInstanceId, nodeName);
                Date endTime = historicActivityInstanceEntity.getEndTime();
                if (endTime != null) {
                    callActivityRecord.setTime(WfUtils.parseToUserZoneDateString(endTime));
                }
                result.add(callActivityRecord);
            }
        }
        return result;
    }

    private ApprovalHistoryRecord initApprovalHistoryRecordInfo(long childProcInstId, String nodeName) {
        ApprovalHistoryRecord approvalHistoryRecord = new ApprovalHistoryRecord();
        approvalHistoryRecord.setActivityName(nodeName);
        approvalHistoryRecord.setProcInstId(String.valueOf(childProcInstId));
        approvalHistoryRecord.setActivityId(this.activityId);
        approvalHistoryRecord.setCallActivity(true);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId(childProcInstId);
        String processName = bpmnModel.getMainProcess().getName();
        approvalHistoryRecord.setMessage(processName);
        List<TaskEntity> taskEntities = this.commandContext.getTaskEntityManager().findTasksByProcessInstanceId(childProcInstId);
        if (CollectionUtil.isEmpty(taskEntities)) {
            HistoricProcessInstanceEntity historicProcessInstanceEntity = (HistoricProcessInstanceEntity)this.commandContext.getHistoricProcessInstanceEntityManager().findById(childProcInstId);
            if (historicProcessInstanceEntity != null && historicProcessInstanceEntity.getEndTime() != null) {
                approvalHistoryRecord.setResult(WFMultiLangConstants.getSSCStateName2());
                return approvalHistoryRecord;
            }
            ExecutionEntity executionEntity = (ExecutionEntity)this.commandContext.getExecutionEntityManager().findById(childProcInstId);
            if (executionEntity != null && executionEntity.getSuspensionState().equals("2")) {
                approvalHistoryRecord.setResult(WFMultiLangConstants.getHangUpStateName());
                return approvalHistoryRecord;
            }
            return approvalHistoryRecord;
        }
        approvalHistoryRecord.setResult(GraphCodecUtils.getHandleStateName(this.procInstId, this.activityId));
        List<HistoricActivityInstanceEntity> historicActivityInstanceEntities = this.commandContext.getHistoricActivityInstanceEntityManager().findByActivityId(this.procInstId, this.activityId);
        if (CollectionUtil.isNotEmpty(historicActivityInstanceEntities)) {
            String time = WfUtils.parseToUserZoneDateString(historicActivityInstanceEntities.get(0).getCreateDate());
            approvalHistoryRecord.setTime(time);
        }
        return approvalHistoryRecord;
    }

    @Override
    public List<ApprovalHistoryRecord> getCurrentHistoryRecords(List<IApprovalRecordItem> items) {
        List<IApprovalRecordItem> result = this.getApprovalRecords();
        if (result != null && result.size() > 1) {
            return this.getFormattedRecords(result.subList(1, result.size()));
        }
        return new ArrayList<ApprovalHistoryRecord>();
    }

    @Override
    public List<ApprovalHistoryRecord> getHistoryRecords(List<IApprovalRecordItem> items) {
        return this.getCurrentHistoryRecords(items);
    }
}

