/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.flowchart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.ApprovalHistoryRecord;
import kd.bos.workflow.engine.impl.flowchart.AbstractNodeApprovalRecordsProcessor;
import kd.bos.workflow.engine.impl.flowchart.ApprovalRecordsProcessHelper;
import kd.bos.workflow.engine.impl.flowchart.SharedParameters;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.task.TaskDelegateUtil;

public class CommonNodeProcessor
extends AbstractNodeApprovalRecordsProcessor {
    public CommonNodeProcessor(SharedParameters parameters) {
        super(parameters);
    }

    @Override
    public List<ApprovalHistoryRecord> getLatestRecords(List<IApprovalRecordItem> items) {
        boolean hasTrdComment;
        if (items.isEmpty()) {
            return new ArrayList<ApprovalHistoryRecord>();
        }
        List<HistoricTaskInstanceEntity> historyTasks = this.getHistoryCurrentTasks();
        if (CollectionUtils.isNotEmpty(historyTasks) && (hasTrdComment = this.hasTrdTaskComment(items))) {
            ApprovalHistoryRecord approvalHistoryRecord;
            HistoricTaskInstanceEntity hisotryTask = historyTasks.get(historyTasks.size() - 1);
            String taskId = String.valueOf(hisotryTask.getId());
            ApprovalHistoryRecord summaryRecord = approvalHistoryRecord = this.getSummaryComment(hisotryTask);
            ArrayList<IApprovalRecordItem> finalItems = new ArrayList<IApprovalRecordItem>(items.size() + 1);
            for (IApprovalRecordItem item : items) {
                if (taskId == null || !taskId.equals(item.getTaskId())) continue;
                finalItems.add(item);
            }
            finalItems.add(summaryRecord);
            return this.getFormattedRecords(finalItems);
        }
        return this.getFormattedRecords(items.subList(0, 1));
    }

    private ApprovalHistoryRecord getSummaryComment(HistoricTaskInstanceEntity hisotryTask) {
        ApprovalHistoryRecord approvalHistoryRecord = new ApprovalHistoryRecord();
        approvalHistoryRecord.setType(hisotryTask.getCategory());
        approvalHistoryRecord.setActivityName(((FlowElement)this.getCurrentNode()).getName());
        approvalHistoryRecord.setActivityId(hisotryTask.getTaskDefinitionKey());
        approvalHistoryRecord.setBusinessKey(hisotryTask.getBusinessKey());
        approvalHistoryRecord.setEntityNumber(hisotryTask.getEntityNumber());
        String state = hisotryTask.getHandleState();
        String stateName = ApprovalRecordsProcessHelper.getTaskHandleState(state);
        approvalHistoryRecord.setResult(stateName);
        return approvalHistoryRecord;
    }

    private boolean hasTrdTaskComment(List<IApprovalRecordItem> items) {
        boolean hasTrdComment = false;
        if (items != null && items.size() > 0) {
            for (IApprovalRecordItem approvalRecordItem : items) {
                String source = approvalRecordItem.getSource();
                if (!"thirdComment".equals(source)) continue;
                hasTrdComment = true;
                break;
            }
        }
        return hasTrdComment;
    }

    private boolean hasTrdAuditTaskComment(List<IApprovalRecordItem> items, TaskEntity currentTask, String taskId) {
        boolean hasTrdComment = false;
        if (CollectionUtils.isNotEmpty(items)) {
            for (IApprovalRecordItem approvalRecordItem : items) {
                String source = approvalRecordItem.getSource();
                String approvalTaskId = approvalRecordItem.getTaskId();
                if (!approvalTaskId.equals(taskId) || !"thirdComment".equals(source)) continue;
                hasTrdComment = true;
                break;
            }
        }
        return hasTrdComment;
    }

    @Override
    public List<ApprovalHistoryRecord> getCurrentLatestRecords(List<IApprovalRecordItem> items) {
        ArrayList<IApprovalRecordItem> approvalRecordItemList = new ArrayList<IApprovalRecordItem>();
        List<TaskEntity> currentTasks = this.getCurrentTasks();
        if (currentTasks != null && !currentTasks.isEmpty()) {
            TaskEntity currentTask = currentTasks.get(0);
            Long taskId = currentTask.getId();
            ApprovalHistoryRecord record = new ApprovalHistoryRecord();
            record.setType(currentTask.getCategory());
            record.setActivityName(((FlowElement)this.getCurrentNode()).getName());
            record.setActivityId(currentTask.getTaskDefinitionKey());
            record.setBusinessKey(currentTask.getBusinessKey());
            record.setEntityNumber(currentTask.getEntityNumber());
            boolean hasTrdComment = this.hasTrdAuditTaskComment(items, currentTask, String.valueOf(taskId));
            List<IdentityLinkEntity> participants = this.getTaskParticipants(taskId);
            String time = WfUtils.parseToUserZoneDateString(currentTask.getCreateDate());
            if (participants.isEmpty() || hasTrdComment) {
                record.setTime(time);
                record.setResult(this.getStateName());
                record.setTaskId(String.valueOf(taskId));
                record.setActivityId(currentTask.getTaskDefinitionKey());
                approvalRecordItemList.add(record);
            } else if (participants.size() == 1) {
                record.setTime(time);
                record.setActivityId(currentTask.getTaskDefinitionKey());
                approvalRecordItemList.add(this.buildApprovalRecord(record, participants.get(0), taskId));
            } else if (participants.size() > 1) {
                FlowElement userTask;
                ApprovalHistoryRecord summaryRecord = record;
                approvalRecordItemList.add(summaryRecord);
                StringBuilder names = new StringBuilder();
                String displayInfo = null;
                BpmnModel model = ProcessDefinitionUtil.getBpmnModel(currentTask.getProcessDefinitionId(), currentTask.getProcessInstanceId());
                if (model != null && (userTask = model.getFlowElement(currentTask.getTaskDefinitionKey())) instanceof UserTask) {
                    ParticipatantModel participantModel = ((UserTask)userTask).getParticipant();
                    displayInfo = participantModel == null ? null : participantModel.getDisplayInfo();
                }
                boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
                for (IdentityLinkEntity entity : participants) {
                    ApprovalHistoryRecord personalized = new ApprovalHistoryRecord();
                    personalized.setTime(time);
                    personalized.setActivityId(currentTask.getTaskDefinitionKey());
                    approvalRecordItemList.add(this.buildApprovalRecord(personalized, entity, taskId));
                    String name = this.getSummaryNames(entity, displayInfo, isDisplaySetting);
                    if (!WfUtils.isNotEmpty(name)) continue;
                    names = names.append(name).append('\u3001');
                }
                summaryRecord.setMessage(this.getSummaryMessage(WFMultiLangConstants.getApprovalByAnyoneName(), names));
            }
            this.mergeApprovalRecordItem(items, taskId, currentTask, approvalRecordItemList);
        } else {
            this.log.error(String.format("The current task is null! %s %s", this.procInstId, this.activityId));
        }
        return this.currentUserToFirst(this.getFormattedRecords(approvalRecordItemList));
    }

    private void mergeApprovalRecordItem(List<IApprovalRecordItem> items, Long taskId, TaskEntity currentTask, List<IApprovalRecordItem> approvalRecordItemList) {
        if (items != null && items.size() > 0) {
            for (IApprovalRecordItem approvalRecordItem : items) {
                String approvalTaskId = approvalRecordItem.getTaskId();
                if (!approvalTaskId.equals(String.valueOf(taskId))) continue;
                ApprovalHistoryRecord approvalHistoryRecord = new ApprovalHistoryRecord();
                String approvalTime = approvalRecordItem.getTime();
                String approvalResult = approvalRecordItem.getResult();
                approvalHistoryRecord.setType(currentTask.getCategory());
                approvalHistoryRecord.setActivityName(approvalRecordItem.getActivityName());
                if ("thirdComment".equals(approvalRecordItem.getSource()) && WfUtils.isNotEmpty(approvalRecordItem.getSubactivityname())) {
                    approvalHistoryRecord.setActivityName(approvalRecordItem.getSubactivityname());
                }
                approvalHistoryRecord.setSubactivityname(approvalRecordItem.getSubactivityname());
                approvalHistoryRecord.setActivityId(currentTask.getTaskDefinitionKey());
                approvalHistoryRecord.setBusinessKey(currentTask.getBusinessKey());
                approvalHistoryRecord.setEntityNumber(currentTask.getEntityNumber());
                approvalHistoryRecord.setTime(approvalTime);
                approvalHistoryRecord.setResult(approvalResult);
                approvalHistoryRecord.setTaskId(String.valueOf(taskId));
                approvalHistoryRecord.setActivityId(approvalRecordItem.getSubactivityname());
                approvalHistoryRecord.setMessage(approvalRecordItem.getMessage());
                approvalHistoryRecord.setUserId(approvalRecordItem.getUserId());
                approvalHistoryRecord.setSource(approvalRecordItem.getSource());
                approvalRecordItemList.add(approvalHistoryRecord);
            }
        }
    }

    private String getSummaryNames(IdentityLinkEntity participant, String displayInfo, boolean isDisplaySetting) {
        String participantName = "";
        if (WfUtils.isEmpty(displayInfo) && !isDisplaySetting) {
            ILocaleString userName = participant.getUserName();
            ILocaleString trustName = participant.getTrustName();
            participantName = this.getParticipantName(userName, trustName);
        } else {
            ILocaleString userName = participant.getUserNameFormatter();
            ILocaleString trustName = participant.getTrustNameFormat();
            participantName = this.getParticipantName(userName, trustName);
        }
        return participantName;
    }

    private String getParticipantName(ILocaleString userName, ILocaleString trustName) {
        String participantName = "";
        if (WfUtils.isNotEmpty(userName)) {
            participantName = userName.toString();
        }
        if (!WfUtils.isEmpty(trustName)) {
            participantName = TaskDelegateUtil.getDelegateAssigneeName(participantName, trustName.toString(), "entrust");
        }
        return participantName;
    }

    private ApprovalHistoryRecord buildApprovalRecord(ApprovalHistoryRecord record, IdentityLinkEntity participant, Long taskId) {
        String participantName = "";
        ILocaleString userName = participant.getUserNameFormatter();
        if (!WfUtils.isEmpty(userName)) {
            participantName = userName.toString();
        }
        ILocaleString trustName = participant.getTrustNameFormat();
        if (!WfUtils.isEmpty(userName) && !WfUtils.isEmpty(trustName)) {
            participantName = TaskDelegateUtil.getDelegateAssigneeName(userName.toString(), trustName.toString(), "entrust");
            record.setDelegate(true);
        }
        record.setTaskId(String.valueOf(taskId));
        record.setUserId(participant.getUserId());
        record.setAssignee(participantName);
        record.setResult(this.getStateName());
        return record;
    }

    protected String getStateName() {
        return GraphCodecUtils.getHandleStateName(this.procInstId, this.activityId);
    }

    @Override
    public List<ApprovalHistoryRecord> getHistoryRecords(List<IApprovalRecordItem> items) {
        int i;
        ArrayList<IApprovalRecordItem> result = new ArrayList<IApprovalRecordItem>();
        ArrayList<IApprovalRecordItem> trdResult = new ArrayList<IApprovalRecordItem>();
        for (i = 0; i < items.size(); ++i) {
            IApprovalRecordItem approvalRecordItem = items.get(i);
            String source = approvalRecordItem.getSource();
            if ("thirdComment".equals(source)) {
                trdResult.add(approvalRecordItem);
            }
            this.log.debug("ApprovalRecordsProcessHelper.getRecordsInfo:" + approvalRecordItem);
        }
        if (trdResult.size() > 0) {
            this.mergeCurrentRecord(items, result);
        } else {
            for (i = 0; i < items.size(); ++i) {
                if (i == 0) continue;
                result.add(items.get(i));
            }
        }
        return this.getFormattedRecords(result);
    }

    @Override
    public List<ApprovalHistoryRecord> getCurrentHistoryRecords(List<IApprovalRecordItem> items) {
        ArrayList<IApprovalRecordItem> finalApprovalRecordItem = new ArrayList();
        ArrayList<IApprovalRecordItem> trdResult = new ArrayList<IApprovalRecordItem>();
        for (int i = 0; i < items.size(); ++i) {
            IApprovalRecordItem approvalRecordItem = items.get(i);
            String source = approvalRecordItem.getSource();
            if (!"thirdComment".equals(source)) continue;
            trdResult.add(approvalRecordItem);
        }
        if (trdResult.size() > 0) {
            this.mergeCurrentRecord(items, finalApprovalRecordItem);
        } else {
            finalApprovalRecordItem = items;
        }
        return this.getFormattedRecords(finalApprovalRecordItem);
    }

    private void mergeCurrentRecord(List<IApprovalRecordItem> items, List<IApprovalRecordItem> finalApprovalRecordItem) {
        List<HistoricTaskInstanceEntity> hiTasks = this.getHistoryCurrentTasks();
        if (hiTasks.size() > 1) {
            HashMap<String, List<IApprovalRecordItem>> recordMap = new HashMap<String, List<IApprovalRecordItem>>();
            this.groupItemsByTaskId(recordMap, items);
            for (int i = hiTasks.size() - 2; i >= 0; --i) {
                int size;
                HistoricTaskInstanceEntity hiTask = hiTasks.get(i);
                List list = (List)recordMap.get(String.valueOf(hiTask.getId()));
                if (list == null || ((size = list.size()) < 1 || ((IApprovalRecordItem)list.get(0)).getActivityId() == null || !((IApprovalRecordItem)list.get(0)).getActivityId().contains("SSCApprove")) && size < 2) continue;
                IApprovalRecordItem lastItem = (IApprovalRecordItem)list.get(0);
                ApprovalHistoryRecord summaryRecord = new ApprovalHistoryRecord();
                summaryRecord.setActivityName(lastItem.getActivityName());
                summaryRecord.setActivityId(lastItem.getActivityId());
                summaryRecord.setGroupId(lastItem.getTaskId());
                summaryRecord.setTime(lastItem.getTime());
                summaryRecord.setResult(lastItem.getResult());
                finalApprovalRecordItem.add(summaryRecord);
                finalApprovalRecordItem.addAll(list);
            }
        }
    }

    private void groupItemsByTaskId(Map<String, List<IApprovalRecordItem>> recordMap, List<IApprovalRecordItem> items) {
        if (CollectionUtils.isNotEmpty(items)) {
            for (int i = items.size() - 1; i >= 0; --i) {
                IApprovalRecordItem item = items.get(i);
                String taskId = item.getTaskId();
                recordMap.putIfAbsent(taskId, new ArrayList());
                recordMap.get(taskId).add(item);
            }
        }
    }
}

