/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.flowchart;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.workflow.bpmn.model.RPATask;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.ApprovalHistoryRecord;
import kd.bos.workflow.engine.impl.flowchart.AbstractNodeApprovalRecordsProcessor;
import kd.bos.workflow.engine.impl.flowchart.SharedParameters;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.TrdProcRelationEntity;
import kd.bos.workflow.engine.impl.util.RPAUtil;

public class RPANodeProcessor
extends AbstractNodeApprovalRecordsProcessor {
    private String latestRPATaskId;
    private Date latestActInstTime;

    public RPANodeProcessor(SharedParameters parameters) {
        super(parameters);
        this.init(parameters.getProcInstId(), parameters.getActivityId());
    }

    private void init(Long procInstId, String activityId) {
        String fields = String.format("%s,%s", "id", "createDate");
        List<HistoricActivityInstanceEntity> actInsts = this.commandContext.getHistoricActivityInstanceEntityManager().findByActivityId(procInstId, activityId, fields, String.format("%S DESC", "createDate"));
        if (!actInsts.isEmpty()) {
            HistoricActivityInstanceEntity actInst = actInsts.get(0);
            Long actInstId = actInst.getId();
            this.latestActInstTime = actInst.getCreateDate();
            List<TrdProcRelationEntity> relations = this.commandContext.getTrdProcRelationEntityManager().findTrdProcRelationByProcInstIdAndActInstId(procInstId, actInstId);
            if (!relations.isEmpty()) {
                this.latestRPATaskId = relations.get(0).getRelationValue();
            } else {
                this.log.debug(String.format("No TrdProcRelation. %s %s", procInstId, actInstId));
            }
        }
    }

    @Override
    public List<ApprovalHistoryRecord> getLatestRecords(List<IApprovalRecordItem> items) {
        ArrayList<IApprovalRecordItem> result = new ArrayList<IApprovalRecordItem>();
        RPATask rpaTask = (RPATask)this.getCurrentNode();
        if (!items.isEmpty()) {
            String groupId = this.getGroupId(items.get(0));
            for (IApprovalRecordItem item : items) {
                if (groupId != null && groupId.equals(this.getGroupId(item))) {
                    this.addApprovalRecord(result, item);
                    continue;
                }
                break;
            }
        } else {
            result.add(this.createSendStartRPAProcMsgRecord(rpaTask));
        }
        return this.getFormattedRecords(result);
    }

    @Override
    public List<ApprovalHistoryRecord> getCurrentLatestRecords(List<IApprovalRecordItem> items) {
        RPATask rpaTask = (RPATask)this.getCurrentNode();
        ArrayList<IApprovalRecordItem> result = new ArrayList<IApprovalRecordItem>();
        for (IApprovalRecordItem item : items) {
            if (this.latestRPATaskId == null || !this.latestRPATaskId.equals(this.getGroupId(item))) continue;
            this.addApprovalRecord(result, item);
        }
        if (result.isEmpty()) {
            result.add(this.createSendStartRPAProcMsgRecord(rpaTask));
        }
        return this.getFormattedRecords(result);
    }

    @Override
    public List<ApprovalHistoryRecord> getCurrentHistoryRecords(List<IApprovalRecordItem> items) {
        List<IApprovalRecordItem> result = new ArrayList<IApprovalRecordItem>();
        RPATask rpaTask = (RPATask)this.getCurrentNode();
        if (!items.isEmpty()) {
            result = this.getGroupedItems(items, rpaTask, this.latestRPATaskId);
        }
        return this.getFormattedRecords(result);
    }

    @Override
    public List<ApprovalHistoryRecord> getHistoryRecords(List<IApprovalRecordItem> items) {
        List<IApprovalRecordItem> result = new ArrayList<IApprovalRecordItem>();
        RPATask rpaTask = (RPATask)this.getCurrentNode();
        if (!items.isEmpty()) {
            String groupId = this.getGroupId(items.get(0));
            result = this.getGroupedItems(items, rpaTask, groupId);
        }
        return this.getFormattedRecords(result);
    }

    private List<IApprovalRecordItem> getGroupedItems(List<IApprovalRecordItem> items, RPATask rpaTask, String obsoletedGroupId) {
        ArrayList<IApprovalRecordItem> result = new ArrayList<IApprovalRecordItem>(items.size());
        for (IApprovalRecordItem item : items) {
            if (obsoletedGroupId != null && obsoletedGroupId.equals(this.getGroupId(item))) continue;
            this.addApprovalRecord(result, item);
        }
        return result;
    }

    private ApprovalHistoryRecord createSendStartRPAProcMsgRecord(RPATask rpaTask) {
        ApprovalHistoryRecord record = this.createApprovalRecord(rpaTask, this.latestRPATaskId, RPAUtil.getSendStartRPAProcMsgText().getLocaleValue());
        if (this.latestActInstTime != null) {
            record.setTime(WfUtils.parseToUserZoneDateString(this.latestActInstTime));
        }
        return record;
    }

    private ApprovalHistoryRecord createApprovalRecord(RPATask rpaTask, String groupId, String result) {
        ApprovalHistoryRecord record = new ApprovalHistoryRecord();
        record.setGroupId(groupId);
        record.setActivityId(rpaTask.getId());
        record.setActivityName(rpaTask.getName());
        record.setMessage(result);
        this.setRPAApprovalRecordInfo(record);
        return record;
    }

    private void setRPAApprovalRecordInfo(IApprovalRecordItem item) {
        item.setUserStr(RPAUtil.getRobotName().getLocaleValue());
        item.setLinks(RPAUtil.createViewLogLink(item.getGroupId()));
        item.setAvatar(RPAUtil.getRPAApprovalRecordAvatar());
    }

    private void addApprovalRecord(List<IApprovalRecordItem> result, IApprovalRecordItem item) {
        item.setAvatar("");
        this.setRPAApprovalRecordInfo(item);
        result.add(item);
    }

    private String getGroupId(IApprovalRecordItem item) {
        String groupId = item.getGroupId();
        if (groupId == null || "0".equals(groupId)) {
            groupId = item.getCommentId();
        }
        return groupId;
    }
}

