/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.flowchart;

import java.util.HashMap;
import java.util.Map;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.identity.User;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.flowchart.ApproverInfo;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;

public class SharedParameters {
    private Long procInstId;
    private String activityId;
    private Map<Long, ApproverInfo> userMap = new HashMap<Long, ApproverInfo>();
    private Map<String, TaskHandleLogEntity> transferLogMap = new HashMap<String, TaskHandleLogEntity>();
    private Boolean isCancel;

    public SharedParameters(Long procInstId, String activityId, Map<Long, ApproverInfo> userMap, Map<String, TaskHandleLogEntity> transferLogMap) {
        this.procInstId = procInstId;
        this.activityId = activityId;
        this.userMap = userMap;
        this.transferLogMap = transferLogMap;
    }

    public ApproverInfo getUserInfo(Long uid) {
        ApproverInfo user = null;
        if (this.userMap.containsKey(uid)) {
            user = this.userMap.get(uid);
        } else {
            User u = WfUtils.findUserById(uid);
            user = u != null ? new ApproverInfo(uid, u.getImgUrl(), String.valueOf(u.getName()), u.getOpenId()) : new ApproverInfo(uid, null, "", "");
            this.userMap.put(uid, user);
        }
        return user;
    }

    public TaskHandleLogEntity getTaskTranserLog(Long taskId, Long userId) {
        TaskHandleLogEntity transferLog = null;
        String taskIdStr = String.valueOf(taskId);
        if (this.transferLogMap.containsKey(taskIdStr)) {
            transferLog = this.transferLogMap.get(taskIdStr);
        } else {
            transferLog = Context.getCommandContext().getTaskHandleLogEntityManager().getTaskLatestTransferLog(taskId, userId);
            this.transferLogMap.put(this.getTransferKey(taskId, userId), transferLog);
        }
        return transferLog;
    }

    private String getTransferKey(Long taskId, Long userId) {
        return String.format("%s-%s", taskId, userId);
    }

    public Long getProcInstId() {
        return this.procInstId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public Boolean isCancel() {
        return this.isCancel;
    }

    public void setIsCancel(Boolean isCancel) {
        this.isCancel = isCancel;
    }
}

