/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.flowchart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfConstanst;
import kd.bos.workflow.engine.impl.flowchart.BaseTaskHandleRecord;
import kd.bos.workflow.engine.impl.flowchart.TaskHandleRecord;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class TaskHandleRecordsHelper {
    private Log log = LogFactory.getLog(this.getClass());
    private Long taskId;
    private Map<Long, List<TaskHandleLogEntity>> userCoordinateTransferRecords = new HashMap<Long, List<TaskHandleLogEntity>>();

    public TaskHandleRecordsHelper(Long taskId) {
        this.taskId = taskId;
        this.init();
    }

    public final void init() {
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        List<TaskHandleLogEntity> entities = service.getTaskService().getTaskHandleLogs(this.taskId, "coordinate", "transfer");
        if (entities == null || entities.isEmpty()) {
            this.log.debug(String.format("\u4efb\u52a1 %s \u6ca1\u6709\u534f\u529e\u3001\u8f6c\u4ea4\u7c7b\u578b\u7684\u5904\u7406\u8bb0\u5f55\uff01", this.taskId));
            return;
        }
        for (TaskHandleLogEntity entity : entities) {
            TaskHandleRecord taskHandleRecord = new TaskHandleRecord(null);
            taskHandleRecord.setFrom(entity.getOwnerId());
            taskHandleRecord.setTo(entity.getAssigneeid());
            HashSet<Long> handledIds = new HashSet<Long>();
            this.buildRelation(taskHandleRecord, entities, handledIds);
            this.log.debug(String.format("\u4efb\u52a1\u5904\u7406\u94fe\u6784\u5efa\u5b8c\u6bd5\uff1a%s", taskHandleRecord));
            this.initCoordinateTransferRecords(taskHandleRecord);
        }
    }

    private void buildRelation(TaskHandleRecord current, List<TaskHandleLogEntity> entities, Set<Long> handledIds) {
        List<BaseTaskHandleRecord> coordinateRecords;
        Long taskOwner = current.getFrom();
        for (TaskHandleLogEntity entity : entities) {
            if (handledIds.contains(entity.getId()) || (!taskOwner.equals(entity.getOwnerId()) || entity.getOwnerId() == WfConstanst.ADMIN) && (taskOwner != WfConstanst.ADMIN || !entity.getOwnerId().equals(current.getTo()))) continue;
            handledIds.add(entity.getId());
            String type = entity.getType();
            if ("transfer".equals(type)) {
                TaskHandleRecord next = new TaskHandleRecord(entity);
                current.setNext(next);
                if (taskOwner == WfConstanst.ADMIN && entity.getOwnerId().equals(current.getTo())) {
                    current.addCoordinateRecord(new BaseTaskHandleRecord(entity));
                }
                this.buildRelation(next, entities, handledIds);
                break;
            }
            if ("coordinate".equals(type)) {
                current.addCoordinateRecord(new BaseTaskHandleRecord(entity));
                continue;
            }
            this.log.debug("type error! " + type);
        }
        if (!(coordinateRecords = current.getCoordinateRecords()).isEmpty()) {
            Collections.reverse(coordinateRecords);
            for (BaseTaskHandleRecord child : current.getCoordinateRecords()) {
                this.buildCoordinateRelation(child, entities, handledIds);
            }
        }
    }

    private void buildCoordinateRelation(BaseTaskHandleRecord current, List<TaskHandleLogEntity> entities, Set<Long> handledIds) {
        Long userId = current.getTo();
        for (TaskHandleLogEntity entity : entities) {
            if (handledIds.contains(entity.getId()) || !userId.equals(entity.getOwnerId()) || !"transfer".equals(entity.getType()) || !"coordinateTask".equals(entity.getScenes())) continue;
            handledIds.add(entity.getId());
            BaseTaskHandleRecord next = new BaseTaskHandleRecord(entity);
            current.setNext(next);
            this.buildCoordinateRelation(next, entities, handledIds);
        }
    }

    private void initCoordinateTransferRecords(TaskHandleRecord current) {
        List<BaseTaskHandleRecord> coordinateRecords = current.getCoordinateRecords();
        for (BaseTaskHandleRecord coordinate : coordinateRecords) {
            ArrayList<TaskHandleLogEntity> records = new ArrayList<TaskHandleLogEntity>();
            this.statisticsTransferRecords(coordinate, records);
        }
        if (current.getNext() instanceof TaskHandleRecord) {
            this.initCoordinateTransferRecords((TaskHandleRecord)current.getNext());
        }
    }

    private void statisticsTransferRecords(BaseTaskHandleRecord record, List<TaskHandleLogEntity> records) {
        if ("transfer".equals(record.getType())) {
            records.add(record.getEntity());
        }
        if (record.getNext() != null) {
            this.statisticsTransferRecords(record.getNext(), records);
        } else {
            this.userCoordinateTransferRecords.put(record.to, records);
        }
    }

    public List<TaskHandleLogEntity> getUserCoordinateTransferRecord(Long userId) {
        return this.userCoordinateTransferRecords.get(userId);
    }
}

