/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.flowchart;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.flowchart.SharedParameters;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;

public class TransferRecordProcessor {
    private SharedParameters parameters;

    public TransferRecordProcessor(SharedParameters parameters) {
        this.parameters = parameters;
    }

    public void processApprovalRecords(IApprovalRecordItem item) {
        if (WfUtils.isEmpty(item.getTaskId())) {
            return;
        }
        Long taskId = Long.valueOf(item.getTaskId());
        TaskHandleLogEntity transferLog = this.parameters.getTaskTranserLog(taskId, item.getUserId());
        if (item.isDelegate()) {
            QFilter filter4;
            QFilter filter3;
            QFilter participantFilter1 = new QFilter("taskid", "=", (Object)taskId);
            QFilter participantFilter2 = new QFilter("ownerid", "=", (Object)item.getUserId());
            QFilter[] participantFilters = new QFilter[]{participantFilter1, participantFilter2};
            DynamicObjectCollection participants = QueryServiceHelper.query((String)"wf_hiparticipant", (String)"delegateid", (QFilter[])participantFilters);
            ArrayList<Long> delegateIds = new ArrayList<Long>();
            for (DynamicObject participant : participants) {
                delegateIds.add(participant.getLong("delegateid"));
            }
            QFilter filter1 = new QFilter("taskid", "=", (Object)taskId);
            QFilter filter2 = new QFilter("delegateid", "in", delegateIds).and(new QFilter("delegateid", ">=", (Object)0L));
            QFilter[] filters = new QFilter[]{filter1, filter2, filter3 = new QFilter("type", "=", (Object)"transfer"), filter4 = new QFilter("scenes", "!=", (Object)"coordinateTask")};
            DynamicObjectCollection taskHandleLogs = QueryServiceHelper.query((String)"wf_taskhandlelog", (String)"ownerformat,assigneeformat", (QFilter[])filters);
            if (taskHandleLogs != null && !taskHandleLogs.isEmpty()) {
                item.setShowTransferRecord(true);
            }
        }
        if (transferLog != null) {
            item.setShowTransferRecord(true);
        }
        String message = item.getMessage();
        item.setMessage(this.getMessage(message, transferLog));
    }

    protected String getMessage(String message, TaskHandleLogEntity transferLog) {
        if (transferLog != null) {
            message = WfUtils.isEmpty(message) ? "" : message;
            ILocaleString ownerNameILS = transferLog.getOwnerFormat();
            String ownerName = ownerNameILS.getLocaleValue();
            String opinion = transferLog.getOpinion().getLocaleValue();
            if (WfUtils.isNotEmpty(opinion)) {
                return String.format(ResManager.loadKDString((String)"%1$s (%2$s\u4eba\uff1a%3$s\uff0c\u610f\u89c1\uff1a%4$s )", (String)"TransferRecordProcessor_1", (String)"bos-wf-engine", (Object[])new Object[0]), message, WfConfigurationUtil.getTransferName(), ownerName, opinion);
            }
            return String.format(ResManager.loadKDString((String)"%1$s (%2$s\u4eba\uff1a%3$s)", (String)"TransferRecordProcessor_2", (String)"bos-wf-engine", (Object[])new Object[0]), message, WfConfigurationUtil.getTransferName(), ownerName);
        }
        return message;
    }
}

