/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.flowchart;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import kd.bos.workflow.engine.impl.cmd.model.ApprovalHistoryRecord;
import kd.bos.workflow.engine.impl.flowchart.AbstractNodeApprovalRecordsProcessor;
import kd.bos.workflow.engine.impl.flowchart.SharedParameters;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ViewFlowchartUtil;
import kd.bos.workflow.engine.task.TaskDelegateUtil;

public class YunzhijiaNodeProcessor
extends AbstractNodeApprovalRecordsProcessor {
    private Long parentTaskId;
    private static String[] varnames = new String[]{"businessModel", "passPercentage", "passFraction", "showThroughRules", "throughRulesType", "rulesContent", "passType"};
    private DateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public YunzhijiaNodeProcessor(SharedParameters parameters) {
        super(parameters);
        this.initParentTaskId();
    }

    private void initParentTaskId() {
        QFilter[] filters = new QFilter[]{new QFilter("processInstanceId", "=", (Object)this.procInstId), new QFilter("taskDefinitionKey", "=", (Object)this.activityId), new QFilter("parentTaskId", "=", (Object)0)};
        List tasks = this.commandContext.getTaskEntityManager().findByQueryFilters(filters);
        if (tasks != null && !tasks.isEmpty()) {
            this.parentTaskId = ((TaskEntity)tasks.get(0)).getId();
        } else {
            this.parentTaskId = -1L;
            this.log.debug(String.format("parentTaskId is null! procInstId: %s  activityId: %s", this.procInstId, this.activityId));
        }
    }

    @Override
    public List<ApprovalHistoryRecord> getLatestRecords(List<IApprovalRecordItem> items) {
        ArrayList<IApprovalRecordItem> result = new ArrayList<IApprovalRecordItem>();
        List<ApprovalHistoryRecord> records = this.getApprovalHistoryRecords(items);
        String groupId = null;
        boolean hasSummary = false;
        for (ApprovalHistoryRecord record : records) {
            if (WfUtils.isEmpty(record.getUserId())) {
                hasSummary = true;
            }
            this.processSummaryRecords(record);
            if (groupId == null) {
                groupId = record.getGroupId();
            }
            if (groupId != null && !groupId.equals(record.getGroupId())) break;
            result.add(record);
        }
        if (!hasSummary && !this.parameters.isCancel().booleanValue()) {
            result.add(0, this.generateSummaryRecord(this.getCurrentNode()));
        }
        List<ApprovalHistoryRecord> recordsByGroup = this.summaryToTop(this.autoRecordToBackward(this.getFormattedRecords(result)));
        ArrayList<ApprovalHistoryRecord> recordsResult = new ArrayList<ApprovalHistoryRecord>();
        ArrayList<ApprovalHistoryRecord> recordsExcludeSummary = new ArrayList<ApprovalHistoryRecord>();
        if (!recordsByGroup.isEmpty()) {
            for (ApprovalHistoryRecord approvalHistoryRecord : recordsByGroup) {
                if (WfUtils.isEmpty(approvalHistoryRecord.getUserId())) {
                    recordsResult.add(approvalHistoryRecord);
                    continue;
                }
                recordsExcludeSummary.add(approvalHistoryRecord);
            }
        }
        recordsExcludeSummary.sort(new Comparator<ApprovalHistoryRecord>(){

            @Override
            public int compare(ApprovalHistoryRecord arg0, ApprovalHistoryRecord arg1) {
                try {
                    return YunzhijiaNodeProcessor.this.f.parse(arg0.getTime()).compareTo(YunzhijiaNodeProcessor.this.f.parse(arg1.getTime()));
                }
                catch (ParseException e) {
                    YunzhijiaNodeProcessor.this.log.warn(String.format("groupID\u4e3a%s\u7684\u6570\u636e\u6392\u5e8f\u51fa\u9519\u3002\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a%s", arg0.getGroupId(), WfUtils.getExceptionStacktrace(e)));
                    return 0;
                }
            }
        });
        recordsResult.addAll(recordsExcludeSummary);
        return recordsResult;
    }

    @Override
    public List<ApprovalHistoryRecord> getCurrentLatestRecords(List<IApprovalRecordItem> items) {
        ArrayList<IApprovalRecordItem> result = new ArrayList<IApprovalRecordItem>();
        List<ApprovalHistoryRecord> records = this.getApprovalHistoryRecords(items);
        List<HistoricTaskInstanceEntity> tasks = this.getCurrentNodeTasks();
        if (tasks != null && !tasks.isEmpty()) {
            Map<Long, HistoricIdentityLinkEntity> participantsMap = this.getTaskParticipants(tasks);
            YunzhijiaTask yzjTask = this.getCurrentNode();
            ApprovalHistoryRecord summaryRecord = this.generateSummaryRecord(yzjTask);
            result.add(summaryRecord);
            boolean change = true;
            StringBuilder names = new StringBuilder();
            for (HistoricTaskInstanceEntity task : tasks) {
                List<ApprovalHistoryRecord> rets;
                Long taskId = task.getId();
                HistoricIdentityLinkEntity participant = participantsMap.get(taskId);
                String participantName = "";
                ILocaleString userName = participant.getUserNameFormatter();
                if (!WfUtils.isEmpty(userName)) {
                    participantName = userName.toString();
                }
                ILocaleString trustName = participant.getTrustNameFormat();
                if (!WfUtils.isEmpty(userName) && !WfUtils.isEmpty(trustName)) {
                    if (task.getEndTime() == null) {
                        participantName = TaskDelegateUtil.getDelegateAssigneeName(userName.toString(), trustName.toString(), "entrust");
                    } else {
                        participantName = TaskDelegateUtil.getDelegateAssigneeName(userName.toString(), trustName.toString(), "replace");
                        change = false;
                    }
                }
                if (WfUtils.isNotEmpty(participantName)) {
                    names.append(participantName).append('\u3001');
                }
                if ((rets = this.getApprovedRecord(records, taskId)) != null && !rets.isEmpty()) {
                    Long userId = participant.getUserId();
                    boolean approved = false;
                    for (ApprovalHistoryRecord record : rets) {
                        if (!approved && record.getUserId().equals(userId) && "comment".equalsIgnoreCase(record.getType())) {
                            approved = true;
                        }
                        this.addYunzhijiaRecord(result, record);
                    }
                    if (approved || task.getEndTime() != null) continue;
                    ApprovalHistoryRecord record = this.createUnApproveRecord(yzjTask, task, participant);
                    this.addYunzhijiaRecord(result, record);
                    continue;
                }
                ApprovalHistoryRecord record = this.createUnApproveRecord(yzjTask, task, participant);
                this.addYunzhijiaRecord(result, record);
            }
            String teamMembers = ViewFlowchartUtil.getYzjTeamMemberNamesFromVariable(this.parentTaskId, this.commandContext.getProcessEngineConfiguration().getRuntimeService(), yzjTask);
            if (WfUtils.isNotEmpty(teamMembers) && change) {
                summaryRecord.setMessage(this.getSummaryMessage(summaryRecord.getMessage(), teamMembers));
            } else {
                summaryRecord.setMessage(this.getSummaryMessage(summaryRecord.getMessage(), names));
            }
        } else {
            this.log.debug(String.format("The current task is null! %s %s", this.procInstId, this.activityId));
        }
        YunzhijiaTask yzjTask = this.getCurrentNode();
        if (yzjTask.getBehavior() instanceof SequentialMultiInstanceBehavior) {
            return this.getFormattedRecords(result);
        }
        return this.currentUserToFirst(this.autoRecordToBackward(this.getFormattedRecords(result)));
    }

    private ApprovalHistoryRecord generateSummaryRecord(YunzhijiaTask yzjTask) {
        ApprovalHistoryRecord summaryRecord = new ApprovalHistoryRecord();
        summaryRecord.setTaskId(String.valueOf(this.parentTaskId));
        summaryRecord.setActivityName(yzjTask.getName());
        summaryRecord.setMessage(this.getYunzhijiaVoteRule(summaryRecord));
        summaryRecord.setActivityId(yzjTask.getId());
        return summaryRecord;
    }

    private void addYunzhijiaRecord(List<IApprovalRecordItem> result, ApprovalHistoryRecord record) {
        if (!this.canShow(record)) {
            return;
        }
        result.add(record);
    }

    private ApprovalHistoryRecord createUnApproveRecord(YunzhijiaTask yzjTask, HistoricTaskInstanceEntity task, HistoricIdentityLinkEntity participant) {
        Long taskId = task.getId();
        String participantName = "";
        ILocaleString userName = participant.getUserNameFormatter();
        if (!WfUtils.isEmpty(userName)) {
            participantName = userName.toString();
        }
        ILocaleString trustName = participant.getTrustNameFormat();
        if (!WfUtils.isEmpty(userName) && !WfUtils.isEmpty(trustName)) {
            participantName = TaskDelegateUtil.getDelegateAssigneeName(userName.toString(), trustName.toString(), "entrust");
        }
        ApprovalHistoryRecord record = new ApprovalHistoryRecord();
        if (!WfUtils.isEmpty(userName) && !WfUtils.isEmpty(trustName)) {
            participantName = TaskDelegateUtil.getDelegateAssigneeName(userName.toString(), trustName.toString(), "entrust");
            record.setDelegate(true);
        }
        record.setTaskId(String.valueOf(taskId));
        Long userId = participant.getUserId();
        record.setUserId(userId);
        record.setUserStr(String.valueOf(userId));
        record.setBusinessKey(task.getBusinessKey());
        record.setEntityNumber(task.getEntityNumber());
        record.setAssignee(participantName);
        record.setResult(this.getStateName(taskId));
        record.setGroupId(String.valueOf(task.getParentTaskId()));
        record.setActivityId(task.getTaskDefinitionKey());
        record.setBackToBack(yzjTask.getBackToBackVote());
        record.setTime(WfUtils.parseToUserZoneDateString(task.getCreateDate()));
        return record;
    }

    private String getStateName(Long taskId) {
        Long durations = GraphCodecUtils.getDurationsByFilter(this.procInstId, this.activityId, taskId);
        if (durations > 0L) {
            return WFMultiLangConstants.getManualHangUpStateName();
        }
        return WFMultiLangConstants.getDefaultStateName();
    }

    private List<ApprovalHistoryRecord> getApprovedRecord(List<ApprovalHistoryRecord> records, Long taskId) {
        if (WfUtils.isEmpty(taskId)) {
            return null;
        }
        if (records != null) {
            ArrayList<ApprovalHistoryRecord> ret = new ArrayList<ApprovalHistoryRecord>(records.size());
            for (ApprovalHistoryRecord record : records) {
                if (!String.valueOf(taskId).equals(record.getTaskId())) continue;
                ret.add(record);
            }
            return ret;
        }
        return null;
    }

    private boolean canShow(ApprovalHistoryRecord record) {
        return !record.isBackToBack() || this.currentUserId.equals(record.getUserStr());
    }

    @Override
    public List<ApprovalHistoryRecord> getCurrentHistoryRecords(List<IApprovalRecordItem> items) {
        List<ApprovalHistoryRecord> records = this.getFormattedRecords(items);
        ArrayList<ApprovalHistoryRecord> result = new ArrayList<ApprovalHistoryRecord>(records.size());
        String groupId = String.valueOf(this.parentTaskId);
        for (ApprovalHistoryRecord approvalHistoryRecord : records) {
            if (groupId != null && groupId.equals(approvalHistoryRecord.getGroupId())) continue;
            this.processSummaryRecords(approvalHistoryRecord);
            result.add(approvalHistoryRecord);
        }
        HashMap<String, ArrayList<ApprovalHistoryRecord>> recordGroupsMap = new HashMap<String, ArrayList<ApprovalHistoryRecord>>();
        for (ApprovalHistoryRecord approvalHistoryRecord : result) {
            String recordGroupId = approvalHistoryRecord.getGroupId();
            ArrayList<ApprovalHistoryRecord> recordList = (ArrayList<ApprovalHistoryRecord>)recordGroupsMap.get(recordGroupId);
            if (recordList == null) {
                recordList = new ArrayList<ApprovalHistoryRecord>();
                recordGroupsMap.put(recordGroupId, recordList);
            }
            recordList.add(approvalHistoryRecord);
        }
        Set set = recordGroupsMap.entrySet();
        ArrayList<ApprovalHistoryRecord> arrayList = new ArrayList<ApprovalHistoryRecord>(records.size());
        for (Map.Entry recordGroup : set) {
            List recordOneGroup = (List)recordGroup.getValue();
            recordOneGroup.sort(new Comparator<ApprovalHistoryRecord>(){

                @Override
                public int compare(ApprovalHistoryRecord arg0, ApprovalHistoryRecord arg1) {
                    try {
                        return YunzhijiaNodeProcessor.this.f.parse(arg0.getTime()).compareTo(YunzhijiaNodeProcessor.this.f.parse(arg1.getTime()));
                    }
                    catch (ParseException e) {
                        YunzhijiaNodeProcessor.this.log.warn(String.format("groupID\u4e3a%s\u7684\u6570\u636e\u6392\u5e8f\u51fa\u9519\u3002\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a%s", arg0.getGroupId(), WfUtils.getExceptionStacktrace(e)));
                        return 0;
                    }
                }
            });
            arrayList.addAll(this.summaryToTop(this.autoRecordToBackward(recordOneGroup)));
        }
        return arrayList;
    }

    @Override
    public List<ApprovalHistoryRecord> getHistoryRecords(List<IApprovalRecordItem> items) {
        List<ApprovalHistoryRecord> records = this.getFormattedRecords(items);
        ArrayList<ApprovalHistoryRecord> result = new ArrayList<ApprovalHistoryRecord>(records.size());
        String groupId = null;
        for (ApprovalHistoryRecord approvalHistoryRecord : records) {
            if (groupId == null) {
                groupId = approvalHistoryRecord.getGroupId();
            }
            if (groupId != null && groupId.equals(approvalHistoryRecord.getGroupId())) continue;
            this.processSummaryRecords(approvalHistoryRecord);
            result.add(approvalHistoryRecord);
        }
        HashMap<String, ArrayList<ApprovalHistoryRecord>> recordGroupsMap = new HashMap<String, ArrayList<ApprovalHistoryRecord>>();
        for (ApprovalHistoryRecord approvalHistoryRecord : result) {
            String recordGroupId = approvalHistoryRecord.getGroupId();
            ArrayList<ApprovalHistoryRecord> recordList = (ArrayList<ApprovalHistoryRecord>)recordGroupsMap.get(recordGroupId);
            if (recordList == null) {
                recordList = new ArrayList<ApprovalHistoryRecord>();
                recordGroupsMap.put(recordGroupId, recordList);
            }
            recordList.add(approvalHistoryRecord);
        }
        Set set = recordGroupsMap.entrySet();
        ArrayList<ApprovalHistoryRecord> arrayList = new ArrayList<ApprovalHistoryRecord>(records.size());
        for (Map.Entry recordGroup : set) {
            List recordOneGroup = (List)recordGroup.getValue();
            recordOneGroup.sort(new Comparator<ApprovalHistoryRecord>(){

                @Override
                public int compare(ApprovalHistoryRecord arg0, ApprovalHistoryRecord arg1) {
                    try {
                        return YunzhijiaNodeProcessor.this.f.parse(arg0.getTime()).compareTo(YunzhijiaNodeProcessor.this.f.parse(arg1.getTime()));
                    }
                    catch (ParseException e) {
                        YunzhijiaNodeProcessor.this.log.warn(String.format("groupID\u4e3a%s\u7684\u6570\u636e\u6392\u5e8f\u51fa\u9519\u3002\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a%s", arg0.getGroupId(), WfUtils.getExceptionStacktrace(e)));
                        return 0;
                    }
                }
            });
            arrayList.addAll(this.summaryToTop(this.autoRecordToBackward(recordOneGroup)));
        }
        return arrayList;
    }

    private void processSummaryRecords(IApprovalRecordItem item) {
        if (WfUtils.isEmpty(item.getUserId())) {
            item.setMessage(this.getYunzhijiaVoteRule(item));
            String result = "approve".equals(item.getDecisionType()) ? ResManager.loadKDString((String)"\u901a\u8fc7", (String)"YunzhijiaNodeProcessor_0", (String)"bos-wf-engine", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u901a\u8fc7", (String)"YunzhijiaNodeProcessor_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            item.setResult(result);
            item.setAssignee("");
        }
    }

    private String getYunzhijiaVoteRule(IApprovalRecordItem item) {
        String message = null;
        Map<String, HistoricVariableInstanceEntity> varMap = this.commandContext.getHistoricVariableInstanceEntityManager().findHistoricVariableInstancesByTaskIdAndVarNames(Long.valueOf(item.getTaskId()), varnames);
        long processinstanceId = 0L;
        HistoricTaskInstanceEntity hiTaskEntity = (HistoricTaskInstanceEntity)this.commandContext.getHistoricTaskInstanceEntityManager().findById(Long.valueOf(item.getTaskId()));
        if (hiTaskEntity != null) {
            processinstanceId = hiTaskEntity.getProcessInstanceId();
        }
        if (!varMap.isEmpty()) {
            YunzhijiaTask yzjTask = new YunzhijiaTask();
            yzjTask.setBusinessModel(varMap.get("businessModel").getTextValue());
            HistoricVariableInstanceEntity value = varMap.get("passFraction");
            HistoricVariableInstanceEntity valuePassType = varMap.get("passType");
            if (value != null) {
                yzjTask.setPasstype("passByFraction");
                yzjTask.setPassfraction(value.getTextValue());
            } else if (valuePassType != null && "passByAnyOne".equals(valuePassType.getTextValue())) {
                yzjTask.setPasstype("passByAnyOne");
            } else {
                yzjTask.setPasstype("passByPercent");
                value = varMap.get("passPercentage");
                if (value != null) {
                    yzjTask.setPassPercentage(value.getDoubleValue());
                } else {
                    this.log.debug("The variable passPercentage value is null!");
                }
            }
            YunzhijiaTask task = this.getCurrentNode();
            HistoricVariableInstanceEntity showThroughRulesEntity = varMap.get("showThroughRules");
            HistoricVariableInstanceEntity throughRulesTypeEntity = varMap.get("throughRulesType");
            HistoricVariableInstanceEntity rulesContentEntity = varMap.get("rulesContent");
            boolean isShowThroughRules = showThroughRulesEntity == null ? task.isShowThroughRules() : Boolean.parseBoolean(showThroughRulesEntity.getTextValue());
            String throughRulesType = throughRulesTypeEntity == null ? task.getThroughRulesType() : throughRulesTypeEntity.getTextValue();
            String rulesContent = rulesContentEntity == null ? task.getRulesContent() : rulesContentEntity.getTextValue();
            yzjTask.setShowThroughRules(isShowThroughRules);
            yzjTask.setThroughRulesType(throughRulesType);
            yzjTask.setRulesContent(rulesContent);
            message = BpmnModelUtil.getYunzhijiaThroughRules(yzjTask, processinstanceId);
        } else {
            message = BpmnModelUtil.getYunzhijiaThroughRules(this.getCurrentNode(), processinstanceId);
        }
        return message;
    }

    private List<HistoricTaskInstanceEntity> getCurrentNodeTasks() {
        QFilter[] filters = new QFilter[]{new QFilter("parentTaskId", "=", (Object)this.parentTaskId)};
        return this.commandContext.getHistoricTaskInstanceEntityManager().findByQueryFilters(filters);
    }

    private Map<Long, HistoricIdentityLinkEntity> getTaskParticipants(List<HistoricTaskInstanceEntity> tasks) {
        HashSet<Long> ids = new HashSet<Long>(tasks.size());
        for (HistoricTaskInstanceEntity task : tasks) {
            ids.add(task.getId());
        }
        return this.getTaskParticipants(ids);
    }

    private Map<Long, HistoricIdentityLinkEntity> getTaskParticipants(Set<Long> ids) {
        List<HistoricIdentityLinkEntity> entities = this.commandContext.getHistoricIdentityLinkEntityManager().findNotDelegateParticipantsByTaskIdsAndType(this.procInstId, ids, "participant");
        HashMap<Long, HistoricIdentityLinkEntity> ret = new HashMap<Long, HistoricIdentityLinkEntity>(entities.size());
        if (WfUtils.isEmptyForCollection(entities)) {
            return ret;
        }
        for (HistoricIdentityLinkEntity entity : entities) {
            ret.put(entity.getTaskId(), entity);
        }
        return ret;
    }

    private List<ApprovalHistoryRecord> summaryToTop(List<ApprovalHistoryRecord> items) {
        int summary = -1;
        ApprovalHistoryRecord item = null;
        for (int i = 0; i < items.size(); ++i) {
            item = items.get(i);
            if (!"0".equals(String.valueOf(item.getUserId()))) continue;
            summary = i;
            break;
        }
        if (summary > -1) {
            items.remove(summary);
            items.add(0, item);
        }
        return items;
    }

    private List<ApprovalHistoryRecord> autoRecordToBackward(List<ApprovalHistoryRecord> items) {
        ApprovalHistoryRecord item = null;
        ArrayList<ApprovalHistoryRecord> autoAuditRecords = new ArrayList<ApprovalHistoryRecord>(items.size());
        Iterator<ApprovalHistoryRecord> iterator = items.iterator();
        while (iterator.hasNext()) {
            item = iterator.next();
            if (!String.valueOf(-1L).equals(String.valueOf(item.getUserId()))) continue;
            iterator.remove();
            autoAuditRecords.add(item);
        }
        items.addAll(autoAuditRecords);
        return items;
    }

    protected YunzhijiaTask getCurrentNode() {
        return (YunzhijiaTask)super.getCurrentNode();
    }

    @Override
    public boolean filter(List<IApprovalRecordItem> items, ApprovalHistoryRecord current) {
        Long userId = current.getUserId();
        String groupId = current.getGroupId();
        YunzhijiaTask yunzhijia = this.getCurrentNode();
        if ("serialAudit".equals(yunzhijia.getSignType())) {
            return false;
        }
        if (-1L != userId || groupId == null) {
            return false;
        }
        for (IApprovalRecordItem item : items) {
            ApprovalHistoryRecord record = (ApprovalHistoryRecord)item;
            if (!userId.equals(record.getUserId()) || !groupId.equals(record.getGroupId())) continue;
            return true;
        }
        return false;
    }
}

