/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.flowchart.cmd;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.history.GetHistoriableVariableByExecutionCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.flowchart.cmd.GetViewFlowchatDataCmd;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;

public class GetBizViewFlowchatDataCmd
extends GetViewFlowchatDataCmd {
    private Map<String, Object> variables;
    private Boolean isFromMobile;

    public GetBizViewFlowchatDataCmd(HistoricProcessInstanceEntity hisProcInst, Boolean isFromMobile) {
        super(hisProcInst);
        this.isFromMobile = isFromMobile;
    }

    @Override
    protected void initContext() {
        String bootNodeId;
        boolean isBizFlow = ProcessType.BizFlow.name().equals(this.workflowType);
        if (isBizFlow) {
            this.variables = new GetHistoriableVariableByExecutionCmd(this.procInstId, new String[]{"bootNodePrevNodeIds", "bootNodeId"}).execute(Context.getCommandContext());
        }
        super.initContext();
        if (isBizFlow && WfUtils.isNotEmpty(bootNodeId = (String)this.variables.get("bootNodeId"))) {
            this.context.getSkipNodeIds().remove(bootNodeId);
        }
    }

    @Override
    public Map<String, Object> getFlowchartInitData(Long procInstId) {
        Map<String, Object> result = super.getFlowchartInitData(procInstId);
        if (WfUtils.isEmptyForMap(result)) {
            return result;
        }
        if (ProcessType.BizFlow.name().equals(this.workflowType) && !this.isFromMobile.booleanValue()) {
            this.initFloatLayerCellIds(result, procInstId);
        }
        return result;
    }

    @Override
    protected void addSkipNode(HistoricActivityInstanceEntity entity, Map<String, HistoricActivityInstanceEntity> skipNodeActMap, String actId, boolean isFirstUserTask) {
        super.addSkipNode(entity, skipNodeActMap, actId, isFirstUserTask);
        if (isFirstUserTask && ProcessType.BizFlow.name().equals(this.workflowType)) {
            if (this.variables == null || this.variables.isEmpty()) {
                return;
            }
            String prevNodeIds = (String)this.variables.get("bootNodePrevNodeIds");
            if (prevNodeIds != null && prevNodeIds.contains(actId)) {
                skipNodeActMap.put(actId, entity);
            }
        }
    }

    private void initFloatLayerCellIds(Map<String, Object> data, Long procInstId) {
        List<FlowElement> flowElementList;
        if (WfUtils.isNotEmpty(procInstId) && CollectionUtils.isNotEmpty(flowElementList = this.bpmnModel.getMainProcess().getFlowElementList())) {
            ArrayList<String> floatLayerCellIds = new ArrayList<String>(flowElementList.size());
            for (FlowElement flowElement : flowElementList) {
                boolean showFloatLayer = this.isShowFloatLayer(flowElement);
                if (!showFloatLayer) continue;
                floatLayerCellIds.add(flowElement.getId());
            }
            data.put("floatLayerCellIds", floatLayerCellIds);
        }
    }

    private boolean isShowFloatLayer(FlowElement flowElement) {
        String type = flowElement.getType();
        if ("BillTask".equals(type)) {
            BillTask billTask = (BillTask)flowElement;
            if (WfUtils.isEmpty(billTask.getFloatLayerBillSummary())) {
                return false;
            }
            return this.hasNodeActivity(billTask.getEntityNumber(), this.hisActInstEntities);
        }
        if ("UserTask".equals(type)) {
            UserTask userTask = (UserTask)flowElement;
            if (WfUtils.isEmpty(userTask.getFloatLayerBillSummary())) {
                return false;
            }
            return this.hasNodeActivity(userTask.getEntityNumber(), this.hisActInstEntities);
        }
        if ("CallActivity".equals(type)) {
            CallActivity callActivity = (CallActivity)flowElement;
            if (WfUtils.isEmpty(callActivity.getFloatLayerBillSummary())) {
                return false;
            }
            return this.hasNodeActivity(callActivity.getEntityNumber(), this.hisActInstEntities);
        }
        return false;
    }

    private boolean hasNodeActivity(String entityNumber, List<HistoricActivityInstanceEntity> historicActivities) {
        if (WfUtils.isNotEmpty(entityNumber) && CollectionUtils.isNotEmpty(historicActivities)) {
            for (HistoricActivityInstanceEntity historicActivitie : historicActivities) {
                if (!entityNumber.equals(historicActivitie.getEntityNumber())) continue;
                return true;
            }
        }
        return false;
    }
}

