/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.flowchart.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecContext;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.identity.SimpleUserInfo;
import kd.bos.workflow.engine.impl.cmd.GetBpmnModelCmd;
import kd.bos.workflow.engine.impl.cmd.GetParticipantSettingCommentsByProcInstId;
import kd.bos.workflow.engine.impl.cmd.GetProcessHangUpNodeIdsCmd;
import kd.bos.workflow.engine.impl.cmd.GetProcessManualHangUpNodeIdsCmd;
import kd.bos.workflow.engine.impl.cmd.history.GetHistoricActivityInstanceCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.task.TaskDelegateUtil;
import org.dom4j.Element;
import org.dom4j.Node;

public class GetViewFlowchatDataCmd
implements Command<Map<String, Object>> {
    private static Log log = LogFactory.getLog(GetViewFlowchatDataCmd.class);
    public static final String GRAPHXML = "graph_xml";
    public static final String FLOWTYPE = "flowType";
    public static final String TIME = "time";
    public static final String TIPS = "tips";
    protected GraphCodecContext context;
    protected HistoricProcessInstanceEntity hisProcInst;
    protected List<HistoricActivityInstanceEntity> hisActInstEntities;
    protected BpmnModel bpmnModel;
    protected String workflowType;
    protected Long procInstId;

    public GetViewFlowchatDataCmd(HistoricProcessInstanceEntity hisProcInst) {
        this.hisProcInst = hisProcInst;
        if (hisProcInst != null) {
            this.procInstId = hisProcInst.getProcessInstanceId();
            this.workflowType = hisProcInst.getProcessType();
        }
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        if (WfUtils.isNotEmpty(this.procInstId)) {
            return this.getFlowchartInitData(this.procInstId);
        }
        return null;
    }

    public Map<String, Object> getFlowchartInitData(Long procInstId) {
        ArchiveRoute archiveRoute = ArchiveRoute.get();
        log.debug(String.format("ViewWorkflow_ArchiveRoute[%s]", archiveRoute == null ? "null" : archiveRoute.toString()));
        this.hisActInstEntities = new GetHistoricActivityInstanceCmd(procInstId).execute(Context.getCommandContext());
        if (this.hisActInstEntities == null || this.hisActInstEntities.isEmpty()) {
            return null;
        }
        if (this.bpmnModel == null) {
            this.bpmnModel = new GetBpmnModelCmd(null, procInstId).execute(Context.getCommandContext());
        }
        this.context = new GraphCodecContext(this.bpmnModel);
        this.setContextConfig();
        this.context.setProcInstId(procInstId);
        this.collectComments();
        this.context.setHangupNodeIds((Set<String>)new GetProcessHangUpNodeIdsCmd(procInstId).execute(Context.getCommandContext()));
        this.context.setManualHangUpNodeIds((Map<String, String>)new GetProcessManualHangUpNodeIdsCmd(procInstId).execute(Context.getCommandContext()));
        return this.getInitData();
    }

    private void collectComments() {
        CommandContext commandContext = Context.getCommandContext();
        Object comments = new GetParticipantSettingCommentsByProcInstId(this.procInstId, commandContext.getCommentEntityManager().getSelectFields() + "," + "richTextMessage", "id asc").execute(commandContext);
        this.context.setCommentList((List<CommentEntity>)comments);
        this.context.setCommentMap(this.getLatestActComment(this.procInstId));
    }

    protected void setContextConfig() {
        this.context.setViewFlowchart(true);
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("gridEnabled", false);
        this.context.setConfig(config);
    }

    private Map<String, Object> getInitData() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.initContext();
        Node node = GraphCodecUtils.convertBpmnModelToNode(this.bpmnModel, this.context);
        this.adjustNode(node);
        result.put(GRAPHXML, node.asXML());
        if (!this.context.getCurrentNodeIds().isEmpty()) {
            result.put("currentCellId", this.context.getCurrentNodeIds().iterator().next());
        }
        result.put(TIME, String.valueOf(WfUtils.now().getTime()));
        result.put(FLOWTYPE, this.workflowType);
        result.put(TIPS, this.context.getOtherInfo(TIPS));
        return result;
    }

    protected void adjustNode(Node node) {
        this.adjustFlowSequence(node, this.context.getTraversedEdgeIds());
    }

    protected void initContext() {
        CommentEntity comment = null;
        HashMap<String, List<HistoricActivityInstanceEntity>> entityMap = new HashMap<String, List<HistoricActivityInstanceEntity>>();
        int endEventCount = 0;
        int finishEndEvent = 0;
        HashMap<String, HistoricActivityInstanceEntity> skipNodeActMap = new HashMap<String, HistoricActivityInstanceEntity>(16);
        HashMap<String, String> actExecTypeMap = new HashMap<String, String>(1);
        ArrayList<HistoricActivityInstanceEntity> actInsts = null;
        boolean isEnded = this.hisProcInst.getEndTime() != null;
        for (HistoricActivityInstanceEntity entity : this.hisActInstEntities) {
            ILocaleString assignee;
            String actType = entity.getActivityType();
            String actId = entity.getActivityId();
            actInsts = (ArrayList<HistoricActivityInstanceEntity>)entityMap.get(actId);
            if (actInsts == null) {
                actInsts = new ArrayList<HistoricActivityInstanceEntity>();
                entityMap.put(actId, actInsts);
            }
            actInsts.add(entity);
            actExecTypeMap.put(actId, entity.getExecutionType());
            if ("SequenceFlow".equals(actType)) {
                this.context.getTraversedEdgeIds().add(actId);
            } else if (entity.getEndTime() == null && WfUtils.isEmpty(entity.getAssigneeId())) {
                this.context.getCurrentNodeIds().add(actId);
            } else {
                this.context.getTraversedNodeIds().add(actId);
                this.gatherSkipNodes(entity, this.context.getCurrentNodeIds(), skipNodeActMap);
            }
            if ("EndNoneEvent".equals(actType) || "EndTerminateEvent".equals(actType)) {
                ++endEventCount;
                if (entity.getEndTime() != null) {
                    ++finishEndEvent;
                }
            }
            if ((comment = this.context.getCommentMap().get(actId)) == null || entity.getEndTime() == null || !WfUtils.isEmpty(comment.getAssignee()) || (assignee = entity.getAssignee()) == null || !WfUtils.isEmpty(assignee.toString())) continue;
            comment.setAssignee(entity.getAssignee());
        }
        this.context.getSkipNodeIds().addAll(skipNodeActMap.keySet());
        HistoricActivityInstanceEntity entity = null;
        List actEntities = null;
        for (Map.Entry entry : actExecTypeMap.entrySet()) {
            String actId = (String)entry.getKey();
            String execType = (String)entry.getValue();
            if ("cancel".equals(execType)) {
                actEntities = (List)entityMap.get(actId);
                entity = (HistoricActivityInstanceEntity)actEntities.get(0);
                this.context.getTraversedNodeIds().remove(entity.getActivityId());
                this.context.getCanceledNodeIds().add(entity.getActivityId());
                this.context.getCommentMap().remove(entity.getActivityId());
                continue;
            }
            if ("skip".equals(execType) || "jump".equals(execType)) continue;
            actEntities = (List)entityMap.get(actId);
            entity = (HistoricActivityInstanceEntity)actEntities.get(actEntities.size() - 1);
            this.removeSkipNodeIds(this.context, entity, skipNodeActMap);
        }
        if (finishEndEvent > 0 && finishEndEvent == endEventCount && isEnded) {
            this.context.getCurrentNodeIds().clear();
        } else {
            this.context.setCurrentNodeUsersMap(this.getCurrentNodeUsersMap(this.context.getCurrentNodeIds(), entityMap));
            this.context.setCurrentNodeTaskMap(this.getCurrentNodeTaskMap(this.context.getCurrentNodeIds(), entityMap));
        }
    }

    private void removeSkipNodeIds(GraphCodecContext context, HistoricActivityInstanceEntity entity, Map<String, HistoricActivityInstanceEntity> skipNodeActMap) {
        String actType = entity.getActivityType();
        if ("SequenceFlow".equals(actType)) {
            return;
        }
        if ("YunzhijiaTask".equals(actType)) {
            HistoricActivityInstanceEntity skippedAct = skipNodeActMap.get(entity.getActivityId());
            if (skippedAct == null) {
                return;
            }
            if (skippedAct.getParentTaskId() != null && !skippedAct.getParentTaskId().equals(entity.getParentTaskId())) {
                context.getSkipNodeIds().remove(entity.getActivityId());
            }
        } else {
            context.getSkipNodeIds().remove(entity.getActivityId());
        }
    }

    private Map<String, Long> getCurrentNodeTaskMap(Set<String> currentNodeIds, Map<String, List<HistoricActivityInstanceEntity>> entityMap) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        if (currentNodeIds == null || currentNodeIds.isEmpty()) {
            return map;
        }
        List<HistoricActivityInstanceEntity> entities = null;
        for (String nodeId : currentNodeIds) {
            entities = entityMap.get(nodeId);
            for (HistoricActivityInstanceEntity entity : entities) {
                map.put(entity.getActivityId(), WfUtils.isNotEmpty(entity.getParentTaskId()) ? entity.getParentTaskId() : entity.getTaskId());
            }
        }
        return map;
    }

    private Map<String, List<SimpleUserInfo>> getCurrentNodeUsersMap(Set<String> currentNodeIds, Map<String, List<HistoricActivityInstanceEntity>> entityMap) {
        HashMap<String, List<SimpleUserInfo>> map = new HashMap<String, List<SimpleUserInfo>>();
        if (currentNodeIds == null || currentNodeIds.isEmpty()) {
            return map;
        }
        HashMap<Long, String> relation = new HashMap<Long, String>();
        StringBuilder taskIds = new StringBuilder();
        List<HistoricActivityInstanceEntity> entities = null;
        for (String nodeId : currentNodeIds) {
            entities = entityMap.get(nodeId);
            for (HistoricActivityInstanceEntity entity : entities) {
                relation.put(entity.getTaskId(), entity.getActivityId());
                taskIds.append(entity.getTaskId()).append(",");
            }
        }
        if (taskIds.length() > 1) {
            taskIds.deleteCharAt(taskIds.length() - 1);
        }
        Process process = this.bpmnModel.getMainProcess();
        String lang = RequestContext.get().getLang().toString();
        String userNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_participant", "p", "pl", "fusername", "name", "username");
        String userNameFormatSql = WfMultiLangUtils.getGeneralLangSQL("wf_participant", "p", "pl", "fusernameformatter", "usernameformatter", "usernameformatter");
        String trustNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_participant", "p", "pl", "ftrustname", "trustname", "trustname");
        String trusteeNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL("wf_participant", "p", "pl", "ftrustnameformat", "trustnameformat", "trustnameformat");
        StringBuilder sql = new StringBuilder();
        sql.append("select p.fid,fuserid,fprocdefid,ftaskid,").append(userNameSQL).append(",").append(userNameFormatSql).append(",").append(trustNameSQL).append(",").append(trusteeNameFormatSQL);
        sql.append(" from t_wf_participant p left join t_wf_participant_l pl on p.fid = pl.fid and pl.flocaleid = ? ");
        sql.append(String.format(" where ftype = ? and ftaskid in (%s) and p.fdelegateId = 0  order by fid asc", taskIds));
        Object[] params = new Object[]{lang, "participant"};
        boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
        try (DataSet ds = DB.queryDataSet((String)"wf.engine.viewflowchart.getCurrentNodeUsers", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params);){
            Iterator iter = ds.iterator();
            ArrayList<SimpleUserInfo> userIds = null;
            while (iter.hasNext()) {
                UserTask userTask;
                ParticipatantModel participantModel;
                Row row = (Row)iter.next();
                Long userId = row.getLong("fuserid");
                Long taskId = row.getLong("ftaskid");
                String actId = (String)relation.get(taskId);
                userIds = (ArrayList<SimpleUserInfo>)map.get(actId);
                if (userIds == null) {
                    userIds = new ArrayList<SimpleUserInfo>();
                    map.put(actId, userIds);
                }
                String displayInfo = null;
                if (process != null && (participantModel = (userTask = (UserTask)process.getFlowElement(actId)).getParticipant()) != null) {
                    displayInfo = participantModel.getDisplayInfo();
                }
                String userNameFormatter = (String)row.get("usernameformatter");
                String userName = ParticipantHelper.getUserName(row.getString("name"), userNameFormatter);
                if (!isDisplaySetting && WfUtils.isEmpty(displayInfo)) {
                    userName = row.getString("name");
                }
                String trustNameFormat = row.getString("trustnameformat");
                String trustName = ParticipantHelper.getUserName(row.getString("trustname"), trustNameFormat);
                if (!isDisplaySetting && WfUtils.isEmpty(displayInfo)) {
                    trustName = row.getString("trustname");
                }
                if (!WfUtils.isEmpty(trustName)) {
                    userName = TaskDelegateUtil.getDelegateAssigneeName(userName, trustName, "entrust");
                }
                userIds.add(new SimpleUserInfo(userId, userName));
            }
        }
        return map;
    }

    private Map<String, CommentEntity> getLatestActComment(Long procInstId) {
        List<CommentEntity> comments = this.context.getCommentList();
        String yzjTaskNumber = String.format("\\w+%s\\d+$", "YunzhijiaTask");
        HashMap<String, CommentEntity> summaryComment = new HashMap<String, CommentEntity>(16);
        HashMap<String, CommentEntity> latestActComment = new HashMap<String, CommentEntity>(comments.size());
        for (CommentEntity commentEntity : comments) {
            String activityId = commentEntity.getActivityId();
            latestActComment.put(activityId, commentEntity);
            if (!WfUtils.isEmpty(commentEntity.getUserId()) || !activityId.matches(yzjTaskNumber)) continue;
            summaryComment.put(activityId, commentEntity);
        }
        if (!summaryComment.isEmpty()) {
            for (Map.Entry entry : summaryComment.entrySet()) {
                latestActComment.put((String)entry.getKey(), (CommentEntity)entry.getValue());
            }
        }
        return latestActComment;
    }

    protected void gatherSkipNodes(HistoricActivityInstanceEntity entity, Set<String> currentNodeIds, Map<String, HistoricActivityInstanceEntity> skipNodeActMap) {
        String actId = entity.getActivityId();
        if (currentNodeIds.contains(actId)) {
            return;
        }
        boolean isFirstUserTask = false;
        List<UserTask> firstUserTasks = BpmnModelUtil.getFirstUserTasks(this.bpmnModel.getMainProcess());
        for (UserTask firstUserTask : firstUserTasks) {
            if (!actId.equals(firstUserTask.getId())) continue;
            isFirstUserTask = true;
            break;
        }
        this.addSkipNode(entity, skipNodeActMap, actId, isFirstUserTask);
    }

    protected void addSkipNode(HistoricActivityInstanceEntity entity, Map<String, HistoricActivityInstanceEntity> skipNodeActMap, String actId, boolean isFirstUserTask) {
        if (("skip".equals(entity.getExecutionType()) || "jump".equals(entity.getExecutionType())) && !isFirstUserTask) {
            skipNodeActMap.put(actId, entity);
        }
    }

    protected Node adjustFlowSequence(Node node, Set<String> edgeIds) {
        Node element = null;
        Element root = (Element)node.getDocument().getRootElement().selectSingleNode("/mxGraphModel/root");
        String id = null;
        try {
            Iterator<String> iterator = edgeIds.iterator();
            while (iterator.hasNext()) {
                String edgeId;
                id = edgeId = iterator.next();
                element = root.selectSingleNode("mxCell[@id='" + edgeId + "']");
                root.remove(element);
                root.add(element);
            }
        }
        catch (Exception e) {
            FlowElement flowElement = this.bpmnModel.getFlowElement(id);
            String tip = null;
            if (flowElement instanceof SequenceFlow) {
                SequenceFlow flow = (SequenceFlow)flowElement;
                tip = String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4ece\u201c%1$s\u201d\u8282\u70b9\u5230\u201c%2$s\u201d\u8282\u70b9\u7684\u8fde\u7ebf\u201c%3$s\u201d\u3002", (String)"GetViewFlowchatDataCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), flow.getSourceFlowElement().getName(), flow.getTargetFlowElement().getName(), id);
            } else {
                tip = String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230ID\u4e3a\u201c%s\u201d\u7684\u8fde\u7ebf\u3002", (String)"GetViewFlowchatDataCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]), id);
            }
            throw new KDBizException(tip);
        }
        return node;
    }
}

