/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.handler;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.handler.AbstractDeleteDatasByTimeHandler;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public abstract class AbstractDeleteDatasByTimeDirectlyHandler
extends AbstractDeleteDatasByTimeHandler {
    private Log log = LogFactory.getLog(this.getClass());
    protected static final String BATCHCOUNT = "batchCount";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Date executeBatchDelete(CommandContext commandContext, Date startTimeDate, Date endTimeDate, Map<String, Object> valueMap) {
        this.log.debug(String.format("executeBatchDelete,\u8c03\u5ea6\u4efb\u52a1key:[%s]\uff0c\u8d77\u59cb\u65f6\u95f4[%s]\uff0c\u622a\u6b62\u65f6\u95f4[%s]", this.key, startTimeDate, endTimeDate));
        Integer batchCount = this.parameters.containsKey(BATCHCOUNT) ? (Integer)this.parameters.get(BATCHCOUNT) : 1000;
        String sql = WfUtils.isEmpty(this.getDeleteSql()) ? "" : this.getDeleteSql();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(1);
        paramList.add(new Date[]{startTimeDate, endTimeDate});
        try (TXHandle handle = TX.requiresNew();){
            WfDBUtils.executeBatch(sql, paramList, batchCount);
            this.log.debug(String.format("\u8c03\u5ea6\u4efb\u52a1key:[%s]\uff0c\u5220\u9664sql[%s]", this.key, sql));
        }
        return endTimeDate;
    }

    protected abstract String getDeleteSql();
}

