/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public abstract class AbstractDeleteDatasByTimeHandler {
    private Log log = LogFactory.getLog(this.getClass());
    private static final String WFCONFCENTER = "wf_confcenter";
    private static final String VALUE = "value";
    protected static final String VALUE_RETENTIONTIME = "retentionTime";
    protected static final String VALUE_STARTINGTIME = "startingTime";
    protected static final String VALUE_SCOPE = "scope";
    protected static final String VALUE_LOOPTIMES = "loopTimes";
    protected static final String VALUE_LIMITQUANTITY = "limitQuantity";
    protected String key;
    protected Map<String, Object> parameters;

    protected void initValues(String key, Map<String, Object> parameters) {
        this.key = key;
        this.parameters = parameters;
    }

    public String getKey() {
        return this.key;
    }

    public void execute(CommandContext commandContext) {
        String[] startTimeSql = this.getStartTimeSql();
        if (startTimeSql == null || startTimeSql.length != 2 || WfUtils.isEmpty(startTimeSql[0]) || WfUtils.isEmpty(startTimeSql[1])) {
            this.log.debug(String.format("\u8c03\u5ea6\u4efb\u52a1key[%s]\uff0c\u83b7\u53d6\u8d77\u59cb\u65f6\u95f4sql\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5b50\u7c7b\u914d\u7f6e", this.key));
            return;
        }
        Integer initloopTimes = this.parameters.containsKey(VALUE_LOOPTIMES) ? (Integer)this.parameters.get(VALUE_LOOPTIMES) : 1;
        Map<String, Object> valueMap = this.getValue(startTimeSql[0], startTimeSql[1], initloopTimes);
        if (valueMap == null || valueMap.isEmpty()) {
            this.log.debug(String.format("\u8c03\u5ea6\u4efb\u52a1key[%s]\uff0c\u83b7\u53d6\u8d77\u59cb\u65f6\u95f4\u5931\u8d25\uff0c\u6682\u65e0\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u3002", this.key));
            return;
        }
        Long startTimeValue = (Long)valueMap.get(VALUE_STARTINGTIME);
        Integer scopeValue = (Integer)valueMap.get(VALUE_SCOPE);
        Integer retentionTimeValue = (Integer)valueMap.get(VALUE_RETENTIONTIME);
        Integer loopTimesValue = valueMap.containsKey(VALUE_LOOPTIMES) ? (Integer)valueMap.get(VALUE_LOOPTIMES) : initloopTimes;
        Date startTimeDate = new Date(startTimeValue);
        Date endTimeDate = this.getTargetTime(startTimeValue, scopeValue);
        String[] maxDeleteSql = this.getMaxDeleteSql();
        Long timeStamp = null;
        timeStamp = maxDeleteSql == null || maxDeleteSql.length != 2 || WfUtils.isEmpty(maxDeleteSql[0]) || WfUtils.isEmpty(maxDeleteSql[1]) ? Long.valueOf(System.currentTimeMillis()) : this.getMaxDeleteTime(maxDeleteSql[0], maxDeleteSql[1]);
        if (null == timeStamp) {
            this.log.debug(String.format("\u8c03\u5ea6\u4efb\u52a1key[%s]\uff0c\u83b7\u53d6\u4e0d\u5230\u5141\u8bb8\u5220\u9664\u7684\u6700\u5927\u65f6\u95f4\u3002", this.key));
            return;
        }
        Date maxDeleteDate = this.getTargetTime(timeStamp, -retentionTimeValue.intValue());
        this.log.debug(String.format("\u8c03\u5ea6\u4efb\u52a1key:[%s]\u5f00\u59cb\u6267\u884c\uff0c\u8d77\u59cb\u65f6\u95f4[%s]\uff0c\u622a\u6b62\u65f6\u95f4[%s]\uff0c\u672c\u6b21\u5faa\u73af\u6267\u884c\u6b21\u6570[%s]", this.key, startTimeDate, endTimeDate, loopTimesValue));
        for (int loopTime = 1; loopTime <= loopTimesValue; ++loopTime) {
            if (maxDeleteDate.compareTo(endTimeDate) > 0) {
                try {
                    Date newStartTimeDate;
                    startTimeDate = newStartTimeDate = this.executeBatchDelete(commandContext, startTimeDate, endTimeDate, valueMap);
                    endTimeDate = this.getTargetTime(startTimeDate.getTime(), scopeValue);
                    valueMap.put(VALUE_STARTINGTIME, startTimeDate.getTime());
                    this.log.debug(String.format("\u8c03\u5ea6\u4efb\u52a1key[%s]\uff0c\u7b2c[%s]\u6b21\u5faa\u73af\uff0c\u4e0b\u6b21\u8c03\u5ea6\u8d77\u59cb\u65f6\u95f4[%s]", this.key, loopTime, startTimeDate));
                    this.updateValue(this.key, (HashMap)valueMap);
                    continue;
                }
                catch (Exception e) {
                    this.log.warn(String.format("\u8c03\u5ea6\u4efb\u52a1key:[%s]\uff0c\u51fa\u73b0\u5f02\u5e38\u65f6\u95f4\u6bb5[%s]\u5230[%s]\uff0c\u672c\u8c03\u5ea6\u5185\u7b2c[%s]\u6b21\u5faa\u73af\u5220\u9664\u51fa\u9519\uff01\u51fa\u9519\u4fe1\u606f\uff1a[%s]", this.key, startTimeDate, endTimeDate, loopTime, WfUtils.getExceptionStacktrace(e)));
                    break;
                }
            }
            this.log.debug(String.format("\u8c03\u5ea6\u4efb\u52a1key[%s]\uff0c\u672c\u6b21\u5220\u9664\u8c03\u5ea6\u7684\u7b2c[%s]\u6b21\u5faa\u73af\u7684\u65f6\u95f4\u533a\u95f4\u8fdb\u5165\u6570\u636e\u4fdd\u7559\u65f6\u95f4\u533a\u95f4\uff0c\u505c\u6b62\u5220\u9664\uff01\u65f6\u95f4\u533a\u95f4[%s]\u2014\u2014[%s]", this.key, loopTime, startTimeDate, endTimeDate));
            break;
        }
    }

    protected abstract Date executeBatchDelete(CommandContext var1, Date var2, Date var3, Map<String, Object> var4);

    protected abstract String[] getStartTimeSql();

    protected abstract String[] getMaxDeleteSql();

    private Map<String, Object> getValue(String startTimeSql, String findValue, Integer loopTimes) {
        QFilter selectValueFilter = new QFilter("key", "=", (Object)this.key);
        QFilter[] selectValueFilters = new QFilter[]{selectValueFilter};
        DynamicObject value = QueryServiceHelper.queryOne((String)WFCONFCENTER, (String)VALUE, (QFilter[])selectValueFilters);
        if (null == value) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>(4);
            Date startingTime = null;
            try (DataSet ds = DB.queryDataSet((String)"wf.engine.selectHiprocinstTime", (DBRoute)DBRoute.workflow, (String)startTimeSql, null);){
                Iterator iter = ds.iterator();
                if (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    startingTime = row.getDate(findValue);
                }
            }
            if (null == startingTime) {
                return null;
            }
            valueMap.put(VALUE_STARTINGTIME, startingTime.getTime());
            valueMap.put(VALUE_SCOPE, this.parameters.get(VALUE_SCOPE));
            valueMap.put(VALUE_RETENTIONTIME, this.parameters.get(VALUE_RETENTIONTIME));
            valueMap.put(VALUE_LOOPTIMES, loopTimes);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)WFCONFCENTER);
            DynamicObject dynObj = new DynamicObject((DynamicObjectType)mainEntityType);
            dynObj.set("key", (Object)this.key);
            dynObj.set(VALUE, (Object)JSONObject.toJSONString(valueMap));
            DynamicObject[] dynObjs = new DynamicObject[]{dynObj};
            SaveServiceHelper.save((DynamicObject[])dynObjs);
            return valueMap;
        }
        return (Map)SerializationUtils.fromJsonString((String)value.get(VALUE).toString(), Map.class);
    }

    protected Date getTargetTime(Long time, int scope) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        c.add(6, scope);
        return c.getTime();
    }

    private Long getMaxDeleteTime(String sql, String findValue) {
        Date timeStamp = null;
        try (DataSet ds = DB.queryDataSet((String)"wf.engine.CalculateMaximumTime", (DBRoute)DBRoute.workflow, (String)sql, null);){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                timeStamp = row.getDate(findValue);
            }
        }
        if (null == timeStamp) {
            return null;
        }
        return timeStamp.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValue(String key, HashMap<String, Object> valueMap) {
        try (TXHandle handle = TX.requiresNew();){
            QFilter selectValueFilter = new QFilter("key", "=", (Object)key);
            QFilter[] selectValueFilters = new QFilter[]{selectValueFilter};
            DynamicObject value = BusinessDataServiceHelper.loadSingle((String)WFCONFCENTER, (String)"id,value", (QFilter[])selectValueFilters);
            if (value == null) {
                value = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)WFCONFCENTER));
                value.set("key", (Object)key);
            }
            value.set(VALUE, (Object)JSONObject.toJSONString(valueMap));
            DynamicObject[] dynObjs = new DynamicObject[]{value};
            SaveServiceHelper.save((DynamicObject[])dynObjs);
        }
    }
}

