/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.handler;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.handler.AbstractDeleteDatasByTimeHandler;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class DeleteAddressingMsgByEvtLog
extends AbstractDeleteDatasByTimeHandler {
    private Log log = LogFactory.getLog(this.getClass());
    private static final String KEY_DELETEADDRESSINGMSGEVTLOG = "workflow.schedule.deleteAddressingMsgEvtLog";
    private static final String JOBTYPE = "jobtype";
    private static final String TIMESTAMP = "timestamp";
    private static final String BUSINESSKEY = "businesskey";
    private static final String PROCESSINSTANCEID = "processinstanceid";
    private static final String ADDRESS_PROCESS_EVENT = "address-process-event";

    public DeleteAddressingMsgByEvtLog() {
        HashMap<String, Object> parameters = new HashMap<String, Object>(4);
        parameters.put("scope", 3);
        parameters.put("retentionTime", 30);
        parameters.put("loopTimes", 1);
        parameters.put("limitQuantity", 30000);
        this.initValues(KEY_DELETEADDRESSINGMSGEVTLOG, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Date executeBatchDelete(CommandContext commandContext, Date startTimeDate, Date endTimeDate, Map<String, Object> valueMap) {
        Integer initLimitQuantity = this.parameters.containsKey("limitQuantity") ? (Integer)this.parameters.get("limitQuantity") : 30000;
        Integer limitQuantityValue = valueMap.containsKey("limitQuantity") ? (Integer)valueMap.get("limitQuantity") : initLimitQuantity;
        this.log.info(String.format("key:[%s]\uff0c\u6267\u884c\u5148\u67e5\u540e\u5220\uff0c\u65f6\u95f4\u533a\u95f4\uff1a[%s]\u2014\u2014[%s]\uff0c\u67e5\u8be2\u9650\u5236\u6570\u91cf[%s]", this.key, startTimeDate, endTimeDate, limitQuantityValue));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"wf_eventlogentry.deleteAddressingMsgEvtLog", (String)"wf_eventlogentry", (String)"businesskey, timestamp", (QFilter[])this.getFiltersEvtLog(startTimeDate, endTimeDate), (String)"id asc", (int)(limitQuantityValue + 1));){
            HashSet<String> queryResultSet = new HashSet<String>(8);
            Iterator iter = dataSet.iterator();
            int count = 0;
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                queryResultSet.add(row.getString(BUSINESSKEY));
                if (++count != limitQuantityValue) continue;
                Date lastOneDataEndTimeDate = row.getDate(TIMESTAMP);
                if (!iter.hasNext()) continue;
                endTimeDate = lastOneDataEndTimeDate;
                break;
            }
            List<String> params = WfUtils.formatInQueryParam(new ArrayList<Object>(queryResultSet), 200, true);
            String hiProcSql = "SELECT FBUSINESSKEY FROM T_WF_HIPROCINST WHERE FBUSINESSKEY in ";
            HashSet<String> bksHiProReSet = new HashSet<String>(8);
            try (DataSet ds = WfUtils.batchQueryByIn(hiProcSql, params, "batchQueryByIn.hiprocinst.deleteAddressingMsgEvtLog", true);){
                if (ds != null) {
                    iter = ds.iterator();
                    while (iter.hasNext()) {
                        bksHiProReSet.add(((Row)iter.next()).getString("FBUSINESSKEY"));
                    }
                }
            }
            Iterator iterator = queryResultSet.iterator();
            while (iterator.hasNext()) {
                String businessKey = (String)iterator.next();
                if (!bksHiProReSet.contains(businessKey)) continue;
                iterator.remove();
            }
            if (WfUtils.isNotEmptyForCollection(queryResultSet)) {
                ArrayList queryResultList = new ArrayList(queryResultSet);
                Integer batchCount = 500;
                int totalCount = queryResultList.size();
                int j = totalCount % batchCount != 0 ? totalCount / batchCount + 1 : totalCount / batchCount;
                for (int x = 0; x < j; ++x) {
                    int end = (x + 1) * batchCount > totalCount ? totalCount : (x + 1) * batchCount;
                    List<Object> subList = queryResultList.subList(x * batchCount, end);
                    if (null == subList || subList.size() <= 0) continue;
                    try (TXHandle handle = TX.requiresNew();){
                        String batchDeleteSql = "DELETE FROM T_WF_EVTLOG WHERE FBUSINESSKEY in (?) AND FPROCINSTID = 0 AND FJOBTYPE = 'address-process-event';";
                        WfDBUtils.executeBatchDeleteByIn(batchDeleteSql, subList, true);
                        this.log.debug(String.format("key:[%s]\uff0c\u6267\u884c\u67e5\u8be2\u540e\u7684\u5220\u9664\u6210\u529f\uff01\u8868\u540d\uff1at_wf_evtlog", this.key));
                        batchDeleteSql = "DELETE FROM t_wf_hiconditioninst WHERE fbusinesskey in (?);";
                        WfDBUtils.executeBatchDeleteByIn(batchDeleteSql, subList, true);
                        this.log.debug(String.format("key:[%s]\uff0c\u6267\u884c\u67e5\u8be2\u540e\u7684\u5220\u9664\u6210\u529f\uff01\u8868\u540d\uff1at_wf_hiconditioninst", this.key));
                        continue;
                    }
                }
            }
        }
        valueMap.put("limitQuantity", limitQuantityValue);
        return endTimeDate;
    }

    private QFilter[] getFiltersEvtLog(Date startTimeDate, Date endTimeDate) {
        QFilter filter0 = new QFilter(PROCESSINSTANCEID, "=", (Object)0);
        QFilter filter1 = new QFilter(TIMESTAMP, "is not null", null);
        QFilter filter2 = new QFilter(TIMESTAMP, ">=", (Object)startTimeDate);
        QFilter filter3 = new QFilter(TIMESTAMP, "<", (Object)endTimeDate);
        QFilter filter4 = new QFilter(JOBTYPE, "=", (Object)ADDRESS_PROCESS_EVENT);
        return new QFilter[]{filter0, filter1, filter2, filter3, filter4};
    }

    @Override
    protected String[] getStartTimeSql() {
        String startTimeSql = "SELECT MIN(FTIMESTAMP) FTIMESTAMP FROM T_WF_EVTLOG WHERE FPROCINSTID = 0;";
        return new String[]{startTimeSql, "FTIMESTAMP"};
    }

    @Override
    protected String[] getMaxDeleteSql() {
        return null;
    }
}

