/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.handler;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.clean.calculator.CleanDataCalculator;
import kd.bos.workflow.engine.impl.cmd.history.QueryHiParticipantInfoCmd;
import kd.bos.workflow.engine.impl.cmd.job.DeleteMovedDeadLetterJobListener;
import kd.bos.workflow.engine.impl.handler.AbstractDeleteDatasByTimeHandler;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.FailedJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;

public class DeleteClosedJobHandler
extends AbstractDeleteDatasByTimeHandler {
    private Log log = LogFactory.getLog(this.getClass());
    private static final String KEY_DELETECLOSEDJOB = "workflow.schedule.deleteClosedJob";
    private static final String ENDTIME = "endtime";
    private static final String RESULT = "result";

    public DeleteClosedJobHandler() {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("scope", 3);
        parameters.put("retentionTime", 10);
        parameters.put("loopTimes", 1);
        this.initValues(KEY_DELETECLOSEDJOB, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Date executeBatchDelete(CommandContext commandContext, Date startTimeDate, Date endTimeDate, Map<String, Object> valueMap) {
        QFilter filter2;
        QFilter filter1;
        QFilter filter0;
        QFilter[] filters;
        String selectFields = String.format("%s,%s,%s", "businessKey", "id", "processDefinitionId");
        DynamicObjectCollection queryResults = QueryServiceHelper.query((String)"wf_historicalprocesses", (String)selectFields, (QFilter[])(filters = new QFilter[]{filter0 = new QFilter(ENDTIME, "is not null", null), filter1 = new QFilter(ENDTIME, ">=", (Object)startTimeDate), filter2 = new QFilter(ENDTIME, "<", (Object)endTimeDate)}));
        if (null == queryResults || queryResults.isEmpty()) {
            this.log.info(String.format("\u8c03\u5ea6\u4efb\u52a1key:[%s]\uff0c\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684\u4e1a\u52a1ID\uff01", this.key));
            return endTimeDate;
        }
        HashSet<Long> procInstIds = new HashSet<Long>(queryResults.size());
        HashSet<String> idsSet = new HashSet<String>(queryResults.size());
        HashSet<Long> procDefIds = new HashSet<Long>(queryResults.size());
        for (DynamicObject ret : queryResults) {
            idsSet.add((String)ret.get("businessKey"));
            procDefIds.add(ret.getLong("processDefinitionId"));
            procInstIds.add(ret.getLong("id"));
        }
        QFilter filter02 = new QFilter("businessKey", "in", idsSet);
        QFilter filter12 = new QFilter(ENDTIME, "is null", null);
        QFilter[] filters2 = new QFilter[]{filter02, filter12};
        DynamicObjectCollection idsRemove = QueryServiceHelper.query((String)"wf_historicalprocesses", (String)selectFields, (QFilter[])filters2);
        HashSet<String> idsReSet = new HashSet<String>(idsRemove.size());
        HashMap<String, Long> retainMap = new HashMap<String, Long>(idsRemove.size());
        HashMap<String, Long> retainMapInst = new HashMap<String, Long>(idsRemove.size());
        for (DynamicObject dynamicObject : idsRemove) {
            String businessKey = dynamicObject.getString("businessKey");
            idsReSet.add(businessKey);
            retainMap.put(businessKey, dynamicObject.getLong("processDefinitionId"));
            retainMapInst.put(businessKey, dynamicObject.getLong("id"));
        }
        Iterator idsIterator = queryResults.iterator();
        if (!idsReSet.isEmpty()) {
            while (idsIterator.hasNext()) {
                String businessKey = ((DynamicObject)idsIterator.next()).getString("businessKey");
                if (!idsReSet.contains(businessKey)) continue;
                idsIterator.remove();
                procDefIds.remove(retainMap.get(businessKey));
                procInstIds.remove(retainMapInst.get(businessKey));
            }
        }
        int preSize = queryResults.size();
        StringBuilder businesskeys = new StringBuilder();
        HashSet<String> bksQueryResultSet = new HashSet<String>(preSize);
        ArrayList<Long> ids = new ArrayList<Long>(preSize);
        ArrayList<Object[]> idList = new ArrayList<Object[]>(preSize);
        HashSet<Long> idsQueryResultSet = new HashSet<Long>(preSize);
        for (int i = 0; i < preSize; ++i) {
            businesskeys.append('\'').append(((DynamicObject)queryResults.get(i)).get("businessKey")).append('\'').append(',');
            String businesskey = (String)((DynamicObject)queryResults.get(i)).get("businessKey");
            bksQueryResultSet.add(businesskey);
            Long id = ((DynamicObject)queryResults.get(i)).getLong("id");
            idsQueryResultSet.add(id);
            ids.add(id);
            idList.add(new Long[]{id});
        }
        QFilter[] exeConversionFilter = new QFilter[]{new QFilter("procinstid", "in", procInstIds)};
        DynamicObjectCollection exeConversions = QueryServiceHelper.query((String)"bpm_execonversion", (String)String.format("%s,%s,%s", "procinstid", "tagbusinesskey", "srcbusinesskey"), (QFilter[])exeConversionFilter);
        ArrayList<String> bizBusinessKeys = new ArrayList<String>(exeConversions.size());
        for (DynamicObject dyn : exeConversions) {
            String srcPk = dyn.getString("tagbusinesskey");
            String tagPk = dyn.getString("srcbusinesskey");
            if (WfUtils.isNotEmpty(srcPk) && !bizBusinessKeys.contains(srcPk)) {
                bizBusinessKeys.add(srcPk);
            }
            if (!WfUtils.isNotEmpty(tagPk) || bizBusinessKeys.contains(tagPk)) continue;
            bizBusinessKeys.add(tagPk);
        }
        for (String bizBusinessKey : bizBusinessKeys) {
            if (!bksQueryResultSet.add(bizBusinessKey)) continue;
            businesskeys.append('\'').append(bizBusinessKey).append('\'').append(',');
        }
        if (businesskeys.length() > 0) {
            businesskeys.deleteCharAt(businesskeys.length() - 1);
        }
        ArrayList<Object> bksQueryResultList = new ArrayList<Object>(bksQueryResultSet);
        ArrayList<Object> idsQueryResultList = new ArrayList<Object>(idsQueryResultSet);
        if (WfConfigurationUtil.useCleanFrame()) {
            ArrayList<String> businessKeyList = new ArrayList<String>(bksQueryResultSet);
            ArrayList<Long> procInstIdList = new ArrayList<Long>(idsQueryResultSet);
            CleanDataCalculator.create().executeProcessCleaners(commandContext, "retention", businessKeyList, procInstIdList);
        } else {
            this.log.info(String.format("key:[%s]\uff0c\u6e05\u7406closedJob\uff0c\u6267\u884c\u5148\u67e5\u540e\u5220\uff0c\u65f6\u95f4\u533a\u95f4\uff1a[%s]\u2014\u2014[%s]\uff0c\u6570\u636e\u91cf[%s]", this.key, startTimeDate, endTimeDate, ids.size()));
            if (WfUtils.isNotEmptyForCollection(bksQueryResultList)) {
                Integer batchCount = 500;
                int totalCount = bksQueryResultList.size();
                int j = totalCount % batchCount != 0 ? totalCount / batchCount + 1 : totalCount / batchCount;
                for (int x = 0; x < j; ++x) {
                    int end = (x + 1) * batchCount > totalCount ? totalCount : (x + 1) * batchCount;
                    List<Object> subList = bksQueryResultList.subList(x * batchCount, end);
                    if (null == subList || subList.size() <= 0) continue;
                    try (TXHandle handle = TX.requiresNew();){
                        String sql = "DELETE FROM T_WF_EVTLOG WHERE FBUSINESSKEY in (?);";
                        WfDBUtils.executeBatchDeleteByIn(sql, subList, true);
                        sql = "DELETE FROM T_WF_JOBRECORD WHERE FBUSINESSKEY in (?) AND (FSTATE = '" + JobStateEnum.COMPLETED.getNumber() + "' OR FSTATE = '" + JobStateEnum.ERRORED.getNumber() + "');";
                        WfDBUtils.executeBatchDeleteByIn(sql, subList, true);
                        sql = "DELETE FROM T_WF_HIJOBRECORD WHERE FBUSINESSKEY in (?);";
                        WfDBUtils.executeBatchDeleteByIn(sql, subList, true);
                        this.log.info(String.format("key:[%s]\uff0c\u6e05\u7406closedJob\uff0c\u6267\u884c\u67e5\u8be2\u540e\u7684\u5220\u9664\u6210\u529f\uff01\u8868\u540d\uff1at_wf_evtlog, t_wf_jobrecord, t_wf_hijobrecord", this.key));
                        continue;
                    }
                }
            }
            try {
                this.deleteHiuser(idsQueryResultList);
                this.deleteIdempotentInfos(idsQueryResultList);
                this.deleteTimerJobs(commandContext, businesskeys);
                this.deleteDeadLetterJobs(commandContext, businesskeys);
                this.moveWeLinkTodoDataToFailJob(ids);
                this.deleteYzjTodoData(idsQueryResultList);
                this.deleteHiConditionInst(bksQueryResultList);
                this.deleteTaskHandlerLog(idsQueryResultList);
                this.deleteHivarinst(idsQueryResultList);
                this.deleteHiparticipant(commandContext, idList, idsQueryResultList);
            }
            catch (Exception e) {
                this.log.error(String.format("\u5220\u9664\u5e76\u79fb\u52a8Job\u5230FailedJob\u5931\u8d25\uff01\u539f\u56e0\uff1a%s", WfUtils.getExceptionStacktrace(e)));
            }
        }
        try {
            this.deleteProcessInfosAndModelChangeLogs(commandContext, procDefIds);
        }
        catch (Exception e) {
            this.log.error(String.format("\u5220\u9664\u5df2\u7981\u7528\u7684\u975e\u6700\u65b0\u7248\u7684\u65e0\u5728\u9014\u6d41\u7a0b\u7684\u6d41\u7a0b\u4fe1\u606f\u548c\u6a21\u578b\u53d8\u66f4\u8bb0\u5f55\uff01\u539f\u56e0\uff1a%s", WfUtils.getExceptionStacktrace(e)));
        }
        return endTimeDate;
    }

    @Override
    protected String[] getStartTimeSql() {
        String startTimeSql = "SELECT MIN(FENDTIME) FENDTIME FROM T_WF_HIPROCINST;";
        return new String[]{startTimeSql, "FENDTIME"};
    }

    @Override
    protected String[] getMaxDeleteSql() {
        String maxDeleteSql = "SELECT MAX(FENDTIME) FENDTIME FROM T_WF_HIPROCINST;";
        return new String[]{maxDeleteSql, "FENDTIME"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteHiuser(List<Object> procInstIds) {
        try (TXHandle handle = TX.requiresNew();){
            String batchSql = "DELETE from t_wf_hiuseractinst where FPROINSTID in (?);";
            WfDBUtils.executeBatchDeleteByIn(batchSql, procInstIds, 500, true);
            this.log.info(String.format("deleteClosedJob_deleteHiuser\uff0c\u5220\u9664\u6210\u529f\uff01\u8868\u540d\uff1at_wf_hiuseractinst\uff0c\u6570\u636e\u91cf[%s]", procInstIds.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteIdempotentInfos(List<Object> procInstIds) {
        try (TXHandle handle = TX.requiresNew();){
            String sql = "DELETE FROM T_WF_IDEMPOTENT WHERE FINSTANCEID in (?);";
            WfDBUtils.executeBatchDeleteByIn(sql, procInstIds, 500, true);
            this.log.info(String.format("deleteClosedJob_deleteIdempotentInfos\uff0c\u5220\u9664\u6210\u529f\uff01\u8868\u540d\uff1aT_WF_IDEMPOTENT\uff0c\u6570\u636e\u91cf[%s]", procInstIds.size()));
        }
    }

    private void deleteTimerJobs(CommandContext commandContext, StringBuilder ids) {
        if (WfUtils.isEmpty(ids.toString())) {
            return;
        }
        TimerJobEntityManager timerJobManager = commandContext.getTimerJobEntityManager();
        FailedJobEntityManager failedJobManager = commandContext.getFailedJobEntityManager();
        String[] strings = ids.toString().split(",");
        ArrayList<Object> params = new ArrayList<Object>(1000);
        for (int i = 0; i < strings.length; ++i) {
            params.add(strings[i]);
            if ((i + 1) % 1000 != 0) continue;
            this.deletePartTimerJobs(timerJobManager, failedJobManager, params);
            params.clear();
        }
        if (WfUtils.isNotEmptyForCollection(params)) {
            this.deletePartTimerJobs(timerJobManager, failedJobManager, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePartTimerJobs(TimerJobEntityManager timerJobManager, FailedJobEntityManager failedJobManager, List<Object> businessKeys) {
        List<String> params = WfUtils.formatInQueryParam(businessKeys, 200, false);
        String fields = "FID, FBUSINESSKEY, FEXECUTIONID, FPROCESSINSTANCEID, FPROCDEFID, FELEMENTID, FOPERATION, FENTITYNUMBER, FTYPE, FHANDLERTYPE, FHANDLERCFG, FROOTTRACENO, FEXCEPTIONMSG, FCREATEDATE, FBIZTRACENO";
        String sql = "SELECT " + fields + " FROM T_WF_TIMERJOB WHERE FBUSINESSKEY in ";
        try (TXHandle handle = TX.requiresNew();
             DataSet ds = WfUtils.batchQueryByIn(sql, params, "wf.engine.deleteFinishedProcessTimerJobs", true);){
            Iterator iter = ds.iterator();
            Long jobId = null;
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                jobId = row.getLong("FID");
                if (RuntimeUtil.isNeedToRemoveFailedJob(row.getString("FHANDLERTYPE"), row.getString("FHANDLERCFG"))) {
                    failedJobManager.createFailedJobByTimerJob(row);
                }
                timerJobManager.delete(jobId);
            }
            this.log.info(String.format("deleteClosedJob_deleteTimerJobs\uff0c\u5220\u9664\u5e76\u5c06timerJob\u8868\u4e2d\u7684\u6570\u636e\u79fb\u52a8\u5230failedJob\u4e2d\u6267\u884c\u6210\u529f\uff01\u6570\u636e\u91cf[%s]", params.size()));
        }
    }

    private void deleteDeadLetterJobs(CommandContext commandContext, StringBuilder ids) {
        if (WfUtils.isEmpty(ids.toString())) {
            return;
        }
        FailedJobEntityManager failedJobManager = commandContext.getFailedJobEntityManager();
        String[] idArrays = ids.toString().split(",");
        ArrayList<Object> params = new ArrayList<Object>(1000);
        for (int i = 0; i < idArrays.length; ++i) {
            params.add(idArrays[i]);
            if ((i + 1) % 1000 != 0) continue;
            this.deletePartDeadLetterJobs(commandContext, failedJobManager, params);
            params.clear();
        }
        if (WfUtils.isNotEmptyForCollection(params)) {
            this.deletePartDeadLetterJobs(commandContext, failedJobManager, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePartDeadLetterJobs(CommandContext commandContext, FailedJobEntityManager failedJobManager, List<Object> params) {
        try (TXHandle handle = TX.requiresNew();){
            String lang = String.valueOf(RequestContext.get().getLang());
            String fields = "D.FID, D.FBUSINESSKEY, D.FEXECUTIONID, D.FPROCESSINSTANCEID, D.FPROCDEFID, D.FELEMENTID, D.FOPERATION, D.FENTITYNUMBER, D.FTYPE, D.FHANDLERTYPE, D.FHANDLERCFG, D.FSOLUTION, D.FERRORCODE, D.FERRORTYPE, D.FROOTTRACENO, D.FEXCEPTIONMSG, D.FEXCEPTIONSTACKMSG, D.FCREATEDATE, D.FBIZTRACENO, DL.FNAME, DL.FENTRABILLNAME, DL.FSUBJECT, DL.FELEMENTNAME";
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ").append(fields).append(" FROM T_WF_DEADLETTERJOB D ");
            sb.append("INNER JOIN T_WF_DEADLETTERJOB_L DL ON D.FID = DL.FID AND DL.FLOCALEID = ? ");
            sb.append("WHERE D.FBUSINESSKEY IN ");
            List<String> paramsAfterIn = WfUtils.formatInQueryParam(params, 200, false);
            ArrayList<Long> deadLetterJobIds = new ArrayList<Long>();
            try (DataSet ds = WfDBUtils.batchQueryByInWithParams(sb.toString(), paramsAfterIn, "wf.engine.deleteFinishedProcessDeadLetterJobs", new Object[]{lang}, true);){
                if (ds != null) {
                    Iterator iter = ds.iterator();
                    Long jobId = null;
                    while (iter.hasNext()) {
                        Row row = (Row)iter.next();
                        jobId = row.getLong("FID");
                        if (RuntimeUtil.isNeedToRemoveFailedJob(row.getString("FHANDLERTYPE"), row.getString("FHANDLERCFG"))) {
                            failedJobManager.createFailedJobByDeadLetterJob(row);
                        }
                        deadLetterJobIds.add(jobId);
                    }
                }
            }
            if (!deadLetterJobIds.isEmpty()) {
                commandContext.addCloseListener(new DeleteMovedDeadLetterJobListener(deadLetterJobIds.toArray()));
            }
            this.log.info(String.format("deleteClosedJob_deleteDeadLetterJobs\uff0c\u6267\u884c\u6210\u529f\uff01\u6570\u636e\u91cf[%s]", paramsAfterIn.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveWeLinkTodoDataToFailJob(List<Long> ids) {
        int size;
        if (!WfConfigurationUtil.isEnabled("welink")) {
            return;
        }
        TXHandle handle = TX.requiresNew();
        String selectProperties = "id,taskid,procinstid,userid,openid,state,result,retries,corpid,appid,appname,appsecret,modifydate";
        int idsTotal = ids.size();
        int pages = idsTotal % (size = 50) == 0 ? idsTotal / size : idsTotal / size + 1;
        try {
            for (int j = 0; j < pages; ++j) {
                QFilter f3;
                QFilter f2;
                QFilter f4;
                int endIndex = (j + 1) * size > idsTotal ? idsTotal : (j + 1) * size;
                QFilter f1 = new QFilter("procinstid", "in", ids.subList(j * size, endIndex));
                DynamicObject[] targetWelink = BusinessDataServiceHelper.load((String)"msg_welinktodo", (String)selectProperties, (QFilter[])new QFilter[]{f1, f4 = (f2 = new QFilter(RESULT, "=", (Object)"true")).or(f3 = new QFilter(RESULT, "=", (Object)"false").and("retries", "=", (Object)6))});
                if (targetWelink == null || targetWelink.length <= 0) continue;
                ArrayList<Long> successIds = new ArrayList<Long>(targetWelink.length);
                ArrayList<DynamicObject> failJobs = new ArrayList<DynamicObject>(targetWelink.length);
                for (DynamicObject wl : targetWelink) {
                    if (wl.getString(RESULT).equals("false")) {
                        DynamicObject failJob = BusinessDataServiceHelper.newDynamicObject((String)"wf_failedjob");
                        JSONObject config = this.wrapConfig(wl, selectProperties);
                        failJob.set("jobhandlerconfiguration", (Object)config.toJSONString());
                        failJob.set("processinstanceid", (Object)wl.getLong("procinstid"));
                        failJob.set("channeltype", (Object)"welink");
                        failJob.set("createdate", (Object)new Date());
                        failJobs.add(failJob);
                    }
                    successIds.add(wl.getLong("id"));
                }
                if (CollectionUtil.isNotEmpty(successIds)) {
                    DeleteServiceHelper.delete((String)"msg_welinktodo", (QFilter[])new QFilter[]{new QFilter("id", "in", successIds)});
                }
                if (!CollectionUtil.isNotEmpty(failJobs)) continue;
                SaveServiceHelper.save((DynamicObject[])failJobs.toArray(new DynamicObject[0]));
            }
            this.log.info(String.format("deleteClosedJob_moveWeLinkTodoDataToFailJob\uff0c\u6267\u884c\u6210\u529f\uff01\u6570\u636e\u91cf[%s]", ids.size()));
        }
        catch (Exception e) {
            handle.markRollback();
            this.log.info("\u4efb\u52a1\u8c03\u5ea6\u8fc1\u79fbwelinktodo\u6570\u636e\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            handle.close();
        }
    }

    private JSONObject wrapConfig(DynamicObject wl, String fields) {
        JSONObject config = new JSONObject();
        String[] fieldArray = fields.split(",");
        for (int i = 0; i < fieldArray.length; ++i) {
            String field = fieldArray[i];
            config.put(field, (Object)wl.getString(field));
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteYzjTodoData(List<Object> procinstidList) {
        try (TXHandle handle = TX.requiresNew();){
            String sql = "DELETE FROM T_WF_YZJTODO WHERE FPROCINSTID in (?);";
            WfDBUtils.executeBatchDeleteByIn(sql, procinstidList, 500, true);
            this.log.info(String.format("deleteClosedJob_deleteYzjTodoData\uff0c\u6267\u884c\u5220\u9664\u6210\u529f\uff01\u8868\u540d\uff1aT_WF_YZJTODO\uff0c\u6570\u636e\u91cf[%s]", procinstidList.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteHiConditionInst(List<Object> businesskeyList) {
        try (TXHandle handle = TX.requiresNew();){
            String batchSql = "DELETE FROM t_wf_hiconditioninst WHERE fbusinesskey in (?);";
            WfDBUtils.executeBatchDeleteByIn(batchSql, businesskeyList, 500, true);
            this.log.info(String.format("deleteClosedJob_deleteHiConditionInst\uff0c\u6267\u884c\u5220\u9664\u6210\u529f\uff01\u8868\u540d\uff1at_wf_hiconditioninst\uff0c\u6570\u636e\u91cf[%s]", businesskeyList.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTaskHandlerLog(List<Object> procInstIds) {
        try (TXHandle handle = TX.requiresNew();){
            String batchSql = "DELETE FROM t_wf_taskhandlelog WHERE FPROCINSTID in (?);";
            WfDBUtils.executeBatchDeleteByIn(batchSql, procInstIds, 500, true);
            this.log.info(String.format("deleteClosedJob_deleteTaskHandlerLog\uff0c\u6267\u884c\u5220\u9664\u6210\u529f\uff01\u8868\u540d\uff1at_wf_taskhandlelog\uff0c\u6570\u636e\u91cf[%s]", procInstIds.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteHivarinst(List<Object> idList) {
        try (TXHandle handle = TX.requiresNew();){
            String keepFields = WfConfigurationUtil.getKeepFieldsInVariable();
            StringBuilder deleteHivarinstSql = new StringBuilder("DELETE FROM t_wf_hivarinst WHERE FPROCINSTID in (?) and fname not in ( ");
            for (String i : keepFields.split("\\,")) {
                if (!WfUtils.isNotEmpty(i)) continue;
                deleteHivarinstSql.append('\'').append(i).append('\'').append(',');
            }
            if (WfUtils.isNotEmpty(keepFields)) {
                deleteHivarinstSql.deleteCharAt(deleteHivarinstSql.length() - 1);
            }
            deleteHivarinstSql.append(");");
            WfDBUtils.executeBatchDeleteByIn(deleteHivarinstSql.toString(), idList, 500, true);
            this.log.info(String.format("deleteClosedJob_deleteHivarinst\uff0c\u6267\u884c\u5220\u9664\u6210\u529f\uff01\u8868\u540d\uff1at_wf_hivarinst\uff0c\u6570\u636e\u91cf[%s]", idList.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteHiparticipant(CommandContext commandContext, List<Object[]> idList, List<Object> idsQueryResultList) {
        try (TXHandle handle = TX.requiresNew();){
            List ret = (List)new QueryHiParticipantInfoCmd(idList).execute(commandContext);
            ArrayList<Object> retList = new ArrayList<Object>(ret.size());
            for (Object[] objects : ret) {
                retList.add(objects[0]);
            }
            String batchLangSql = "DELETE FROM t_wf_hiparticipant_l WHERE FID in (?);";
            WfDBUtils.executeBatchDeleteByIn(batchLangSql, retList, 500, true);
            this.log.info(String.format("deleteClosedJob_deleteHiparticipant\uff0c\u6267\u884c\u5220\u9664\u6210\u529f\uff01\u8868\u540d\uff1at_wf_hiparticipant_l\uff0c\u6570\u636e\u91cf[%s]", ret.size()));
            String batchSql = "DELETE FROM t_wf_hiparticipant WHERE FPROCINSTID in (?) and FTASKID = 0;";
            WfDBUtils.executeBatchDeleteByIn(batchSql, idsQueryResultList, 500, true);
            this.log.info(String.format("deleteClosedJob_deleteHiparticipant\uff0c\u6267\u884c\u5220\u9664\u6210\u529f\uff01\u8868\u540d\uff1at_wf_hiparticipant\uff0c\u6570\u636e\u91cf[%s]", idsQueryResultList.size()));
        }
    }

    private void deleteProcessInfosAndModelChangeLogs(CommandContext commandContext, Set<Long> procDefIds) {
        if (procDefIds == null || procDefIds.isEmpty()) {
            return;
        }
        try (TXHandle handle = TX.requiresNew();){
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", procDefIds), new QFilter("versionstate", "=", (Object)"historical"), new QFilter("enable", "=", (Object)"disable")};
            List entities = commandContext.getProcessDefinitionEntityManager().findByQueryFilters(filters, "id", null);
            if (entities.isEmpty()) {
                this.log.info("No qualified ProcessDefinitionIds.");
                return;
            }
            HashSet<Long> entityIds = new HashSet<Long>(entities.size());
            for (ProcessDefinitionEntity entity : entities) {
                entityIds.add(entity.getId());
            }
            HashSet<Long> onTheWayIds = new HashSet<Long>(entityIds.size());
            String inParams = WfUtils.listToString(entityIds, ",");
            String sql = String.format("SELECT DISTINCT FPROCDEFID FROM T_WF_EXECUTION WHERE FPROCDEFID IN (%s)", inParams);
            try (DataSet ds = DB.queryDataSet((String)"wf.engine.findOnTheWayProcDefIds", (DBRoute)WfUtils.WFS, (String)sql);){
                for (Row row : ds) {
                    onTheWayIds.add(row.getLong("FPROCDEFID"));
                }
            }
            if (onTheWayIds.isEmpty()) {
                this.deleteProcessInfosAndModelChangeLogs(entityIds);
            } else if (onTheWayIds.size() == entityIds.size()) {
                this.log.info("all ProcessDefinitionIds has Execution.");
            } else {
                Sets.SetView finishedIds = Sets.difference(entityIds, onTheWayIds);
                this.deleteProcessInfosAndModelChangeLogs((Set<Long>)finishedIds);
            }
        }
        catch (Exception e) {
            this.log.error(String.format("delete ProcessInfos and ModelChangeLogs failed. %s", WfUtils.getExceptionStacktrace(e)));
        }
    }

    private void deleteProcessInfosAndModelChangeLogs(Set<Long> procDefIds) {
        ArrayList<Object> ids = new ArrayList<Object>(procDefIds);
        WfDBUtils.executeBatchDeleteByIn("DELETE FROM T_WF_PROCESSINFO WHERE FPROCDEFID in ( ? );", ids, 500, true);
        WfDBUtils.executeBatchDeleteByIn("DELETE FROM T_WF_MODELDATACHANGELOG WHERE FPROCDEFID in ( ? );", ids, 500, true);
    }
}

