/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.handler;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.handler.AbstractDeleteDatasByTimeDirectlyHandler;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class DeleteFailedJobHandler
extends AbstractDeleteDatasByTimeDirectlyHandler {
    private Log log = LogFactory.getLog(this.getClass());
    private static final String KEY_DELETEFAILEDJOB = "workflow.schedule.deletefailedJob";

    public DeleteFailedJobHandler() {
        HashMap<String, Object> parameters = new HashMap<String, Object>(6);
        parameters.put("scope", 3);
        parameters.put("retentionTime", 90);
        parameters.put("loopTimes", 1);
        parameters.put("batchCount", 2000);
        this.initValues(KEY_DELETEFAILEDJOB, parameters);
    }

    @Override
    protected String[] getStartTimeSql() {
        String startTimeSql = "SELECT MIN(FOCCURRENCETIME) FOCCURRENCETIME FROM t_wf_failedjob;";
        return new String[]{startTimeSql, "FOCCURRENCETIME"};
    }

    @Override
    protected String[] getMaxDeleteSql() {
        String maxDeleteSql = "SELECT MAX(FOCCURRENCETIME) FOCCURRENCETIME FROM t_wf_failedjob;";
        return new String[]{maxDeleteSql, "FOCCURRENCETIME"};
    }

    @Override
    protected String getDeleteSql() {
        String deleteSql = "DELETE FROM t_wf_failedjob WHERE FOCCURRENCETIME BETWEEN ? AND ? ;";
        return deleteSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Date executeBatchDelete(CommandContext commandContext, Date startTimeDate, Date endTimeDate, Map<String, Object> valueMap) {
        this.log.debug(String.format("executeBatchDelete,\u8c03\u5ea6\u4efb\u52a1key:[%s]\uff0c\u8d77\u59cb\u65f6\u95f4[%s]\uff0c\u622a\u6b62\u65f6\u95f4[%s]", this.key, startTimeDate, endTimeDate));
        String sql = "SELECT fid id FROM t_wf_failedjob WHERE FOCCURRENCETIME BETWEEN ? AND ? ;";
        ArrayList<Long> ids = new ArrayList<Long>(10);
        try (DataSet ds = DB.queryDataSet((String)"EventJobPlugin", (DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{startTimeDate, endTimeDate});){
            for (Row row : ds) {
                ids.add(row.getLong("id"));
            }
            if (WfUtils.isNotEmptyForCollection(ids)) {
                Integer batchCount = 500;
                int totalCount = ids.size();
                int j = totalCount % batchCount != 0 ? totalCount / batchCount + 1 : totalCount / batchCount;
                for (int x = 0; x < j; ++x) {
                    int end = (x + 1) * batchCount > totalCount ? totalCount : (x + 1) * batchCount;
                    List<Object> subList = ids.subList(x * batchCount, end);
                    if (null == subList || subList.size() <= 0) continue;
                    try (TXHandle handle = TX.requiresNew();){
                        String deleteSql = "DELETE FROM t_wf_failedjob WHERE fid in (?);";
                        WfDBUtils.executeBatchDeleteByIn(deleteSql, subList, true);
                        this.log.debug(String.format("\u8c03\u5ea6\u4efb\u52a1key:[%s]\uff0c\u5220\u9664sql[%s]", this.key, deleteSql));
                        String deleteSqlMulti = "DELETE FROM t_wf_failedjob_l WHERE fid in (?);";
                        WfDBUtils.executeBatchDeleteByIn(deleteSqlMulti, subList, true);
                        this.log.debug(String.format("\u8c03\u5ea6\u4efb\u52a1key:[%s]\uff0c\u5220\u9664sql[%s]", this.key, deleteSqlMulti));
                        continue;
                    }
                }
            }
        }
        return endTimeDate;
    }
}

