/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.history;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.agenda.ForkJoinUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.history.HistoryLevel;
import kd.bos.workflow.engine.impl.history.HistoryManager;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.AbstractManager;
import kd.bos.workflow.engine.impl.persistence.cache.EntityCache;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricConditionRuleInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricDynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricFeedbackEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExeConversionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PathJson;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.FeedbackEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionType;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.service.WfTraceType;

public class DefaultHistoryManager
extends AbstractManager
implements HistoryManager {
    protected static Log log = LogFactory.getLog(DefaultHistoryManager.class);
    private HistoryLevel historyLevel;

    public DefaultHistoryManager(ProcessEngineConfigurationImpl processEngineConfiguration, HistoryLevel historyLevel) {
        super(processEngineConfiguration);
        this.historyLevel = historyLevel;
    }

    @Override
    public boolean isHistoryLevelAtLeast(HistoryLevel level) {
        log.debug(String.format("Current history level: %s, level required: %s", new Object[]{this.historyLevel, level}));
        return this.historyLevel.isAtLeast(level);
    }

    @Override
    public boolean isHistoryEnabled() {
        log.debug("Current history level: " + (Object)((Object)this.historyLevel));
        return this.historyLevel != HistoryLevel.NONE;
    }

    @Override
    public void recordProcessInstanceEnd(Long processInstanceId, String deleteReason, String endType, String activityId) {
        HistoricProcessInstanceEntity historicProcessInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicProcessInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstanceId)) != null) {
            historicProcessInstance.markEnded(deleteReason);
            if (WfUtils.isNotEmpty(endType)) {
                historicProcessInstance.setEndType(endType);
            } else if (WfUtils.isNotEmpty(deleteReason)) {
                endType = DynamicFlowUtil.getEndTypeByDynType(deleteReason);
                historicProcessInstance.setEndType(endType);
            }
            ExecutionEntity processInstance = (ExecutionEntity)this.getExecutionEntityManager().findById(processInstanceId);
            historicProcessInstance.setSubject(processInstance == null || processInstance.getSubject() == null ? null : processInstance.getSubject());
            historicProcessInstance.setEndActivityId(activityId);
        }
    }

    @Override
    public void recordProcessInstanceNameChange(Long processInstanceId, ILocaleString newName) {
        HistoricProcessInstanceEntity historicProcessInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicProcessInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstanceId)) != null) {
            historicProcessInstance.setName(newName);
        }
    }

    @Override
    public void recordProcessInstanceStart(ExecutionEntity processInstance, FlowElement startElement) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricProcessInstanceEntity historicProcessInstance = this.getHistoricProcessInstanceEntityManager().create(processInstance);
            historicProcessInstance.setStartActivityId(startElement.getId());
            historicProcessInstance.setEndType("10");
            this.getHistoricProcessInstanceEntityManager().insert(historicProcessInstance, false);
        }
    }

    @Override
    public void recordSubProcessInstanceStart(ExecutionEntity parentExecution, ExecutionEntity subProcessInstance, FlowElement initialElement) {
        HistoricActivityInstanceEntity activitiyInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (activitiyInstance = this.findActivityInstance(parentExecution, false, true)) != null) {
            activitiyInstance.setCalledProcessInstanceId(subProcessInstance.getProcessInstanceId());
        }
    }

    @Override
    public void recordActivityStart(ExecutionEntity executionEntity) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && executionEntity.getActivityId() != null && executionEntity.getCurrentFlowElement() != null) {
            DynamicResourceEntity dynamicResource;
            HistoricActivityInstanceEntity last;
            CommandContext commandContext = Context.getCommandContext();
            HistoricActivityInstanceEntity historicActivityInstanceEntity = null;
            HistoricActivityInstanceEntity historicActivityInstanceEntityFromCache = this.getHistoricActivityInstanceFromCache(executionEntity.getId(), executionEntity.getActivityId(), true);
            historicActivityInstanceEntity = historicActivityInstanceEntityFromCache != null ? historicActivityInstanceEntityFromCache : this.createHistoricActivityInstanceEntity(executionEntity);
            this.setForkJoinProperties(executionEntity, historicActivityInstanceEntity);
            executionEntity.setCurrentActInstId(historicActivityInstanceEntity.getId());
            executionEntity.setActivityId(executionEntity.getActivityId());
            this.getExecutionEntityManager().update(executionEntity);
            if (executionEntity.getParent() != null && executionEntity.getParent().isMultiInstanceRoot() && !"BoundaryErrorEvent".equals(historicActivityInstanceEntity.getActivityType())) {
                executionEntity.getParent().setCurrentActInstId(historicActivityInstanceEntity.getId());
                this.getExecutionEntityManager().update(executionEntity.getParent());
            }
            if (historicActivityInstanceEntity.getSourceElementId() != null && (last = (HistoricActivityInstanceEntity)this.getHistoricActivityInstanceEntityManager().findById(historicActivityInstanceEntity.getSourceElementId())) != null) {
                FlowElement elem;
                boolean lastActIsJoinNode = false;
                List<HistoricActivityInstanceEntity> list = null;
                if (last.getActivityId() != null && (elem = ProcessDefinitionUtil.getFlowElement(executionEntity.getProcessDefinitionId(), executionEntity.getProcessInstanceId(), last.getActivityId())) instanceof FlowNode && ((FlowNode)elem).getJoin() != null && ((FlowNode)elem).getJoin().booleanValue() && last.getJoinFlag() != null) {
                    lastActIsJoinNode = true;
                    list = this.getHistoricActivityInstanceEntityManager().findByProInstIdAndJoinFlag(executionEntity.getProcessInstanceId(), last.getJoinFlag(), null);
                }
                if (list == null) {
                    boolean manulConversion = this.isBillTaskExitSequenceFlow(executionEntity, last, historicActivityInstanceEntity);
                    boolean autoConversion = this.isBillTaskEntraceSequenceFlow(executionEntity, historicActivityInstanceEntity, last);
                    if (manulConversion || autoConversion) {
                        List<ExeConversionEntity> originals = commandContext.getExeConversionEntityManager().getSourceExeConversionEntities(executionEntity.getProcessInstanceId(), executionEntity.getEntityNumber(), executionEntity.getBusinessKey());
                        if (originals == null || originals.isEmpty()) {
                            list = this.getHistoricActivityInstanceEntityManager().findBySourceId(executionEntity.getProcessInstanceId(), last.getSourceElementId());
                        } else {
                            ArrayList<String> bks = new ArrayList<String>(originals.size());
                            for (ExeConversionEntity ec : originals) {
                                bks.add(ec.getSrcBusinesskey());
                            }
                            if (!bks.contains(last.getBusinessKey())) {
                                bks.add(last.getBusinessKey());
                            }
                            HashSet<String> acts = new HashSet<String>(1);
                            acts.add(last.getActivityId());
                            list = this.getHistoricActivityInstanceEntityManager().findUnTargetBillTaskActInstance(executionEntity.getProcessInstanceId(), acts, bks);
                            if (last.isInserted()) {
                                list.add(0, last);
                            }
                            if (list == null || list.isEmpty()) {
                                list = this.getHistoricActivityInstanceEntityManager().findBySourceId(executionEntity.getProcessInstanceId(), last.getSourceElementId());
                            }
                        }
                    } else {
                        list = this.getHistoricActivityInstanceEntityManager().findBySourceId(executionEntity.getProcessInstanceId(), last.getSourceElementId());
                    }
                }
                for (HistoricActivityInstanceEntity actInst : list) {
                    boolean isSetted;
                    String targetRef;
                    FlowElement elem2;
                    if (BpmnModelUtil.instanceofSequenceFlow(actInst.getActivityType()) && (elem2 = ProcessDefinitionUtil.getFlowElement(executionEntity.getProcessDefinitionId(), executionEntity.getProcessInstanceId(), actInst.getActivityId())) instanceof SequenceFlow && (targetRef = ((SequenceFlow)elem2).getTargetRef()) != null && !historicActivityInstanceEntity.getActivityId().equalsIgnoreCase(targetRef) && !(((SequenceFlow)elem2).getTargetFlowElement() instanceof BillTask) || (isSetted = WfCacheHelper.isSettedTargetActInstId(executionEntity.getProcessInstanceId(), actInst.getId()))) continue;
                    if (lastActIsJoinNode || BpmnModelUtil.instanceofMultiInstanceType(actInst.getActivityType()) || BpmnModelUtil.instanceofSequenceFlow(actInst.getActivityType())) {
                        if (!WfUtils.isEmpty(actInst.getTargetElementId())) continue;
                        actInst.setTargetElementId(historicActivityInstanceEntity.getId());
                        this.updateActTargetIdCache(executionEntity.getProcessInstanceId(), actInst.getId(), historicActivityInstanceEntity.getId());
                        continue;
                    }
                    if (actInst.getExecutionId().longValue() == executionEntity.getId().longValue()) {
                        actInst.setTargetElementId(historicActivityInstanceEntity.getId());
                        this.updateActTargetIdCache(executionEntity.getProcessInstanceId(), actInst.getId(), historicActivityInstanceEntity.getId());
                        continue;
                    }
                    if (!BpmnModelUtil.instanceofBillTask(actInst.getActivityType()) || !WfUtils.isEmpty(actInst.getTargetElementId())) continue;
                    actInst.setTargetElementId(historicActivityInstanceEntity.getId());
                }
            }
            if (executionEntity.getCurrentFlowElement().isDynamic() && (dynamicResource = this.getDynamicResourceEntityManager().findByActivityId(executionEntity.getProcessInstanceId(), executionEntity.getActivityId())) != null && WfUtils.isEmpty(dynamicResource.getActivityInstanceId())) {
                dynamicResource.setActivityInstanceId(historicActivityInstanceEntity.getId());
                HistoricDynamicResourceEntity hisDynResoure = (HistoricDynamicResourceEntity)this.getHistoricDynamicResourceEntityManager().findById(dynamicResource.getId());
                hisDynResoure.setActivityInstanceId(historicActivityInstanceEntity.getId());
            }
            if (!"SequenceFlow".equals(historicActivityInstanceEntity.getActivityType())) {
                List<HiUserActInstEntity> mappers;
                Long executionId = executionEntity.getId();
                if (historicActivityInstanceEntity.getActivityType().equals("YunzhijiaTask")) {
                    executionId = executionEntity.getParentId();
                }
                if ("CallActivity".equals(historicActivityInstanceEntity.getActivityType())) {
                    CallActivity callActivity = (CallActivity)executionEntity.getCurrentFlowElement();
                    String key = ConditionUtil.getConInstKey(callActivity.getNumber(), "skip");
                    ConditionType.logOpDesc(callActivity.getSkipCondition());
                    if (!ConditionUtil.isConditionAvailable(callActivity.getSkipCondition()) || !ConditionUtil.hasTrueCondition(callActivity.getSkipCondition(), (VariableScope)executionEntity, key)) {
                        executionId = executionEntity.getParentId();
                    }
                }
                if ((ProcessType.AuditFlow.name().equals(executionEntity.getProcessType()) || ProcessType.NoCodeFlow.name().equals(executionEntity.getProcessType())) && (mappers = Context.getCommandContext().getHiUserActInstEntityManager().findByCurrentExecutionId(executionId)) != null && !mappers.isEmpty()) {
                    boolean isEnd = historicActivityInstanceEntity.getActivityType().equals("EndNoneEvent") || historicActivityInstanceEntity.getActivityType().equals("EndTerminateEvent");
                    for (HiUserActInstEntity m : mappers) {
                        m.setCurrentActinstId(historicActivityInstanceEntity.getId());
                        m.setTaskId(historicActivityInstanceEntity.getTaskId());
                        if (historicActivityInstanceEntity.getActivityType().equals("YunzhijiaTask")) {
                            m.setCurrentExecutionId(executionId);
                        }
                        m.setJoinFlag(historicActivityInstanceEntity.getJoinFlag());
                        if (isEnd) {
                            m.setEndTime(WfUtils.now());
                        }
                        commandContext.getHiUserActInstEntityManager().batchUpdate(mappers);
                    }
                }
                commandContext.getCirculateRelationEntityManager().updateCriculateRelation(historicActivityInstanceEntity);
            }
        }
    }

    private boolean isBillTaskEntraceSequenceFlow(ExecutionEntity executionEntity, HistoricActivityInstanceEntity current, HistoricActivityInstanceEntity last) {
        String targetRef;
        FlowElement elem;
        boolean firstStep;
        boolean bl = firstStep = BpmnModelUtil.instanceofBillTask(current.getActivityType()) && BpmnModelUtil.instanceofSequenceFlow(last.getActivityType());
        return firstStep && WfUtils.isNotEmpty(last.getActivityId()) && (elem = ProcessDefinitionUtil.getFlowElement(executionEntity.getProcessDefinitionId(), executionEntity.getProcessInstanceId(), last.getActivityId())) instanceof SequenceFlow && WfUtils.isNotEmpty(targetRef = ((SequenceFlow)elem).getTargetRef()) && targetRef.equalsIgnoreCase(current.getActivityId());
    }

    private boolean isBillTaskExitSequenceFlow(ExecutionEntity executionEntity, HistoricActivityInstanceEntity last, HistoricActivityInstanceEntity current) {
        String sourceRef;
        FlowElement elem;
        boolean firstStep;
        boolean bl = firstStep = BpmnModelUtil.instanceofBillTask(last.getActivityType()) && BpmnModelUtil.instanceofSequenceFlow(current.getActivityType());
        return firstStep && WfUtils.isNotEmpty(current.getActivityId()) && (elem = ProcessDefinitionUtil.getFlowElement(executionEntity.getProcessDefinitionId(), executionEntity.getProcessInstanceId(), current.getActivityId())) instanceof SequenceFlow && WfUtils.isNotEmpty(sourceRef = ((SequenceFlow)elem).getSourceRef()) && sourceRef.equalsIgnoreCase(last.getActivityId());
    }

    private void updateActTargetIdCache(final Long processInstanceId, final Long srcActInstId, Long targetActInstId) {
        WfCacheHelper.setTargetActInstId(processInstanceId, srcActInstId, targetActInstId);
        this.getCommandContext().addCloseListener(new DefaultCommandContextCloseListener("updateActTargetId"){

            @Override
            public void closed(CommandContext commandContext) {
                WfCacheHelper.removeTargetActInstId(processInstanceId, srcActInstId);
            }

            @Override
            public void closeFailure(CommandContext commandContext) {
                WfCacheHelper.removeTargetActInstId(processInstanceId, srcActInstId);
            }
        });
    }

    private void setForkJoinProperties(ExecutionEntity executionEntity, HistoricActivityInstanceEntity historicActivityInstanceEntity) {
        if (!"SequenceFlow".equals(historicActivityInstanceEntity.getActivityType())) {
            Process process = ProcessDefinitionUtil.getProcess(executionEntity.getProcessDefinitionId(), executionEntity.getProcessInstanceId());
            FlowNode node = (FlowNode)process.getFlowElement(historicActivityInstanceEntity.getActivityId());
            int comingSize = 0;
            for (SequenceFlow s : node.getIncomingFlows()) {
                if (s.isDynamic()) continue;
                ++comingSize;
            }
            HistoricActivityInstanceEntityManager hisActMgr = Context.getCommandContext().getHistoricActivityInstanceEntityManager();
            Map<String, NodeForkJoinModel> models = process.getForkJoinModels();
            ExecutionEntity proinst = executionEntity.getProcessInstance();
            NodeForkJoinModel model = models.get(node.getId());
            boolean flag = false;
            if (comingSize > 1 && node.getJoin() != null && node.getJoin().booleanValue() && "enterwhenallarrive".equals(node.getInSet())) {
                String forkNodeId = model.getPairForkNodeId();
                int cycle = ForkJoinUtils.getEnterForkCycle(forkNodeId, proinst);
                String joinFlag = forkNodeId + "$" + cycle + "$" + node.getId();
                historicActivityInstanceEntity.setJoinFlag(joinFlag);
                flag = true;
            }
            if (flag) {
                hisActMgr.update(historicActivityInstanceEntity);
            }
        }
    }

    @Override
    public void recordActivityEnd(ExecutionEntity executionEntity, String deleteReason) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricActivityInstanceEntity historicActivityInstance = this.findActivityInstance(executionEntity, false, true);
            this.logger.debug(String.format("record activity end: executionId: %s, actInstId: %s, result: %s", executionEntity.getId(), executionEntity.getCurrentActInstId(), historicActivityInstance != null));
            if (historicActivityInstance != null) {
                if (WfUtils.isNotEmpty(historicActivityInstance.getJoinFlag())) {
                    List<HistoricActivityInstanceEntity> hisActInsts = Context.getCommandContext().getHistoricActivityInstanceEntityManager().findByProInstIdAndJoinFlag(executionEntity.getProcessInstanceId(), historicActivityInstance.getJoinFlag(), executionEntity.getId());
                    for (HistoricActivityInstanceEntity i : hisActInsts) {
                        if (i == null) continue;
                        i.markEnded(deleteReason);
                    }
                } else if (BpmnModelUtil.instanceofBillTask(historicActivityInstance.getActivityType())) {
                    List<HistoricActivityInstanceEntity> list = null;
                    list = this.getHistoricActivityInstanceEntityManager().findBySourceId(executionEntity.getProcessInstanceId(), historicActivityInstance.getSourceElementId());
                    if (list != null) {
                        for (HistoricActivityInstanceEntity actInst : list) {
                            if (!actInst.getId().equals(historicActivityInstance.getId())) {
                                ExecutionEntity exec = (ExecutionEntity)Context.getCommandContext().getExecutionEntityManager().findById(actInst.getExecutionId(), "active");
                                if (exec == null || exec.isActive()) continue;
                                actInst.markEnded(deleteReason);
                                continue;
                            }
                            actInst.markEnded(deleteReason);
                        }
                    }
                } else {
                    historicActivityInstance.markEnded(deleteReason);
                }
            }
        }
    }

    @Override
    public HistoricActivityInstanceEntity findActivityInstance(ExecutionEntity execution, boolean createOnNotFound, boolean endTimeMustBeNull) {
        if (execution.getCurrentActInstId() != null && execution.getCurrentActInstId() > 0L) {
            return (HistoricActivityInstanceEntity)this.getHistoricActivityInstanceEntityManager().findById(execution.getCurrentActInstId());
        }
        this.logger.debug(String.format("execution %s currentActInstId is null!", execution.getId()));
        String activityId = null;
        if (execution.getCurrentFlowElement() instanceof FlowNode) {
            activityId = execution.getCurrentFlowElement().getId();
        } else if (execution.getCurrentFlowElement() instanceof SequenceFlow && execution.getCurrentActivitiListener() == null) {
            activityId = ((SequenceFlow)execution.getCurrentFlowElement()).getSourceFlowElement().getId();
        }
        if (activityId != null) {
            return this.findActivityInstance(execution, activityId, createOnNotFound, endTimeMustBeNull);
        }
        return null;
    }

    public HistoricActivityInstanceEntity findActivityInstance(ExecutionEntity execution, String activityId, boolean createOnNotFound, boolean endTimeMustBeNull) {
        HistoricActivityInstanceEntity historicActivityInstanceFromParent;
        List<HistoricActivityInstanceEntity> historicActivityInstances;
        if (activityId == null) {
            return null;
        }
        Long executionId = execution.getId();
        HistoricActivityInstanceEntity historicActivityInstanceEntityFromCache = this.getHistoricActivityInstanceFromCache(executionId, activityId, endTimeMustBeNull);
        if (historicActivityInstanceEntityFromCache != null) {
            return historicActivityInstanceEntityFromCache;
        }
        if (!execution.isInserted() && !execution.isProcessInstanceType() && (historicActivityInstances = this.getHistoricActivityInstanceEntityManager().findUnfinishedHistoricActivityInstancesByExecutionAndActivityId(executionId, activityId)).size() > 0) {
            return historicActivityInstances.get(0);
        }
        if (execution.getParentId() != null && execution.getParentId() > 0L && (historicActivityInstanceFromParent = this.findActivityInstance(execution.getParent(), activityId, false, endTimeMustBeNull)) != null) {
            return historicActivityInstanceFromParent;
        }
        if (createOnNotFound && activityId != null && (execution.getCurrentFlowElement() != null && execution.getCurrentFlowElement() instanceof FlowNode || execution.getCurrentFlowElement() == null)) {
            return this.createHistoricActivityInstanceEntity(execution);
        }
        return null;
    }

    protected HistoricActivityInstanceEntity getHistoricActivityInstanceFromCache(Long executionId, String activityId, boolean endTimeMustBeNull) {
        List<HistoricActivityInstanceEntity> cachedHistoricActivityInstances = this.getEntityCache().findInCache(HistoricActivityInstanceEntity.class);
        for (HistoricActivityInstanceEntity cachedHistoricActivityInstance : cachedHistoricActivityInstances) {
            if (activityId == null || !activityId.equals(cachedHistoricActivityInstance.getActivityId()) || endTimeMustBeNull && cachedHistoricActivityInstance.getEndTime() != null || !executionId.equals(cachedHistoricActivityInstance.getExecutionId())) continue;
            return cachedHistoricActivityInstance;
        }
        return null;
    }

    @Override
    public HistoricActivityInstanceEntity createHistoricActivityInstanceEntity(ExecutionEntity execution) {
        Object bizTraceNo;
        Long processDefinitionId = execution.getProcessDefinitionId();
        Long processInstanceId = execution.getProcessInstanceId();
        HistoricActivityInstanceEntity historicActivityInstance = (HistoricActivityInstanceEntity)this.getHistoricActivityInstanceEntityManager().create();
        historicActivityInstance.setProcessDefinitionId(processDefinitionId);
        historicActivityInstance.setProcessInstanceId(processInstanceId);
        historicActivityInstance.setExecutionId(execution.getId());
        historicActivityInstance.setActivityId(execution.getActivityId());
        historicActivityInstance.setBusinessKey(execution.getBusinessKey());
        historicActivityInstance.setEntityNumber(execution.getEntityNumber());
        historicActivityInstance.setBillNo(execution.getBillNo());
        historicActivityInstance.setTaskId(execution.getCurrentTaskId());
        if (execution.getCurrentFlowElement() != null) {
            String multiKey = BpmnModelUtil.getActivityNameMultiKey(execution.getActivityId());
            historicActivityInstance.setActivityName(BpmnModelUtil.getMultiLangFieldValue(processInstanceId, multiKey, execution.getCurrentFlowElement().getName()));
            historicActivityInstance.setActivityType(execution.getCurrentFlowElement().getType());
        }
        try {
            Process process = ProcessDefinitionUtil.getProcess(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
            NodeForkJoinModel model = process.getForkJoinModels().get(execution.getActivityId());
            if (model != null) {
                historicActivityInstance.setForkPath(model.getForkStructure());
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        historicActivityInstance.setSourceElementId(execution.getCurrentActInstId());
        FlowElement flowElement = execution.getCurrentFlowElement();
        boolean fromAddInstance = Boolean.TRUE.equals(execution.getVariableLocal("fromAddInstance"));
        if (flowElement instanceof YunzhijiaTask && ("serialAudit".equalsIgnoreCase(((YunzhijiaTask)flowElement).getSignType()) || fromAddInstance) && execution.getParent() != null && execution.getParent().isMultiInstanceRoot()) {
            Long parentTaskId = execution.getParent().getCurrentTaskId();
            QFilter[] filters = new QFilter[]{new QFilter("processInstanceId", "=", (Object)processInstanceId), new QFilter("parenttaskid", "=", (Object)parentTaskId)};
            List hiActInstEntities = this.getHistoricActivityInstanceEntityManager().findByQueryFilters(filters);
            Long sourceElementId = hiActInstEntities == null || hiActInstEntities.isEmpty() ? execution.getCurrentActInstId() : ((HistoricActivityInstanceEntity)hiActInstEntities.get(0)).getSourceElementId();
            this.logger.debug(String.format("createHistoricActivityInstanceEntity processInstanceId is %s;parentTaskId is %s;sourceElementId is %s; execution.getParent().isMultiInstanceRoot() is %s", processInstanceId, parentTaskId, sourceElementId, execution.getParent().isMultiInstanceRoot()));
            historicActivityInstance.setSourceElementId(sourceElementId);
        }
        if ((bizTraceNo = execution.getVariable("biztraceno")) != null) {
            historicActivityInstance.setBizTraceNo(String.valueOf(bizTraceNo));
        }
        this.getHistoricActivityInstanceEntityManager().insert(historicActivityInstance);
        return historicActivityInstance;
    }

    @Override
    public void recordProcessDefinitionChange(Long processInstanceId, Long processDefinitionId) {
        HistoricProcessInstanceEntity historicProcessInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicProcessInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstanceId)) != null) {
            historicProcessInstance.setProcessDefinitionId(processDefinitionId);
        }
    }

    @Override
    public void recordTaskCreated(TaskEntity task, ExecutionEntity execution) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            HistoricTaskInstanceEntity historicTaskInstance = this.getHistoricTaskInstanceEntityManager().create(task, execution);
            historicTaskInstance.setEntityNumber(task.getEntityNumber());
            historicTaskInstance.setBillNo(task.getBillNo());
            historicTaskInstance.setCategory(task.getCategory());
            historicTaskInstance.setEndType(task.getEndType());
            historicTaskInstance.setParticipantName(task.getParticipantName());
            historicTaskInstance.setValidateOperation(task.getValidateOperation());
            historicTaskInstance.setGroupNumber(task.getGroupNumber());
            historicTaskInstance.setBatchOp(task.getBatchOp());
            historicTaskInstance.setOrgUnitId(task.getOrgUnitId());
            historicTaskInstance.setStartNameFormat(task.getStartNameFormat());
            historicTaskInstance.setSenderNameFormat(task.getSenderNameFormat());
            historicTaskInstance.setProcessType(task.getProcessType());
            historicTaskInstance.setSourceName(task.getSourceName());
            historicTaskInstance.setResourceId(task.getResourceId());
            this.getHistoricTaskInstanceEntityManager().insert(historicTaskInstance, false);
        }
        this.recordTaskId(task);
    }

    @Override
    public void recordTaskAssignment(TaskEntity task) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricActivityInstanceEntity historicActivityInstance = Context.getCommandContext().getWithdrawHistActInst(String.valueOf(task.getId()));
            if (historicActivityInstance == null) {
                historicActivityInstance = this.getHistoricActivityInstanceEntityManager().findActivityByTaskId(task.getId());
            }
            if (historicActivityInstance != null) {
                historicActivityInstance.setAssigneeId(task.getAssigneeId());
                historicActivityInstance.setAssignee(task.getTaskAssignee());
            }
        }
    }

    @Override
    public void recordTaskClaim(TaskEntity task) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(task.getId())) != null) {
            historicTaskInstance.setClaimTime(task.getClaimTime());
        }
    }

    @Override
    public void recordTaskId(TaskEntity task) {
        HistoricActivityInstanceEntity historicActivityInstance;
        ExecutionEntity execution;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (execution = task.getExecution()) != null && !execution.isMultiInstanceRoot() && (historicActivityInstance = this.findActivityInstance(execution, false, true)) != null && !"SequenceFlow".equalsIgnoreCase(historicActivityInstance.getActivityType())) {
            String joinFlag = historicActivityInstance.getJoinFlag();
            if (WfUtils.isNotEmpty(joinFlag)) {
                List<HistoricActivityInstanceEntity> es = this.getHistoricActivityInstanceEntityManager().findByProInstIdAndJoinFlag(historicActivityInstance.getProcessInstanceId(), joinFlag, null);
                for (HistoricActivityInstanceEntity e : es) {
                    e.setTaskId(task.getId());
                    this.getHistoricActivityInstanceEntityManager().update(e);
                }
            } else {
                historicActivityInstance.setTaskId(task.getId());
            }
        }
    }

    @Override
    public void recordTaskEnd(Long taskId, String deleteReason) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.markEnded(deleteReason);
            TaskEntity entity = (TaskEntity)this.getTaskEntityManager().findById(taskId);
            if (entity != null) {
                String status = (String)entity.getVariableLocal("auditType");
                String string = status = "forceReject".equals(status) ? "reject" : status;
                if (WfUtils.isNotEmpty(status)) {
                    historicTaskInstance.setHandleState(status);
                } else if ("BillTask".equals(entity.getCategory())) {
                    historicTaskInstance.setHandleState("converted");
                } else if (BpmnModelUtil.instanceofUserTaskOnly(entity.getCategory())) {
                    historicTaskInstance.setHandleState("handled");
                } else if (!entity.getSource().equalsIgnoreCase("wf")) {
                    String auditNumber = (String)entity.getVariableLocal("auditNumber");
                    if ("willApproval".equalsIgnoreCase(auditNumber) || "approve".equalsIgnoreCase(auditNumber) || "handled".equalsIgnoreCase(auditNumber) || "willHandled".equalsIgnoreCase(auditNumber) || "reject".equalsIgnoreCase(auditNumber) || "forceReject".equalsIgnoreCase(auditNumber) || "terminate".equalsIgnoreCase(auditNumber)) {
                        historicTaskInstance.setHandleState(auditNumber);
                    } else {
                        historicTaskInstance.setHandleState("handled");
                    }
                }
                historicTaskInstance.setBatchOp(entity.getBatchOp());
                historicTaskInstance.setCaptionPC(entity.getCaptionPC());
                historicTaskInstance.setCaptionMob(entity.getCaptionMob());
                this.getHistoricTaskInstanceEntityManager().update(historicTaskInstance);
            }
        }
    }

    @Override
    public void recordTaskAssigneeChange(Long taskId, Long assigneeId, ILocaleString assignName) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setAssigneeId(assigneeId);
            historicTaskInstance.setAssignee(assignName);
        }
    }

    @Override
    public void recordTaskOwnerChange(Long taskId, Long ownerId, String owner) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setOwnerId(ownerId);
            historicTaskInstance.setOwner(owner);
        }
    }

    @Override
    public void recordTaskNameChange(Long taskId, String taskName) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setName(taskName);
        }
    }

    @Override
    public void recordTaskDescriptionChange(Long taskId, String description) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setDescription(description);
        }
    }

    @Override
    public void recordTaskDueDateChange(Long taskId, Date dueDate) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setDueDate(dueDate);
        }
    }

    @Override
    public void recordTaskPriorityChange(Long taskId, int priority) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setPriority(priority);
        }
    }

    @Override
    public void recordTaskCategoryChange(Long taskId, String category) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setCategory(category);
        }
    }

    @Override
    public void recordTaskFormKeyChange(Long taskId, String formKey) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setFormKey(formKey);
        }
    }

    @Override
    public void recordTaskParentTaskIdChange(Long taskId, Long parentTaskId) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setParentTaskId(parentTaskId);
            this.getHistoricTaskInstanceEntityManager().update(historicTaskInstance);
            HistoricActivityInstanceEntity historicActivityInstance = this.getHistoricActivityInstanceEntityManager().findActivityByTaskId(taskId);
            if (historicActivityInstance != null) {
                historicActivityInstance.setParentTaskId(parentTaskId);
            }
            List<HistoricIdentityLinkEntity> list = this.getHistoricIdentityLinkEntityManager().findHistoricIdentityLinksByTaskId(taskId);
            for (HistoricIdentityLinkEntity hstoricIdentityLink : list) {
                hstoricIdentityLink.setParenttaskid(parentTaskId);
            }
        }
    }

    @Override
    public void recordTaskExecutionIdChange(Long taskId, Long executionId) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setExecutionId(executionId);
        }
    }

    @Override
    public void recordTaskDefinitionKeyChange(Long taskId, String taskDefinitionKey) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setTaskDefinitionKey(taskDefinitionKey);
        }
    }

    @Override
    public void recordTaskProcessDefinitionChange(Long taskId, Long processDefinitionId) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setProcessDefinitionId(processDefinitionId);
        }
    }

    @Override
    public void recordVariableCreate(VariableInstanceEntity variable) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            this.getHistoricVariableInstanceEntityManager().copyAndInsert(variable);
        }
    }

    @Override
    public void recordVariableUpdate(VariableInstanceEntity variable) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricVariableInstanceEntity historicProcessVariable = this.getEntityCache().findInCache(HistoricVariableInstanceEntity.class, variable.getId());
            if (historicProcessVariable == null) {
                historicProcessVariable = this.getHistoricVariableInstanceEntityManager().findHistoricVariableInstanceByVariableInstanceId(variable.getId());
            }
            if (historicProcessVariable != null) {
                this.getHistoricVariableInstanceEntityManager().copyVariableValue(historicProcessVariable, variable);
            } else {
                this.getHistoricVariableInstanceEntityManager().copyAndInsert(variable);
            }
        }
    }

    @Override
    public void recordIdentityLinkCreated(IdentityLinkEntity identityLink) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (identityLink.getProcessInstanceId() != null || identityLink.getTaskId() != null)) {
            HistoricIdentityLinkEntity historicIdentityLinkEntity = (HistoricIdentityLinkEntity)this.getHistoricIdentityLinkEntityManager().create();
            historicIdentityLinkEntity.setId(identityLink.getId());
            historicIdentityLinkEntity.setProcessInstanceId(identityLink.getProcessInstanceId());
            historicIdentityLinkEntity.setTaskId(identityLink.getTaskId());
            historicIdentityLinkEntity.setType(identityLink.getType());
            historicIdentityLinkEntity.setTaskId(identityLink.getTaskId());
            historicIdentityLinkEntity.setParenttaskid(identityLink.getParenttaskid());
            historicIdentityLinkEntity.setProcessDefId(identityLink.getProcessDefId());
            Long userId = identityLink.getUserId();
            historicIdentityLinkEntity.setUserId(userId);
            historicIdentityLinkEntity.setUserNameFormatter(identityLink.getUserNameFormatter());
            historicIdentityLinkEntity.setUserName(WfUtils.findUserName(userId));
            historicIdentityLinkEntity.setDelegateId(identityLink.getDelegateId());
            historicIdentityLinkEntity.setDisplay(identityLink.isDisplay());
            historicIdentityLinkEntity.setTrustName(identityLink.getTrustName());
            historicIdentityLinkEntity.setCurrenSubject(identityLink.getCurrentSubject());
            historicIdentityLinkEntity.setOwnerId(identityLink.getOwnerId());
            historicIdentityLinkEntity.setTransferOpinion(identityLink.getTransferOpinion());
            this.getHistoricIdentityLinkEntityManager().insert(historicIdentityLinkEntity, false);
        }
    }

    @Override
    public void deleteHistoricIdentityLink(Long id) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            this.getHistoricIdentityLinkEntityManager().delete(id);
        }
    }

    @Override
    public void updateProcessBusinessKeyInHistory(ExecutionEntity processInstance) {
        if (this.isHistoryEnabled() && processInstance != null) {
            log.debug("updateProcessBusinessKeyInHistory : " + processInstance.getId());
            HistoricProcessInstanceEntity historicProcessInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstance.getId());
            if (historicProcessInstance != null) {
                historicProcessInstance.setBusinessKey(processInstance.getProcessInstanceBusinessKey());
                this.getHistoricProcessInstanceEntityManager().update(historicProcessInstance, false);
            }
        }
    }

    @Override
    public void recordVariableRemoved(VariableInstanceEntity variable) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricVariableInstanceEntity historicProcessVariable = this.getEntityCache().findInCache(HistoricVariableInstanceEntity.class, variable.getId());
            if (historicProcessVariable == null) {
                historicProcessVariable = this.getHistoricVariableInstanceEntityManager().findHistoricVariableInstanceByVariableInstanceId(variable.getId());
            }
            if (historicProcessVariable != null) {
                this.getHistoricVariableInstanceEntityManager().delete(historicProcessVariable);
            }
        }
    }

    protected EntityCache getEntityCache() {
        return this.getSession(EntityCache.class);
    }

    public HistoryLevel getHistoryLevel() {
        return this.historyLevel;
    }

    public void setHistoryLevel(HistoryLevel historyLevel) {
        this.historyLevel = historyLevel;
    }

    @Override
    public void recordTaskExecutionTypeChange(Long taskId, String executionType) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setExecutionType(executionType);
        }
    }

    @Override
    public void recordActivityExecutionType(ExecutionEntity executionEntity, String executionType, String skipReason) {
        HistoricActivityInstanceEntity historicActivityInstance;
        if (executionEntity == null) {
            return;
        }
        ILocaleString skipReasonLocale = WfUtils.getPromptWordLocaleString(this.getSkipReason(skipReason), String.format("SkipReason_%s", skipReason), "bos-wf-engine");
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicActivityInstance = this.findActivityInstance(executionEntity, false, true)) != null) {
            String joinFlag = historicActivityInstance.getJoinFlag();
            if (WfUtils.isNotEmpty(joinFlag)) {
                List<HistoricActivityInstanceEntity> es = this.getHistoricActivityInstanceEntityManager().findByProInstIdAndJoinFlag(historicActivityInstance.getProcessInstanceId(), joinFlag, null);
                for (HistoricActivityInstanceEntity e : es) {
                    e.setExecutionType(executionType);
                    if (skipReasonLocale != null && skipReasonLocale.toString() != null) {
                        e.setSkipReason(skipReasonLocale);
                    }
                    this.getHistoricActivityInstanceEntityManager().update(e);
                }
            } else {
                historicActivityInstance.setExecutionType(executionType);
                if (skipReasonLocale != null && skipReasonLocale.toString() != null) {
                    historicActivityInstance.setSkipReason(skipReasonLocale);
                }
                this.getHistoricActivityInstanceEntityManager().update(historicActivityInstance);
            }
            if (DynamicFlowUtil.isTerminalSkipReason(skipReason)) {
                QFilter filter = new QFilter("processInstanceId", "=", (Object)historicActivityInstance.getProcessInstanceId());
                QFilter timeFilter = new QFilter("endTime", "is null", null);
                List entitys = this.getHistoricActivityInstanceEntityManager().findByQueryFilters(new QFilter[]{filter, timeFilter});
                for (HistoricActivityInstanceEntity i : entitys) {
                    i.setExecutionType(executionType);
                    i.setSkipReason(skipReasonLocale);
                    this.getHistoricActivityInstanceEntityManager().update(i);
                }
            }
        }
    }

    private String getSkipReason(String skipReason) {
        if (skipReason == null) {
            return " ";
        }
        HashMap<String, String> skip = new HashMap<String, String>(18);
        switch (skipReason) {
            case "FirstUserTask": {
                skip.put(skipReason, ResManager.loadKDString((String)"\u7b2c\u4e00\u4e2a\u4eba\u5de5\u4efb\u52a1", (String)"DefaultHistoryManager_19", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "nonBootNode": {
                skip.put(skipReason, ResManager.loadKDString((String)"\u975e\u542f\u52a8\u8282\u70b9\u8df3\u8fc7", (String)"DefaultHistoryManager_32", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "bootNode": {
                skip.put(skipReason, ResManager.loadKDString((String)"\u542f\u52a8\u8282\u70b9\u8df3\u8fc7", (String)"DefaultHistoryManager_33", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "MeetSkipCondition": {
                skip.put(skipReason, ResManager.loadKDString((String)"\u6ee1\u8db3\u5ffd\u7565\u6761\u4ef6", (String)"DefaultHistoryManager_20", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "NoParticipant": {
                skip.put(skipReason, ResManager.loadKDString((String)"\u65e0\u53c2\u4e0e\u4eba\u4e14\u8282\u70b9\u914d\u7f6e\u5141\u8bb8\u65e0\u53c2\u4e0e\u4eba\u3002", (String)"DefaultHistoryManager_21", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "SameParticipant": {
                skip.put(skipReason, ResManager.loadKDString((String)"\u524d\u5e8f\u8282\u70b9\u76f8\u540c\u53c2\u4e0e\u4eba\u5df2\u5ba1\u6279\u3002", (String)"DefaultHistoryManager_22", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "DynamicJump": {
                skip.put(skipReason, ResManager.loadKDString((String)"\u52a8\u6001\u8df3\u8fc7", (String)"DefaultHistoryManager_23", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "ForceAbort": {
                skip.put(skipReason, ResManager.loadKDString((String)"\u5f3a\u5236\u7ec8\u6b62", (String)"DefaultHistoryManager_24", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "ParentProcessAbort": {
                skip.put(skipReason, WFMultiLangConstants.getParentProcessAbortText().getLocaleValue());
                break;
            }
            case "ParentProcessJump": {
                skip.put(skipReason, WFMultiLangConstants.getParentProcessJumpText().getLocaleValue());
                break;
            }
            case "parentProcessWithdraw": {
                skip.put(skipReason, WFMultiLangConstants.getParentProcessWithdrawText().getLocaleValue());
                break;
            }
            case "PersonJump": {
                skip.put(skipReason, ResManager.loadKDString((String)"\u4eba\u5de5\u8df3\u8f6c", (String)"DefaultHistoryManager_25", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "ExpireSkip": {
                skip.put(skipReason, ResManager.loadKDString((String)"\u8fc7\u671f\u8df3\u8fc7", (String)"DefaultHistoryManager_26", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "AUTOAUDIT": {
                skip.put(skipReason, ResManager.loadKDString((String)"\u81ea\u52a8\u5ba1\u6279", (String)"DefaultHistoryManager_27", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "FROZEN": {
                skip.put(skipReason, ResManager.loadKDString((String)"\u51bb\u7ed3", (String)"DefaultHistoryManager_28", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "BillAbort": {
                skip.put(skipReason, ResManager.loadKDString((String)"\u6574\u5355\u5f3a\u5236\u64a4\u56de", (String)"DefaultHistoryManager_29", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "BillWithdrawJump": {
                skip.put(skipReason, ResManager.loadKDString((String)"\u6574\u5355\u64a4\u56de\u5f3a\u5236\u8df3\u8f6c\u81f3\u4eba\u5de5", (String)"DefaultHistoryManager_34", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "AddSignBeforeJump": {
                skip.put(skipReason, ResManager.loadKDString((String)"\u52a0\u7b7e\u8df3\u8f6c", (String)"DefaultHistoryManager_30", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "BillExcepAbort": {
                skip.put(skipReason, ResManager.loadKDString((String)"\u5355\u636e\u4f8b\u5916\u7ec8\u6b62", (String)"DefaultHistoryManager_31", (String)"bos-wf-engine", (Object[])new Object[0]));
                break;
            }
            case "TerminateProcWhenExceptionOccurs": {
                skip.put(skipReason, WFMultiLangConstants.getAbendText().getLocaleValue());
                break;
            }
            default: {
                return " ";
            }
        }
        return (String)skip.get(skipReason);
    }

    @Override
    public void recordDynResourceCreated(DynamicResourceEntity dynamicResource) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            HistoricDynamicResourceEntity historicDynResource = this.getHistoricDynamicResourceEntityManager().create(dynamicResource);
            this.getHistoricDynamicResourceEntityManager().insert(historicDynResource, false);
        }
    }

    @Override
    public void recordDynResourceUpdated(DynamicResourceEntity dynamicResource) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            HistoricDynamicResourceEntity historicDynResource = (HistoricDynamicResourceEntity)this.getHistoricDynamicResourceEntityManager().findById(dynamicResource.getId());
            historicDynResource.setContent(dynamicResource.getContent());
            this.getHistoricDynamicResourceEntityManager().update(historicDynResource, false);
        }
    }

    @Override
    public void recordConditionRuleInstance(String conditionExpression, ExecutionEntity executionEntity, String logMsg, String key, String businessKey) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && WfUtils.isNotEmpty(businessKey) && WfTraceType.getOrCreate().getJobInfo() != null) {
            HistoricConditionRuleInstanceEntity historicConditionInst = (HistoricConditionRuleInstanceEntity)this.getHistoricConditionRuleInstanceEntityManager().create();
            historicConditionInst.setProcessDefinitionId(executionEntity == null ? null : executionEntity.getProcessDefinitionId());
            historicConditionInst.setProcessInstanceId(executionEntity == null ? null : executionEntity.getProcessInstanceId());
            historicConditionInst.setActivityId(executionEntity == null ? null : executionEntity.getActivityId());
            historicConditionInst.setActivityInstId(executionEntity == null ? null : executionEntity.getCurrentActInstId());
            historicConditionInst.setExpression(conditionExpression);
            historicConditionInst.setLogMsg(logMsg);
            historicConditionInst.setKey(key);
            historicConditionInst.setBusinessKey(businessKey);
            this.getHistoricConditionRuleInstanceEntityManager().insert(historicConditionInst, false);
        } else {
            log.debug(String.format("conditionExpression:%s,logMsg:%s,key:%s,businessKey,%s", conditionExpression, logMsg, key, businessKey));
        }
    }

    @Override
    public void recordFeedbackEntityCreated(FeedbackEntity feedbackEntity) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            HistoricFeedbackEntity historicFeedbackEntity = (HistoricFeedbackEntity)this.getHistoricFeedbackEntityManager().create();
            historicFeedbackEntity.setId(feedbackEntity.getId());
            historicFeedbackEntity.setProcessInstanceId(feedbackEntity.getProcessInstanceId());
            historicFeedbackEntity.setBusinessKey(feedbackEntity.getBusinessKey());
            historicFeedbackEntity.setFeedbackMsg(feedbackEntity.getFeedbackMsg());
            historicFeedbackEntity.setFeedbackImg(feedbackEntity.getFeedbackImg());
            historicFeedbackEntity.setFeedbackAttach(feedbackEntity.getFeedbackAttach());
            historicFeedbackEntity.setCreatorId(feedbackEntity.getCreatorId());
            historicFeedbackEntity.setModifierId(feedbackEntity.getModifierId());
            this.getHistoricFeedbackEntityManager().insert(historicFeedbackEntity, false);
        }
    }

    @Override
    public void recordFeedbackEntityDelete(Long id) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            this.getHistoricFeedbackEntityManager().delete(id);
        }
    }

    @Override
    public void recordTaskParticipant(Long taskId, Long srcUserId, List<Long> destUserIds) {
        ILocaleString participantName;
        this.logger.debug("DefaultHistoryManager.recordTaskParticipant_srcUserId:" + srcUserId);
        this.logger.debug("DefaultHistoryManager.recordTaskParticipant_destUserIds:" + destUserIds);
        TaskEntity task = (TaskEntity)this.getTaskEntityManager().findById(taskId);
        HistoricTaskInstanceEntity hiTask = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId);
        List identityLinks = task.getIdentityLinks().stream().filter(e -> "participant".equals(e.getType())).collect(Collectors.toList());
        ArrayList<ILocaleString> participantNameList = new ArrayList<ILocaleString>(identityLinks.size());
        ArrayList<ILocaleString> participantNameFormatList = new ArrayList<ILocaleString>(identityLinks.size());
        for (IdentityLinkEntity identityLink : identityLinks) {
            participantNameList.add(identityLink.getUserName());
            participantNameFormatList.add(identityLink.getUserNameFormatter());
        }
        if (WfConfigurationUtil.isDisplaySetting()) {
            participantName = WfMultiLangUtils.getFormatMergeValue(participantNameFormatList);
            task.setParticipantName(participantName);
            hiTask.setParticipantName(participantName);
        } else {
            participantName = WfMultiLangUtils.getFormatMergeValue(participantNameList);
            task.setParticipantName(participantName);
            hiTask.setParticipantName(participantName);
        }
        this.getTaskEntityManager().update(task);
        this.getHistoricTaskInstanceEntityManager().update(hiTask);
    }

    @Override
    public void recordOtherBranchActivityExecutionType(ExecutionEntity execution, String executionType) {
        QFilter filter = new QFilter("processInstanceId", "=", (Object)execution.getProcessInstanceId());
        QFilter timeFilter = new QFilter("endTime", "is null", null);
        QFilter activityFilter = new QFilter("activityId", "!=", (Object)execution.getActivityId());
        List entitys = this.getHistoricActivityInstanceEntityManager().findByQueryFilters(new QFilter[]{filter, activityFilter, timeFilter});
        if (CollectionUtil.isNotEmpty(entitys)) {
            for (HistoricActivityInstanceEntity i : entitys) {
                i.setExecutionType(executionType);
                this.getHistoricActivityInstanceEntityManager().update(i);
            }
        }
    }

    @Override
    public void insertOrUpdateLastCurrentNodeMapper(ExecutionEntity execution, SequenceFlow sequenceFlow, FlowElement targetFlowElement) {
        CommandContext commandContext = Context.getCommandContext();
        List<HiUserActInstEntity> mappers = commandContext.getHiUserActInstEntityManager().findByCurrentExecutionId(execution.getId());
        if (mappers.isEmpty()) {
            HiUserActInstEntity mapper = (HiUserActInstEntity)commandContext.getHiUserActInstEntityManager().create();
            mapper.setBusinesskey(execution.getBusinessKey());
            mapper.setCurrentActId(targetFlowElement.getId());
            mapper.setCurrentNodeName(targetFlowElement.getName());
            List<HistoricActivityInstanceEntity> lastNodeActinst = commandContext.getHistoricActivityInstanceEntityManager().findByActivityId(execution.getProcessInstanceId(), sequenceFlow.getSourceFlowElement().getId());
            if (lastNodeActinst != null && !lastNodeActinst.isEmpty()) {
                HistoricActivityInstanceEntity tmp = lastNodeActinst.get(0);
                for (HistoricActivityInstanceEntity i : lastNodeActinst) {
                    if (!i.getExecutionId().equals(execution.getId())) continue;
                    tmp = i;
                    break;
                }
                mapper.setLastNodeActinstId(tmp.getId());
                mapper.setEndType(tmp.getExecutionType());
            }
            mapper.setExecutionId(execution.getId());
            mapper.setCurrentExecutionId(execution.getId());
            mapper.setLastUserNodeActId(sequenceFlow.getSourceFlowElement().getId());
            mapper.setLastNodeName(sequenceFlow.getSourceFlowElement().getName());
            List<CommentEntity> comments = commandContext.getCommentEntityManager().findCommentsByProcessInstanceIdAndActivityId(execution.getProcessInstanceId(), mapper.getLastUserNodeActId());
            if (comments != null && !comments.isEmpty()) {
                List<CommentEntity> yzjParentComments;
                Long commentId = comments.get(0).getId();
                if (sequenceFlow.getSourceFlowElement() instanceof YunzhijiaTask && WfUtils.isNotEmpty(comments.get(0).getGroupId()) && (yzjParentComments = commandContext.getCommentEntityManager().findCommentsByTaskId(Long.parseLong(comments.get(0).getGroupId()))) != null && !yzjParentComments.isEmpty()) {
                    commentId = yzjParentComments.get(0).getId();
                }
                mapper.setLastNodeCid(commentId);
            }
            mapper.setProinstId(execution.getProcessInstanceId());
            mapper.setPathJson(null);
            commandContext.getHiUserActInstEntityManager().insert(mapper);
        } else {
            for (HiUserActInstEntity n : mappers) {
                if (n.getCurrentExecutionId().longValue() != execution.getId().longValue()) continue;
                n.setCurrentActId(targetFlowElement.getId());
                n.setCurrentNodeName(targetFlowElement.getName());
                commandContext.getHiUserActInstEntityManager().batchUpdate(mappers);
            }
        }
    }

    @Override
    public void updateNodeHiUserActInst(ExecutionEntity execution, FlowNode flowNode, Date endDate) {
        block16: {
            boolean isStrongControlWithdraw;
            HiUserActInstEntityManager hiUserMgr;
            List<HiUserActInstEntity> allHiUserActInsts;
            CommandContext commandContext = Context.getCommandContext();
            HistoricActivityInstanceEntity hiactinst = (HistoricActivityInstanceEntity)commandContext.getHistoricActivityInstanceEntityManager().findById(execution.getCurrentActInstId());
            if (hiactinst == null || !ProcessType.AuditFlow.name().equals(execution.getProcessType()) && !ProcessType.NoCodeFlow.name().equals(execution.getProcessType()) || (allHiUserActInsts = (hiUserMgr = commandContext.getHiUserActInstEntityManager()).findByActivityIdAndProinstId(flowNode.getId(), hiactinst.getProcessInstanceId())).isEmpty()) break block16;
            boolean isManual = BpmnModelUtil.isManualHandled(hiactinst.getExecutionType());
            if (!isManual && "YunzhijiaTask".equals(hiactinst.getActivityType())) {
                HistoricActivityInstanceEntity actInst;
                String executionType;
                QFilter[] filters = new QFilter[]{new QFilter("processInstanceId", "=", (Object)execution.getProcessInstanceId()), new QFilter("sourceElementId", "=", (Object)hiactinst.getSourceElementId()), new QFilter("assigneeId", ">", (Object)0)};
                List actInsts = commandContext.getHistoricActivityInstanceEntityManager().findByQueryFilters(filters, String.format("%s,%s", "executionType", "id"), null);
                Iterator iterator = actInsts.iterator();
                while (iterator.hasNext() && !(isManual = BpmnModelUtil.isManualHandled(executionType = (actInst = (HistoricActivityInstanceEntity)iterator.next()).getExecutionType()))) {
                }
            }
            if (!(isStrongControlWithdraw = "strongControlWithdraw".equals(allHiUserActInsts.get(0).getEndType())) && isManual && BpmnModelUtil.instanceofUserTask(hiactinst.getActivityType())) {
                for (HiUserActInstEntity i : allHiUserActInsts) {
                    i.setCurrentExecutionId(execution.getId());
                    i.setEndTime(endDate);
                    i.setModifyDate(endDate);
                    hiUserMgr.update(i);
                }
            } else if (flowNode instanceof YunzhijiaTask) {
                for (HiUserActInstEntity i : allHiUserActInsts) {
                    if (isStrongControlWithdraw) {
                        i.setEndType("");
                    }
                    PathJson currentPath = new PathJson(flowNode.getId(), hiactinst.getId(), null, hiactinst.getSourceElementId(), null, hiactinst.getTargetElementId(), i.getId(), execution.getId(), i.getJoinFlag());
                    List<PathJson> paths = new ArrayList<PathJson>();
                    if (WfUtils.isNotEmpty(i.getPathJson())) {
                        paths = SerializationUtils.fromJsonStringToList((String)i.getPathJson(), PathJson.class);
                    }
                    paths.add(currentPath);
                    i.setPathJson(SerializationUtils.toJsonString(paths));
                    i.setCurrentExecutionId(execution.getId());
                    i.setModifyDate(endDate);
                    commandContext.getHiUserActInstEntityManager().update(i);
                }
            } else {
                List<HistoricActivityInstanceEntity> allInsts = new ArrayList<HistoricActivityInstanceEntity>();
                if (WfUtils.isEmpty(hiactinst.getJoinFlag())) {
                    allInsts.add(hiactinst);
                } else {
                    allInsts = commandContext.getHistoricActivityInstanceEntityManager().findByProInstIdAndJoinFlag(execution.getProcessInstanceId(), hiactinst.getJoinFlag(), execution.getId());
                }
                for (HistoricActivityInstanceEntity i : allInsts) {
                    List<HiUserActInstEntity> hiUsers = commandContext.getHiUserActInstEntityManager().findByActivityAndProinstId(i.getId(), execution.getProcessInstanceId());
                    if (hiUsers == null || hiUsers.isEmpty()) continue;
                    for (HiUserActInstEntity h : hiUsers) {
                        PathJson currentPath = new PathJson(flowNode.getId(), i.getId(), null, i.getSourceElementId(), null, i.getTargetElementId(), h.getId(), i.getExecutionId(), i.getJoinFlag());
                        List<PathJson> paths = new ArrayList<PathJson>();
                        if (WfUtils.isNotEmpty(h.getPathJson())) {
                            paths = SerializationUtils.fromJsonStringToList((String)h.getPathJson(), PathJson.class);
                        }
                        if (isStrongControlWithdraw) {
                            h.setEndType("");
                        }
                        paths.add(currentPath);
                        h.setPathJson(SerializationUtils.toJsonString(paths));
                        h.setCurrentExecutionId(execution.getId());
                        i.setModifyDate(endDate);
                        commandContext.getHiUserActInstEntityManager().update(h);
                    }
                }
            }
        }
    }
}

