/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.interceptor;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.impl.agenda.AbstractOperation;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.AbstractCommandInterceptor;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandInterceptor;
import kd.bos.workflow.service.WfTraceType;

public class CommandInvoker
extends AbstractCommandInterceptor {
    protected static Log logger = LogFactory.getLog(CommandInvoker.class);

    @Override
    public <T> T execute(CommandConfig config, final Command<T> command) {
        final CommandContext commandContext = Context.getCommandContext();
        commandContext.getAgenda().planOperation(new Runnable(){

            @Override
            public void run() {
                commandContext.setResult(command.execute(commandContext));
            }
        });
        this.executeOperations(commandContext);
        if (commandContext.hasInvolvedExecutions()) {
            Context.getAgenda().planExecuteInactiveBehaviorsOperation();
            this.executeOperations(commandContext);
        }
        return (T)commandContext.getResult();
    }

    protected void executeOperations(CommandContext commandContext) {
        while (!commandContext.getAgenda().isEmpty()) {
            Runnable runnable = commandContext.getAgenda().getNextOperation();
            this.executeOperation(runnable);
        }
    }

    public void executeOperation(Runnable runnable) {
        if (runnable instanceof AbstractOperation) {
            AbstractOperation operation = (AbstractOperation)runnable;
            if (operation.getExecution() == null || !operation.getExecution().isEnded()) {
                StringBuilder sb = new StringBuilder();
                if (operation != null && operation.getExecution() != null) {
                    WfTraceType.WfTraceJobInfo job;
                    sb.append("procInsntaceId[").append(operation.getExecution().getProcessInstanceId()).append("]");
                    sb.append("activitid[").append(operation.getExecution().getActivityId()).append("]");
                    if (WfTraceType.get() != null && WfTraceType.get().getJobInfo() != null && (job = WfTraceType.get().getJobInfo()) != null) {
                        sb.append(job.getJobType()).append(",").append(job.getElementId()).append(",").append(job.getCurrentJobId()).append(",").append(Thread.currentThread().getId());
                    }
                }
                StringBuilder sbb = new StringBuilder();
                sbb.append("Executing operation  ").append(operation.getClass()).append('[').append((CharSequence)sb).append(']');
                logger.debug(sbb.toString());
                operation.getCommandContext().setAgendaOperation(operation);
                runnable.run();
            }
        } else {
            runnable.run();
        }
    }

    @Override
    public CommandInterceptor getNext() {
        return null;
    }

    @Override
    public void setNext(CommandInterceptor next) {
        throw new UnsupportedOperationException("CommandInvoker must be the last interceptor in the chain");
    }
}

