/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.interceptor;

import kd.bos.workflow.engine.impl.cfg.TransactionContext;
import kd.bos.workflow.engine.impl.cfg.TransactionContextFactory;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.AbstractCommandInterceptor;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.TransactionCommandContextCloseListener;

public class TransactionContextInterceptor
extends AbstractCommandInterceptor {
    protected TransactionContextFactory transactionContextFactory;

    public TransactionContextInterceptor() {
    }

    public TransactionContextInterceptor(TransactionContextFactory transactionContextFactory) {
        this.transactionContextFactory = transactionContextFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(CommandConfig config, Command<T> command) {
        CommandContext commandContext = Context.getCommandContext();
        boolean isReused = commandContext.isReused();
        try {
            if (this.transactionContextFactory != null && !isReused) {
                TransactionContext transactionContext = this.transactionContextFactory.openTransactionContext(commandContext);
                Context.setTransactionContext(transactionContext);
                commandContext.addCloseListener(new TransactionCommandContextCloseListener(transactionContext));
            }
            T t = this.next.execute(config, command);
            return t;
        }
        finally {
            if (this.transactionContextFactory != null && !isReused) {
                Context.removeTransactionContext();
            }
        }
    }

    public TransactionContextFactory getTransactionContextFactory() {
        return this.transactionContextFactory;
    }

    public void setTransactionContextFactory(TransactionContextFactory transactionContextFactory) {
        this.transactionContextFactory = transactionContextFactory;
    }
}

