/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.EventDispatchContext;
import kd.bos.bec.engine.el.EventModelVariableScope;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.bec.engine.servicehanler.EvtJobHandler;
import kd.bos.bec.engine.utils.BecUtils;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.EventParticipantCalculatorUtil;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.jobexecutor.JobHandler;
import kd.bos.workflow.engine.impl.log.entity.EventLogEsEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.event.EventLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ReflectUtil;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.service.WfTraceType;
import org.apache.commons.beanutils.MethodUtils;

public abstract class AbstractJobHandler
implements JobHandler,
EvtJobHandler {
    private static final String BUSINESSKEY = "businesskey";
    private static final String EMAIL_CONTENT = "emailContent";
    private static final String EMAIL_TITLE = "emailTitle";
    public static final String ERRMSG = "{errmsg}";
    public static final String CLASS = "class";
    public static final String CONTENT = "content";
    public static final String URLVALUE = "urlvalue";
    public static final String TITLE = "title";
    protected Log log = LogFactory.getLog(this.getClass());

    protected String getBillNo() {
        if (WfTraceType.get() != null && WfTraceType.get().getJobInfo() != null) {
            return WfTraceType.get().getJobInfo().getBillNo();
        }
        return "";
    }

    protected Map<String, Object> restoreContext(String configuration) {
        Map payload = (Map)SerializationUtils.fromJsonString((String)configuration, Map.class);
        if (payload != null && payload.get("_requestContext_") != null) {
            payload.remove("_requestContext_");
        }
        return payload;
    }

    protected boolean executionExist(ExecutionEntity execution, JobEntity job) {
        if (execution == null || !QueryServiceHelper.exists((String)"wf_execution", (Object)execution.getId())) {
            String msg = String.format(ResManager.loadKDString((String)"\u6d88\u606f\u201c%1$s\u201d\u5bf9\u5e94\u7684\u6267\u884c\u5b9e\u4f8b\u201c%2$s\u201d\u5df2\u4e0d\u5b58\u5728\uff0c\u8282\u70b9\u53ef\u80fd\u5df2\u4ece\u201c%3$s\u201d\u6d41\u8f6c\u51fa\u3002", (String)"AsyncContinuationJobHandler_3", (String)"bos-wf-engine", (Object[])new Object[0]), job.getId(), job.getExecutionId(), job.getElementId());
            job.setExceptionMessage(msg);
            return false;
        }
        return true;
    }

    public String formatExecptionMsg(EvtJobEntity job, EventDispatchContext edContext, Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(ResManager.loadKDString((String)"\u6267\u884c[%1$s]\u5931\u8d25\uff0c\u4e8b\u4ef6\u8fd0\u884c\u671fId[%2$s]\uff1b", (String)"AbstractJobHandler_2", (String)"bos-wf-engine", (Object[])new Object[0]), this.getType(), job.getId()));
        if (edContext == null) {
            sb.append(ResManager.loadKDString((String)"\u5f62\u6210\u4e8b\u4ef6\u4e0a\u4e0b\u6587\u5931\u8d25\u3002", (String)"AbstractJobHandler_4", (String)"bos-wf-engine", (Object[])new Object[0]));
        } else {
            sb.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801[%1$s],\u5931\u8d25\u539f\u56e0:[%2$s],\u8be6\u7ec6\u5931\u8d25\u539f\u56e0\u53ef\u4ee5\u67e5\u770b\u4e8b\u4ef6\u65e5\u5fd7\u3002", (String)"AbstractJobHandler_5", (String)"bos-wf-engine", (Object[])new Object[0]), edContext.getEvent().getEventNumber(), e.getMessage()));
        }
        return sb.toString();
    }

    public EventLogEntity buildEventLog(EventDispatchContext edContext, EvtJobEntity job) {
        EventLogEsEntityImpl evtLog = EventLogEsEntityImpl.create();
        evtLog.setJobid(job.getId());
        KDBizEvent event = edContext.getEvent();
        String evtNumber = event.getEventNumber();
        evtLog.setEventnumber(evtNumber);
        evtLog.setScene("excuteService");
        String businesskey = job.getBusinessKey();
        evtLog.setEventid(event.getEventId());
        evtLog.setServiceid(edContext.getServiceId());
        evtLog.setSubscribeid(edContext.getSubscriptionId());
        if (event instanceof EntityEvent) {
            EntityEvent ee = (EntityEvent)event;
            evtLog.setBusinesskey(businesskey);
            evtLog.setEntitynumber(ee.getEntityNumber());
        }
        return evtLog;
    }

    public String getStringVal(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            return SerializationUtils.toJsonString((Object)obj);
        }
        return String.valueOf(obj).trim();
    }

    protected void sendEventErrorMsg(EventDispatchContext edContext, String errorMsg, EvtJobEntity job) {
        String pkId = job.getBusinessKey();
        String notifyValue = edContext.getErrorNotify();
        String lang = RequestContext.get().getLang().toString();
        if (WfUtils.isNotEmpty(notifyValue)) {
            MessageInfo info = new MessageInfo();
            Map cfg = (Map)SerializationUtils.fromJsonString((String)notifyValue, Map.class);
            KDBizEvent event = edContext.getEvent();
            String entityNumber = "";
            List<String> businesskeys = new ArrayList();
            String channel = (String)cfg.get("notifytype");
            String[] channelArray = new String[]{};
            if (StringUtils.isNotBlank((CharSequence)channel)) {
                channelArray = channel.split(",");
            }
            Map<String, String> billUrlCollection = null;
            if (event instanceof EntityEvent) {
                EntityEvent entityEvent = (EntityEvent)event;
                entityNumber = entityEvent.getEntityNumber();
                businesskeys = entityEvent.getBusinesskeys();
                String busineseeKey = (String)businesskeys.get(0);
                String receiver = (String)cfg.get("receivervalue");
                BusinessModelVariableScope bvs = new BusinessModelVariableScope(busineseeKey, entityNumber);
                Map<String, List<Long>> participantMap = EventParticipantCalculatorUtil.participantCalculator(receiver, event, businesskeys, entityNumber, edContext);
                String content = (String)cfg.get(CONTENT);
                Map<String, String> mapData = new HashMap<String, String>();
                try {
                    mapData = (Map)SerializationUtils.fromJsonString((String)content, Map.class);
                }
                catch (Exception e) {
                    mapData.put(CONTENT, content);
                    mapData.put(TITLE, (String)cfg.get(TITLE));
                }
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)busineseeKey, (String)entityNumber);
                if (StringUtils.isNotBlank((CharSequence)channel) && WfUtils.isEmailChannel(channelArray[1]) && channelArray.length < 3) {
                    String url;
                    String emailTitle = "";
                    String emailContent = "";
                    if (mapData.get(EMAIL_TITLE) == null && mapData.get(TITLE) != null && mapData.get(EMAIL_CONTENT) == null && mapData.get(CONTENT) != null) {
                        emailTitle = WfUtils.mapToStr(mapData.get(TITLE));
                        emailContent = WfUtils.mapToStr(mapData.get(CONTENT));
                    } else {
                        emailTitle = WfUtils.mapToStr(mapData.get(EMAIL_TITLE));
                        emailContent = WfUtils.mapToStr(mapData.get(EMAIL_CONTENT));
                    }
                    try {
                        emailTitle = emailTitle.replace(ERRMSG, errorMsg);
                        emailContent = emailContent.replace(ERRMSG, errorMsg);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (emailContent.contains("{billformUrl}") && !StringUtils.isBlank((CharSequence)(url = (String)cfg.get(URLVALUE))) && url != null) {
                        Map configMap = (Map)SerializationUtils.fromJsonString((String)url, Map.class);
                        String buildUrlInfo = null;
                        if (configMap.get(CLASS) != null) {
                            billUrlCollection = BecUtils.pluginCalculator(configMap, edContext, businesskeys);
                            buildUrlInfo = billUrlCollection.get(busineseeKey);
                        } else {
                            buildUrlInfo = WfUtils.buildUrlInfo(obj, bvs, configMap, pkId);
                        }
                        this.log.debug(String.format("\u66ff\u6362{billformUrl}\u524d\u5185\u5bb9\u4e3a\uff1a%s", emailContent));
                        emailContent = emailContent.startsWith("{") && emailContent.endsWith("}") ? emailContent.replaceAll("href.*?\"\\{billformUrl\\}\\\\\"", String.format("href='%s'", buildUrlInfo)) : emailContent.replaceAll("(<a.+?href=)\".*?\\{billformUrl\\}.*?\"", String.format("$1\"%s\"", buildUrlInfo));
                        this.log.debug(String.format("\u66ff\u6362{billformUrl}\u540e\u5185\u5bb9\u4e3a\uff1a%s", emailContent));
                    }
                    WfUtils.wrapMessageInfoMutil(emailTitle, emailContent, busineseeKey, entityNumber, bvs, info);
                } else {
                    String msgTitle = WfUtils.mapToStr(mapData.get(TITLE));
                    String msgContent = WfUtils.mapToStr(mapData.get(CONTENT));
                    try {
                        msgTitle = msgTitle.replace(ERRMSG, errorMsg);
                        msgContent = msgContent.replace(ERRMSG, errorMsg);
                    }
                    catch (Exception url) {
                        // empty catch block
                    }
                    WfUtils.wrapMessageInfoMutil(msgTitle, msgContent, busineseeKey, entityNumber, bvs, info);
                    String url = (String)cfg.get(URLVALUE);
                    if (!StringUtils.isBlank((CharSequence)url) && url != null) {
                        Map configMap = (Map)SerializationUtils.fromJsonString((String)url, Map.class);
                        String buildUrlInfo = null;
                        if (configMap.get(CLASS) != null) {
                            billUrlCollection = BecUtils.pluginCalculator(configMap, edContext, businesskeys);
                            buildUrlInfo = billUrlCollection.get(busineseeKey);
                        } else {
                            buildUrlInfo = WfUtils.buildUrlInfo(obj, bvs, configMap, pkId);
                        }
                        info.setContentUrl(buildUrlInfo);
                        info.setMobContentUrl(buildUrlInfo);
                    }
                }
                if (channel == null) {
                    info.setNotifyType("mcenter");
                } else {
                    info.setNotifyType(channel);
                }
                info.setType("message");
                info.setTag(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3", (String)"AbstractJobHandler_1", (String)"bos-wf-engine", (Object[])new Object[0]));
                ArrayList users = new ArrayList();
                users.addAll(participantMap.get(businesskeys.get(0)));
                info.setUserIds(users);
                info.setEntityNumber(entityNumber);
            } else {
                Long srcJobId = job.getSrcJobId();
                EvtJobEntity srcJob = Context.getCommandContext().getEvtJobEntityManager().findBothJobById(srcJobId);
                if (srcJob == null) {
                    this.log.debug(String.format("sendErrorMsg\u6ca1\u6709\u67e5\u8be2\u5230jobId\uff1a%s", srcJobId));
                    throw new KDException(WFErrorCode.bizEventError(), new Object[]{String.format(ResManager.loadKDString((String)"sendErrorMsg\u6ca1\u6709\u67e5\u8be2\u5230jobId\uff1a%s", (String)"AbstractJobHandler_8", (String)"bos-wf-engine", (Object[])new Object[0]), srcJobId)});
                }
                String configuration = srcJob.getJobHandlerConfiguration();
                Map<String, Object> payload = this.restoreContext(configuration);
                String json = (String)payload.get("json");
                this.buildBusinesskeys(json, businesskeys);
                EventModelVariableScope vs = new EventModelVariableScope(json);
                vs.setTransientVariable("lang", lang);
                String receiver = (String)cfg.get("receivervalue");
                Map<String, List<Long>> participantMap = EventParticipantCalculatorUtil.participantCalculator(receiver, event, businesskeys, entityNumber, edContext);
                String content = (String)cfg.get(CONTENT);
                Map<String, String> mapData = new HashMap<String, String>();
                try {
                    mapData = (Map)SerializationUtils.fromJsonString((String)content, Map.class);
                }
                catch (Exception e) {
                    mapData.put(CONTENT, content);
                    mapData.put(TITLE, (String)cfg.get(TITLE));
                }
                if (StringUtils.isNotBlank((CharSequence)channel) && WfUtils.isEmailChannel(channelArray[1]) && channelArray.length < 3) {
                    String url;
                    String emailTitle = "";
                    String emailContent = "";
                    if (mapData.get(EMAIL_TITLE) == null && mapData.get(TITLE) != null && mapData.get(EMAIL_CONTENT) == null && mapData.get(CONTENT) != null) {
                        emailTitle = WfUtils.mapToStr(mapData.get(TITLE));
                        emailContent = WfUtils.mapToStr(mapData.get(CONTENT));
                    } else {
                        emailTitle = WfUtils.mapToStr(mapData.get(EMAIL_TITLE));
                        emailContent = WfUtils.mapToStr(mapData.get(EMAIL_CONTENT));
                    }
                    try {
                        emailTitle = emailTitle.replace(ERRMSG, errorMsg);
                        emailContent = emailContent.replace(ERRMSG, errorMsg);
                    }
                    catch (Exception buildUrlInfo) {
                        // empty catch block
                    }
                    if (emailContent.contains("{billformUrl}") && !StringUtils.isBlank((CharSequence)(url = (String)cfg.get(URLVALUE))) && url != null) {
                        Map configMap = (Map)SerializationUtils.fromJsonString((String)url, Map.class);
                        String buildUrlInfo = null;
                        if (configMap.get(CLASS) != null) {
                            billUrlCollection = BecUtils.pluginCalculator(configMap, edContext, businesskeys);
                            buildUrlInfo = billUrlCollection.get(businesskeys.get(0));
                        } else {
                            buildUrlInfo = WfUtils.buildUrlInfo(null, vs, configMap, pkId);
                        }
                        entityNumber = this.getEntityNumberFromUrl(buildUrlInfo);
                        this.log.debug(String.format("\u66ff\u6362{billformUrl}\u524d\u5185\u5bb9\u4e3a\uff1a%s", emailContent));
                        emailContent = emailContent.startsWith("{") && emailContent.endsWith("}") ? emailContent.replaceAll("href.*?\"\\{billformUrl\\}\\\\\"", String.format("href='%s'", buildUrlInfo)) : emailContent.replaceAll("(<a.+?href=)\".*?\\{billformUrl\\}.*?\"", String.format("$1\"%s\"", buildUrlInfo));
                        this.log.debug(String.format("\u66ff\u6362{billformUrl}\u540e\u5185\u5bb9\u4e3a\uff1a%s", emailContent));
                    }
                    WfUtils.wrapMessageInfoMutil(emailTitle, emailContent, vs, info);
                } else {
                    String msgTitle = WfUtils.mapToStr(mapData.get(TITLE));
                    String msgContent = WfUtils.mapToStr(mapData.get(CONTENT));
                    try {
                        msgTitle = msgTitle.replace(ERRMSG, errorMsg);
                        msgContent = msgContent.replace(ERRMSG, errorMsg);
                    }
                    catch (Exception url) {
                        // empty catch block
                    }
                    WfUtils.wrapMessageInfoMutil(msgTitle, msgContent, vs, info);
                    String url = (String)cfg.get(URLVALUE);
                    if (!StringUtils.isBlank((CharSequence)url) && url != null) {
                        Map configMap = (Map)SerializationUtils.fromJsonString((String)url, Map.class);
                        String buildUrlInfo = null;
                        if (configMap.get(CLASS) != null) {
                            billUrlCollection = BecUtils.pluginCalculator(configMap, edContext, businesskeys);
                            buildUrlInfo = billUrlCollection.get(businesskeys.get(0));
                        } else {
                            buildUrlInfo = WfUtils.buildUrlInfo(null, vs, configMap, pkId);
                        }
                        info.setContentUrl(buildUrlInfo);
                        info.setMobContentUrl(buildUrlInfo);
                    }
                }
                if (channel == null) {
                    info.setNotifyType("mcenter");
                } else {
                    info.setNotifyType(channel);
                }
                info.setType("message");
                info.setTag(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3", (String)"AbstractJobHandler_1", (String)"bos-wf-engine", (Object[])new Object[0]));
                ArrayList users = new ArrayList();
                users.addAll(participantMap.get(businesskeys.get(0)));
                info.setUserIds(users);
                info.setEntityNumber(entityNumber);
            }
            long beginSendMessage = System.currentTimeMillis();
            this.log.debug(String.format("sendErrorMsg\u8c03\u7528\u53d1\u9001\u6d88\u606f\u63a5\u53e3\uff1a%s", beginSendMessage));
            MessageCenterServiceHelper.sendMessage((MessageInfo)info);
            long endSendMessage = System.currentTimeMillis();
            this.log.debug(String.format("sendErrorMsg\u53d1\u9001\u6d88\u606f\u63a5\u53e3\u8c03\u7528\u5b8c\u6210\uff1a%s", endSendMessage));
        }
    }

    public String getEntityNumberFromUrl(String url) {
        if (null != url) {
            try {
                String params = url.substring(url.indexOf(63) + 1, url.length());
                Map split = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)params);
                return (String)split.get("formId");
            }
            catch (Exception e) {
                this.log.warn("\u81ea\u5b9a\u4e49Url\u53c2\u6570\u89e3\u6790\u5931\u8d25");
            }
        }
        return null;
    }

    public void invokeMethod(String className, String methodName, Object[] params) {
        Class<?> cls = ReflectUtil.loadClassForEvent(className);
        try {
            Constructor<?> cst = cls.getDeclaredConstructor(new Class[0]);
            MethodUtils.invokeMethod(cst.newInstance(new Object[0]), (String)methodName, (Object[])params);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("bos.wf.Event.pluginService.error", e.getMessage()), new Object[]{WfUtils.getExceptionStacktrace(e), e});
        }
    }

    public void buildBusinesskeys(String json, List<String> businesskeys) {
        JSONObject obj;
        String businesskey;
        if (json != null && !json.trim().equals("") && WfUtils.isNotEmpty(businesskey = (obj = JSON.parseObject((String)json)).getString(BUSINESSKEY))) {
            if (businesskey.contains(",")) {
                String[] pk;
                for (String p : pk = businesskey.split("\\,")) {
                    if (!WfUtils.isNotEmpty(p)) continue;
                    businesskeys.add(p);
                }
            } else {
                businesskeys.add(businesskey);
            }
        }
        if (businesskeys.isEmpty()) {
            businesskeys.add(BUSINESSKEY);
        }
    }

    public String getCurrentActivityId(ExecutionEntity execution) {
        if (execution == null) {
            return null;
        }
        if (execution.getParent() != null && execution.getParent().isMultiInstanceRoot()) {
            return execution.getParent().getCurrentActivityId();
        }
        return execution.getCurrentActivityId();
    }
}

