/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.BatchComplateConvertTasks;
import kd.bos.workflow.engine.impl.cmd.task.BatchComplateCustomTasksCmd;
import kd.bos.workflow.engine.impl.cmd.task.BatchCompleteTask;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.AbstractJobHandler;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class AsyncCompensationTaskJobHandler
extends AbstractJobHandler {
    public static final String TYPE = "async-compensationTaskJob";
    public static final String TASKID = "taskId";
    public static final String VARIABLES = "varaibles";
    public static final String CONVERTTASK = "convertTask";
    protected static Log logger = LogFactory.getLog(AsyncCompensationTaskJobHandler.class);

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        String taskSource;
        Map<String, Object> payload = this.restoreContext(configuration);
        Long taskId = (Long)payload.get(TASKID);
        Map variables = (Map)payload.get(VARIABLES);
        String string = taskSource = variables == null ? null : (String)variables.get("taskSource");
        if ((taskSource == null || taskSource.equalsIgnoreCase("wf")) && !this.executionExist(execution, job)) {
            if (WfUtils.isNotEmpty(taskId)) {
                commandContext.getTaskHelper().deleteTask(taskId, "yunzhijiaTask completed", false);
            }
            return;
        }
        if (taskId != null) {
            Boolean convertTask;
            Object obj = WfUtils.pop(variables, "auditUserId");
            Long userId = null;
            if (obj != null) {
                userId = Long.valueOf(obj.toString());
            }
            String ret = null;
            ret = taskSource == null || taskSource.equalsIgnoreCase("wf") ? ((convertTask = (Boolean)payload.get(CONVERTTASK)) != null && convertTask.booleanValue() ? new BatchComplateConvertTasks(taskId, true).execute(commandContext) : new BatchCompleteTask(new Long[]{taskId}, userId, true, (Map<String, Object>)variables).execute(commandContext)) : new BatchComplateCustomTasksCmd(new Long[]{taskId}, userId, true, variables).execute(commandContext);
            if (WfUtils.isNotEmpty(ret)) {
                job.setExceptionMessage(ret);
            }
        } else {
            logger.debug("job[%s] don't have taskid.");
        }
    }

    @Override
    protected Map<String, Object> restoreContext(String configuration) {
        HashMap<String, Object> payload = (HashMap<String, Object>)SerializationUtils.fromJsonString((String)configuration, Map.class);
        if (payload == null) {
            payload = new HashMap<String, Object>();
        } else {
            Map context = (Map)payload.get("_requestContext_");
            if (context != null) {
                String lang = (String)context.get("lang");
                if (WfUtils.isNotEmpty(lang)) {
                    RequestContext requestContext = RequestContext.get();
                    requestContext.setLang(Lang.from((String)lang));
                }
                payload.remove("_requestContext_");
            }
        }
        return payload;
    }
}

