/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.jobexecutor.AbstractJobHandler;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class AsyncContinuationJobHandler
extends AbstractJobHandler {
    public static final String TYPE = "async-continuation";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        if (!this.executionExist(execution, job) || !execution.isActive() && execution.hasVariableLocal("unActiveType")) {
            this.log.debug(String.format("execution[%s] is not active or not exist!", execution));
            job.setExceptionMessage(String.format("execution[%s] is not active or not exist!", execution));
            return;
        }
        String currentActivityId = this.getCurrentActivityId(execution);
        if (WfUtils.isNotEmpty(job.getElementId()) && !job.getElementId().equalsIgnoreCase(currentActivityId)) {
            job.setExceptionMessage(String.format(ResManager.loadKDString((String)"%s[\u91cd\u590d\u6d88\u606f]", (String)"AsyncContinuationJobHandler_1", (String)"bos-wf-engine", (Object[])new Object[0]), WfUtils.isEmpty(job.getExceptionMessage()) ? "" : job.getExceptionMessage()));
            return;
        }
        this.restoreContext(configuration);
        Context.getAgenda().planContinueProcessSynchronousOperation(execution);
        try {
            FlowElement ele = ProcessDefinitionUtil.getFlowElement(execution.getProcessDefinitionId(), execution.getProcessInstanceId(), currentActivityId);
            if ("EndNoneEvent".equals(ele.getType()) || "EndTerminateEvent".equals(ele.getType())) {
                final String businesskey = execution.getBusinessKey();
                final String entityNumber = execution.getEntityNumber();
                commandContext.addCloseListener(new DefaultCommandContextCloseListener("end-delete-cache"){

                    @Override
                    public void closed(CommandContext commandContext) {
                        super.closed(commandContext);
                        WfCacheHelper.removeExecutingJobGYEntityOfCurrentBusiness(businesskey, entityNumber);
                        this.log.debug("\u5220\u9664\u7f13\u5b58\uff1a" + businesskey + "-" + entityNumber);
                    }
                });
            }
        }
        catch (Exception e) {
            this.log.warn("AsyncContinuationJobHandler error:" + WfUtils.getExceptionStacktrace(e));
        }
    }
}

