/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.impl.asyncexecutor.AsyncExecutor;
import kd.bos.workflow.engine.impl.cfg.TransactionPropagation;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandContextCloseListener;
import kd.bos.workflow.engine.impl.interceptor.CommandExecutor;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;

public class AsyncJobAddedNotification
implements CommandContextCloseListener {
    private static Log log = LogFactory.getLog(AsyncJobAddedNotification.class);
    protected JobEntity job;
    protected AsyncExecutor asyncExecutor;

    public AsyncJobAddedNotification(JobEntity job, AsyncExecutor asyncExecutor) {
        this.job = job;
        this.asyncExecutor = asyncExecutor;
    }

    @Override
    public void closed(CommandContext commandContext) {
        CommandExecutor commandExecutor = commandContext.getProcessEngineConfiguration().getCommandExecutor();
        CommandConfig commandConfig = new CommandConfig(false, TransactionPropagation.REQUIRES_NEW);
        commandExecutor.execute(commandConfig, new Command<Void>(){

            @Override
            public Void execute(CommandContext commandContext) {
                log.debug("notifying job executor of new job");
                AsyncJobAddedNotification.this.asyncExecutor.executeAsyncJob(AsyncJobAddedNotification.this.job);
                return null;
            }
        });
    }

    @Override
    public void closing(CommandContext commandContext) {
        log.debug("closing...");
    }

    @Override
    public void afterSessionsFlush(CommandContext commandContext) {
        log.debug("afterSessionsFlush...");
    }

    @Override
    public void closeFailure(CommandContext commandContext) {
        log.debug("closeFailure...");
    }
}

