/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.model.AutoCoordinate;
import kd.bos.workflow.bpmn.model.AutoCoordinateModel;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CustomParam;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfConstanst;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.cmd.task.TaskCoordinateRequestCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.AbstractJobHandler;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class AutoCoordinateJobHandler
extends AbstractJobHandler {
    public static final String TYPE = "async-autoCoordinate";
    public static final String AUTOCOORDINATORIDS = "autoCoordinatorIds";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        if (job == null) {
            this.log.warn(String.format("\u53d1\u9001\u81ea\u52a8%s\u6d88\u606f\u524d\u53c2\u6570Job\u4e3anull", WfConfigurationUtil.getCoordinateName()));
            return;
        }
        if (!this.executionExist(execution, job)) {
            return;
        }
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(job.getProcessDefinitionId(), job.getProcessInstanceId());
        UserTask userTask = (UserTask)bpmnModel.getFlowElement(job.getElementId());
        Map<String, Object> payload = this.restoreContext(configuration);
        Long taskId = (Long)payload.get("taskId");
        TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
        if (taskEntity == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u201c%1$s\u201d\u5df2\u5904\u7406\uff0c\u65e0\u6cd5\u5bf9\u5f53\u524d\u4efb\u52a1\u8fdb\u884c\u81ea\u52a8%2$s\u3002", (String)"AutoCoordinateJobHandler_1", (String)"bos-wf-engine", (Object[])new Object[0]), taskId, WfConfigurationUtil.getCoordinateName());
            this.log.debug(msg);
            job.setExceptionMessage(msg);
            return;
        }
        List autoCoordinatorIds = (List)payload.get(AUTOCOORDINATORIDS);
        List<Object> userIds = new ArrayList();
        if (autoCoordinatorIds != null && !autoCoordinatorIds.isEmpty()) {
            for (Object autoCoordinatorId : autoCoordinatorIds) {
                userIds.add(Long.valueOf(autoCoordinatorId.toString()));
            }
        } else {
            userIds = TaskBehaviorUtil.calcAutoCoordinatorIds(commandContext, execution, taskEntity, userTask);
        }
        if (userIds == null || userIds.isEmpty()) {
            String msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u201c%1$s\u201d\u53ef\u4ee5\u53d1\u8d77\u81ea\u52a8%2$s\u7684\u53c2\u4e0e\u4eba\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u8d77\u81ea\u52a8%3$s\u3002", (String)"AutoCoordinateJobHandler_2", (String)"bos-wf-engine", (Object[])new Object[0]), taskId, WfConfigurationUtil.getCoordinateName(), WfConfigurationUtil.getCoordinateName());
            this.log.debug(msg);
            job.setExceptionMessage(msg);
            return;
        }
        AutoCoordinateModel autoCoordinateModel = userTask.getAutoCoordinateModel();
        if (autoCoordinateModel != null && autoCoordinateModel.getAutoCoordinate() != null && autoCoordinateModel.getAutoCoordinate().getParticipant() != null) {
            AutoCoordinate autoCoordinate = autoCoordinateModel.getAutoCoordinate();
            String businessKey = execution.getBusinessKey();
            LocaleString suggestion = new LocaleString();
            String suggestionMultiKey = String.format("%s.autoCoordinateModel.autoCoordinate.suggestion", execution.getActivityId());
            ILocaleString suggestionExpression = BpmnModelUtil.getMultiLangFieldValue(execution.getProcessInstanceId(), suggestionMultiKey, autoCoordinate.getSuggestion());
            if (WfUtils.isEmpty(suggestionExpression)) {
                suggestionExpression = new LocaleString(autoCoordinate.getSuggestion());
            }
            DynamicObject dynamicObject = WfUtils.findBusinessObject(businessKey, execution.getEntityNumber());
            for (String key : suggestionExpression.keySet()) {
                String suggestionParser = ExpressionCalculatorUtil.contentParser((String)suggestionExpression.get((Object)key), dynamicObject, execution, true);
                suggestion.setItem(key, (Object)suggestionParser);
            }
            Long ownerId = WfConstanst.ADMIN;
            Boolean isPublic = Boolean.FALSE;
            Boolean isAuto = Boolean.TRUE;
            Map<String, Object> map = this.parseCustomParams(userTask, taskEntity, commandContext);
            if (map != null) {
                isAuto = Boolean.FALSE;
                ownerId = (Long)map.get("ownerId");
                isPublic = (Boolean)map.get("isPublic");
                if (map.get("taskId") != null) {
                    taskId = (Long)map.get("taskId");
                }
            }
            new TaskCoordinateRequestCmd(taskId, Boolean.FALSE, userIds, (ILocaleString)suggestion, ownerId, isPublic, isAuto).execute(commandContext);
        }
    }

    private Map<String, Object> parseCustomParams(UserTask userTask, TaskEntity taskEntity, CommandContext commandContext) {
        List<CustomParam> customParams = userTask.getCustomParams();
        if (customParams == null || customParams.isEmpty()) {
            return null;
        }
        CustomParam ownerIdParam = null;
        CustomParam isPublicParam = null;
        StringBuilder sb = new StringBuilder();
        for (CustomParam customParam : customParams) {
            if ("autoCoordinateOwnerId".equals(customParam.getNumber())) {
                ownerIdParam = customParam;
                sb.append("isPublic=").append(customParam.getValue()).append(";");
            } else if ("autoCoordinateIsPublic".equals(customParam.getNumber())) {
                isPublicParam = customParam;
                sb.append("ownerId=").append(customParam.getValue()).append(";");
            }
            if (ownerIdParam == null || isPublicParam == null) continue;
            break;
        }
        this.log.debug("customParams:" + sb);
        if (ownerIdParam == null) {
            return null;
        }
        Long value = Long.valueOf(ownerIdParam.getValue());
        if (!taskEntity.getParticipants().contains(value)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if ("YunzhijiaTask".equals(taskEntity.getCategory())) {
            List<IdentityLinkEntity> identityLinks = commandContext.getIdentityLinkEntityManager().findIdentityLinksByParentTaskId(taskEntity.getId());
            for (IdentityLinkEntity identityLinkEntity : identityLinks) {
                if (!identityLinkEntity.getUserId().equals(value)) continue;
                map.put("taskId", identityLinkEntity.getTaskId());
                break;
            }
            if (map.get("taskId") == null) {
                return null;
            }
        }
        map.put("ownerId", value);
        if (isPublicParam != null) {
            map.put("isPublic", Boolean.parseBoolean(isPublicParam.getValue()));
        }
        return map;
    }

    public String getName() {
        return ResManager.loadKDString((String)"\u81ea\u52a8\u534f\u529e", (String)"AutoCoordinateJobHandler_3", (String)"bos-wf-engine", (Object[])new Object[0]);
    }
}

