/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.AbstractJobHandler;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class CirculateJobHandler
extends AbstractJobHandler {
    public static final String TYPE = "async-circulate";
    public static final String CIRCULATIONMSG = "circulationMsg";
    public static final String TASKID = "taskId";
    public static final String USERIDS = "userIds";
    private Log logger = LogFactory.getLog((String)this.getClass().getName());

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        if (job == null) {
            this.log.error("\u53d1\u9001\u81ea\u52a8\u4f20\u9605\u6d88\u606f\u524d\u53c2\u6570Job\u4e3anull");
            return;
        }
        if (!this.executionExist(execution, job)) {
            return;
        }
        ProcessEngineConfigurationImpl processEngineConfigurationImpl = commandContext.getProcessEngineConfiguration();
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(job.getProcessDefinitionId(), job.getProcessInstanceId());
        UserTask userTask = (UserTask)bpmnModel.getFlowElement(job.getElementId());
        Map<String, Object> payload = this.restoreContext(configuration);
        Long taskId = (Long)payload.get(TASKID);
        Object suggestion = payload.get(CIRCULATIONMSG);
        LocaleString circulationMsg = null;
        if (suggestion != null) {
            circulationMsg = LocaleString.fromMap((Map)((Map)suggestion));
        }
        ArrayList<Long> userIds = new ArrayList<Long>();
        List uIds = (List)payload.get(USERIDS);
        if (CollectionUtil.isNotEmpty(uIds)) {
            for (Object o : uIds) {
                userIds.add(Long.valueOf(o.toString()));
            }
        }
        this.logger.debug(String.format("\u5f02\u6b65\u5904\u7406\u5df2\u63a5\u6536\u5e76\u5904\u7406\u81ea\u52a8\u4f20\u9605\u53c2\u6570\uff1auserTask\uff1a%s\uff0ctaskId\uff1a%s\uff0cuserIds\uff1a%s\uff0csuggestion\uff1a%s", userTask, taskId, userIds, circulationMsg));
        processEngineConfigurationImpl.getTaskHelper().taskAutoCirculate(commandContext, userTask, execution, taskId, userIds, (ILocaleString)circulationMsg);
    }
}

