/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SuspendType;
import kd.bos.workflow.engine.runtime.Job;

public class DeadLetterJobHandler {
    private DeadLetterJobHandler() {
    }

    public static void handleDeadLetterJob(Job job, CommandContext commandContext) {
        if (job != null && WfUtils.isNotEmpty(job.getProcessInstanceId())) {
            commandContext.getExecutionEntityManager().setProcessInstanceState(job.getProcessInstanceId(), ManagementConstants.SUSPENDED);
        }
    }

    public static void recordDurationDetail(CommandContext commandContext, DeadLetterJobEntity deadLetterJob) {
        Long processInstanceId;
        if (deadLetterJob != null && WfUtils.isNotEmpty(processInstanceId = deadLetterJob.getProcessInstanceId())) {
            LocaleString suspendReason = new LocaleString(deadLetterJob.getExceptionMessage());
            commandContext.getDurationDetailEntityManager().insertDurationDetail(processInstanceId, (ILocaleString)suspendReason, SuspendType.ERRORSUSPEND.getCode(), deadLetterJob.getErrorType());
        }
    }
}

