/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import kd.bos.workflow.engine.impl.cmd.job.JobImmediateReSendCmd;
import kd.bos.workflow.engine.impl.cmd.job.JobRetryCmd;
import kd.bos.workflow.engine.impl.cmd.job.SendTerminateProcessJobCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.jobexecutor.ErrorHandlerStrategy;
import kd.bos.workflow.engine.impl.jobexecutor.FailedJobCommandFactory;
import kd.bos.workflow.engine.impl.jobexecutor.RetryType;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.exception.ExceptionUtil;

public class DefaultFailedJobCommandFactory
implements FailedJobCommandFactory {
    @Override
    public Command<Object> getCommand(ExecuteJob job, Throwable exception) {
        ErrorHandlerStrategy strategy = ExceptionUtil.getErrorHandleStrategy(job, exception);
        if (strategy != null) {
            String retryType = strategy.getRetryType();
            if (RetryType.IMMEDIATELY.getCode().equals(retryType)) {
                return new JobImmediateReSendCmd(job, exception, strategy);
            }
            if (RetryType.TERMINATE.getCode().equals(retryType)) {
                return new SendTerminateProcessJobCmd(job, exception, strategy);
            }
        }
        return new JobRetryCmd(job, exception, strategy);
    }
}

