/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.WaitTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.event.util.WaitEventUtil;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class DelayBroadcastJobHandler {
    public static final String TYPE = "delay-broadcast";
    private Log log = LogFactory.getLog(this.getClass());

    public void insertDelayBroadcastJob(CommandContext commandContext, Long executionId, String eventNumber, Map<String, Object> payload) {
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(executionId);
        JobEntity jobEntity = commandContext.getJobManager().createDelayBroadcastJob(execution, payload);
        jobEntity.setOperation(eventNumber);
        jobEntity.setBizTraceNo(execution.getBizTraceNo());
        jobEntity.setEndTime(WfUtils.now());
        commandContext.getJobEntityManager().insert(jobEntity);
    }

    public boolean consumeDelayBroadcastJob(CommandContext commandContext, ExecutionEntity execution, WaitTask waitTask) {
        QFilter[] qFilters;
        List entities;
        JobEntityManager jobManager = commandContext.getJobEntityManager();
        String eventNumber = waitTask.getTimingModel().getEvent();
        HashSet<String> businesskeys = new HashSet<String>();
        businesskeys.add(execution.getBusinessKey());
        if (ModelType.BizFlow.name().equalsIgnoreCase(execution.getProcessType())) {
            businesskeys.addAll(commandContext.getExeConversionEntityManager().getAllConversionBusinesskeys(execution.getBizTraceNo()));
        }
        if ((entities = jobManager.findByQueryFilters(qFilters = new QFilter[]{new QFilter("jobHandlerType", "=", (Object)TYPE), new QFilter("operation", "=", (Object)eventNumber), new QFilter("businessKey", "in", businesskeys)})).isEmpty()) {
            this.log.debug(String.format("findDelayBroadcastJob: entities is empty.%s", WfUtils.listToString(businesskeys, ",")));
            return false;
        }
        for (JobEntity entity : entities) {
            String configuration = entity.getJobHandlerConfiguration();
            if (WfUtils.isEmpty(configuration)) {
                this.log.debug(String.format("findDelayBroadcastJob: entityId: %s configuration is empty.", entity.getId()));
                continue;
            }
            Map config = (Map)SerializationUtils.fromJsonString((String)configuration, Map.class);
            String scope = (String)config.get("scope");
            String biztraceNo = (String)config.get("biztraceno");
            String traceNo = (String)execution.getVariable("biztraceno");
            this.log.debug(String.format("entityId: %s, scope: %s, biztraceNo: %s, traceNo: %s", entity.getId(), scope, biztraceNo, traceNo));
            if ("bizTraceNo".equals(scope) && biztraceNo != null && biztraceNo.equals(traceNo) || execution.getProcessInstanceId().equals(entity.getProcessInstanceId())) {
                boolean ret = WaitEventUtil.hasTrueEventCondition(waitTask, execution, config);
                this.log.debug(String.format("condition result: %s", ret));
                if (!ret) continue;
                entity.setSuccess(true);
                entity.setEndTime(WfUtils.now());
                HashMap<String, Object> consumer = new HashMap<String, Object>();
                consumer.put("procInstId", execution.getProcessInstanceId());
                consumer.put("executionId", execution.getId());
                consumer.put("activityId", waitTask.getId());
                consumer.put("entityNumber", execution.getEntityNumber());
                consumer.put("businessKey", execution.getBusinessKey());
                config.put("consumer", consumer);
                entity.setJobHandlerConfiguration(SerializationUtils.toJsonString((Object)config));
                jobManager.update(entity);
                return true;
            }
            this.log.debug(String.format("mismatch entityId: %s config: %s", entity.getId(), config));
        }
        return false;
    }
}

