/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.bpmn.listener.AddressJobFailListner;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.AbstractJobHandler;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessConfigEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessConfigEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;

public class EventAddressProcessJobHandler
extends AbstractJobHandler {
    public static final String TYPE = "event-address-process";
    public static final String KEY_BUSINESSKEY = "businessKey";
    public static final String KEY_EVENTNUMBER = "eventNumber";
    public static final String KEY_ENTITYNUMBER = "entityNumber";
    public static final String KEY_TARGETPROCENTITYNUMBER = "targetProcEntityNumber";
    public static final String KEY_VARIABLES = "variables";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        Map<String, Object> payload = this.restoreContext(configuration);
        String businessKey = null;
        String eventNumber = null;
        String entityNumber = null;
        String targetProcEntityNumber = null;
        HashMap<String, Object> variables = null;
        if (payload != null) {
            ProcessConfigEntityManager processConfigManager;
            List<ProcessConfigEntity> processConfigs;
            variables = (HashMap<String, Object>)payload.get(KEY_VARIABLES);
            businessKey = (String)payload.get(KEY_BUSINESSKEY);
            eventNumber = (String)payload.get(KEY_EVENTNUMBER);
            entityNumber = (String)payload.get(KEY_ENTITYNUMBER);
            targetProcEntityNumber = (String)variables.get(KEY_TARGETPROCENTITYNUMBER);
            String bizTraceNo = (String)variables.get("biztraceno");
            if (WfUtils.isEmpty(targetProcEntityNumber)) {
                targetProcEntityNumber = entityNumber;
            }
            QFilter[] qFilters = new QFilter[]{new QFilter(KEY_BUSINESSKEY, "=", (Object)businessKey)};
            HashSet<Long> existDefs = new HashSet<Long>(5);
            DynamicObjectCollection cols = QueryServiceHelper.query((String)"wf_execution", (String)String.format("%s", "processDefinitionId"), (QFilter[])qFilters);
            if (cols != null && !cols.isEmpty()) {
                for (DynamicObject dn : cols) {
                    existDefs.add(dn.getLong("processDefinitionId"));
                }
            }
            if (WfUtils.isNotEmpty(bizTraceNo)) {
                ExecutionEntityManager executionManager = commandContext.getExecutionEntityManager();
                EntityQueryBuilder executionQueryBuilder = executionManager.createQueryBuilder();
                executionQueryBuilder.addFilter(KEY_ENTITYNUMBER, entityNumber);
                executionQueryBuilder.addFilter("biztraceno", bizTraceNo);
                executionQueryBuilder.addFilter("scope", Boolean.TRUE);
                List processInstances = executionManager.findByQueryBuilder(executionQueryBuilder);
                if (processInstances != null && !processInstances.isEmpty()) {
                    boolean canUse;
                    ExecutionEntity processInstance = (ExecutionEntity)processInstances.get(0);
                    Long preProinstanceId = (Long)variables.get("processInstanceId");
                    boolean bl = canUse = !existDefs.contains(processInstance.getProcessDefinitionId()) || preProinstanceId > 0L && !preProinstanceId.equals(processInstance.getId());
                    if (canUse) {
                        Process process = ProcessDefinitionUtil.getProcess(processInstance.getProcessDefinitionId(), processInstance.getId());
                        FlowElement initialElement = process.getInitialFlowElement();
                        BizFlowUtil.createBillExecutionAndContinue(commandContext, processInstance, initialElement, entityNumber, businessKey);
                        commandContext.addCloseListener(new AddressJobFailListner(job));
                        return;
                    }
                }
            }
            if ((processConfigs = (processConfigManager = commandContext.getProcessConfigEntityManager()).findProcessConfigByEventAndTargetEntity(eventNumber, targetProcEntityNumber)) != null && !processConfigs.isEmpty()) {
                ProcessConfigEntity noCondition = null;
                ProcessConfigEntity matchCondition = null;
                BusinessModelVariableScope bizScope = new BusinessModelVariableScope(businessKey, entityNumber);
                for (ProcessConfigEntity processConfig : processConfigs) {
                    if (noCondition == null && WfUtils.isEmpty(processConfig.getStartCondition())) {
                        noCondition = processConfig;
                    }
                    if (!WfUtils.isNotEmpty(processConfig.getStartCondition())) continue;
                    try {
                        bizScope.setVariable("processDefinitionId", processConfig.getProcDefId());
                        bizScope.setVariable("env", true);
                        boolean ret = ConditionUtil.hasTrueCondition(processConfig.getStartCondition(), (VariableScope)bizScope, "addressProcess");
                        if (!ret) continue;
                        matchCondition = processConfig;
                        break;
                    }
                    catch (Exception e) {
                        this.log.error(String.format("evt parse condition error, condition is [%s][%s]!", processConfig.getStartCondition(), processConfig.getProcDefId()));
                    }
                }
                if (matchCondition == null && noCondition == null) {
                    this.log.debug("no matched process!");
                    commandContext.addCloseListener(new AddressJobFailListner(job));
                    return;
                }
                Long procDefId = null;
                if (matchCondition != null) {
                    procDefId = matchCondition.getProcDefId();
                } else {
                    procDefId = noCondition.getProcDefId();
                    this.log.debug("no matched process, use latest no condition process!");
                }
                if (existDefs.contains(procDefId)) {
                    String msg = String.format("bill[ %s %s] is already in the process[%s]!", entityNumber, businessKey, procDefId);
                    this.log.debug(msg);
                    job.setExceptionMessage(msg);
                    commandContext.addCloseListener(new AddressJobFailListner(job));
                    return;
                }
                ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(procDefId);
                Long schemeId = BpmnModelUtil.filterSchemeByProcdefId(commandContext, procDefId, bizScope);
                if (variables == null) {
                    variables = new HashMap<String, Object>();
                }
                Long initiatorId = null;
                try {
                    Object initiator = variables.get("_initiator_");
                    if (initiator != null) {
                        initiatorId = Long.valueOf(initiator.toString());
                    }
                }
                catch (Exception e) {
                    this.log.error(WfUtils.getExceptionStacktrace(e));
                }
                variables.put("_businessKey_", businessKey);
                variables.put("_entityNumber_", entityNumber);
                variables.put("_initiator_", WfUtils.isEmpty(initiatorId) ? RequestContext.get().getUserId() : String.valueOf(initiatorId));
                variables.put("_eventNumber_", eventNumber);
                variables.put("SCHEMEID", schemeId);
                variables.put("bizFlowStartUpWay", "event");
                variables.put("biztraceno", bizTraceNo);
                String key = String.format("%s.%s", processDefinition.getKey(), targetProcEntityNumber);
                commandContext.getProcessEngineConfiguration().getRuntimeService().signalEventReceived(key, processDefinition.getVersion(), variables);
            } else {
                commandContext.addCloseListener(new AddressJobFailListner(job));
                this.log.debug("no process config can be found!");
            }
        } else {
            commandContext.addCloseListener(new AddressJobFailListner(job));
            this.log.debug("payload is null!");
        }
    }
}

