/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.AbstractJobHandler;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.task.center.operation.IOperation;
import kd.bos.workflow.engine.task.center.operation.OperationsRegister;
import kd.bos.workflow.engine.task.center.operation.ctx.OperationContext;

public class ExpireModelJobHandler
extends AbstractJobHandler {
    public static final String TYPE = "expireModelJobHandler";
    public static final String TASKID = "taskId";
    public static final String OPERATIONNUMBER = "operationNumber";
    public static final String OPERATIONCONFIG = "operationConfig";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        Map<String, Object> payload = this.restoreContext(configuration);
        Long taskId = (Long)payload.get(TASKID);
        String operationJson = job.getJobHandlerConfiguration();
        if (WfUtils.isNotEmpty(operationJson)) {
            Map m = (Map)SerializationUtils.fromJsonString((String)operationJson, Map.class);
            IOperation o = OperationsRegister.getInstance().getOperation(m.get(OPERATIONNUMBER).toString());
            OperationContext cxt = new OperationContext();
            cxt.setBusinessKey(job.getBusinessKey());
            cxt.setElementId(job.getElementId());
            cxt.setEntityNumber(job.getEntityNumber());
            cxt.setProcessDefinitionId(job.getProcessDefinitionId());
            cxt.setProcessInstanceId(job.getProcessInstanceId());
            cxt.setTaskId(taskId);
            Map<String, Object> params = new HashMap<String, Object>();
            if (m.get(OPERATIONCONFIG) != null) {
                params = (Map)SerializationUtils.fromJsonString((String)m.get(OPERATIONCONFIG).toString(), Map.class);
            }
            o.execute(cxt, params);
        }
    }
}

